/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan;

import java.util.List;
import org.springframework.ai.bedrock.MessageToPromptConverter;
import org.springframework.ai.bedrock.titan.BedrockTitanChatOptions;
import org.springframework.ai.bedrock.titan.api.TitanChatBedrockApi;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class BedrockTitanChatModel
implements ChatModel,
StreamingChatModel {
    private final TitanChatBedrockApi chatApi;
    private final BedrockTitanChatOptions defaultOptions;

    public BedrockTitanChatModel(TitanChatBedrockApi chatApi) {
        this(chatApi, BedrockTitanChatOptions.builder().withTemperature(Float.valueOf(0.8f)).build());
    }

    public BedrockTitanChatModel(TitanChatBedrockApi chatApi, BedrockTitanChatOptions defaultOptions) {
        Assert.notNull((Object)chatApi, (String)"ChatApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"DefaultOptions must not be null");
        this.chatApi = chatApi;
        this.defaultOptions = defaultOptions;
    }

    public ChatResponse call(Prompt prompt) {
        TitanChatBedrockApi.TitanChatResponse response = this.chatApi.chatCompletion(this.createRequest(prompt));
        List<Generation> generations = response.results().stream().map(result -> new Generation(result.outputText())).toList();
        return new ChatResponse(generations);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return this.chatApi.chatCompletionStream(this.createRequest(prompt)).map(chunk -> {
            Generation generation = new Generation(chunk.outputText());
            if (chunk.amazonBedrockInvocationMetrics() != null) {
                String completionReason = chunk.completionReason().name();
                generation = generation.withGenerationMetadata(ChatGenerationMetadata.from((String)completionReason, (Object)chunk.amazonBedrockInvocationMetrics()));
            } else if (chunk.inputTextTokenCount() != null && chunk.totalOutputTextTokenCount() != null) {
                String completionReason = chunk.completionReason().name();
                generation = generation.withGenerationMetadata(ChatGenerationMetadata.from((String)completionReason, (Object)this.extractUsage((TitanChatBedrockApi.TitanChatResponseChunk)chunk)));
            }
            return new ChatResponse(List.of(generation));
        });
    }

    TitanChatBedrockApi.TitanChatRequest createRequest(Prompt prompt) {
        String promptValue = MessageToPromptConverter.create().toPrompt(prompt.getInstructions());
        TitanChatBedrockApi.TitanChatRequest.Builder requestBuilder = TitanChatBedrockApi.TitanChatRequest.builder(promptValue);
        if (this.defaultOptions != null) {
            requestBuilder = this.update(requestBuilder, this.defaultOptions);
        }
        if (prompt.getOptions() != null) {
            ModelOptions modelOptions = prompt.getOptions();
            if (modelOptions instanceof ChatOptions) {
                ChatOptions runtimeOptions = (ChatOptions)modelOptions;
                BedrockTitanChatOptions updatedRuntimeOptions = (BedrockTitanChatOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, ChatOptions.class, BedrockTitanChatOptions.class);
                requestBuilder = this.update(requestBuilder, updatedRuntimeOptions);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type ChatOptions: " + prompt.getOptions().getClass().getSimpleName());
            }
        }
        return requestBuilder.build();
    }

    private TitanChatBedrockApi.TitanChatRequest.Builder update(TitanChatBedrockApi.TitanChatRequest.Builder builder, BedrockTitanChatOptions options) {
        if (options.getTemperature() != null) {
            builder.withTemperature(options.getTemperature());
        }
        if (options.getTopP() != null) {
            builder.withTopP(options.getTopP());
        }
        if (options.getMaxTokenCount() != null) {
            builder.withMaxTokenCount(options.getMaxTokenCount());
        }
        if (options.getStopSequences() != null) {
            builder.withStopSequences(options.getStopSequences());
        }
        return builder;
    }

    private Usage extractUsage(final TitanChatBedrockApi.TitanChatResponseChunk response) {
        return new Usage(){

            public Long getPromptTokens() {
                return response.inputTextTokenCount().longValue();
            }

            public Long getGenerationTokens() {
                return response.totalOutputTextTokenCount().longValue();
            }
        };
    }

    public ChatOptions getDefaultOptions() {
        return BedrockTitanChatOptions.fromOptions(this.defaultOptions);
    }
}

