/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.llama;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockLlamaChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    @JsonProperty(value="max_gen_len")
    private Integer maxGenLen;

    public static Builder builder() {
        return new Builder();
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getMaxGenLen() {
        return this.maxGenLen;
    }

    public void setMaxGenLen(Integer maxGenLen) {
        this.maxGenLen = maxGenLen;
    }

    @JsonIgnore
    public Integer getTopK() {
        throw new UnsupportedOperationException("Unsupported option: 'TopK'");
    }

    @JsonIgnore
    public void setTopK(Integer topK) {
        throw new UnsupportedOperationException("Unsupported option: 'TopK'");
    }

    public static BedrockLlamaChatOptions fromOptions(BedrockLlamaChatOptions fromOptions) {
        return BedrockLlamaChatOptions.builder().withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withMaxGenLen(fromOptions.getMaxGenLen()).build();
    }

    public static class Builder {
        private BedrockLlamaChatOptions options = new BedrockLlamaChatOptions();

        public Builder withTemperature(Float temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withMaxGenLen(Integer maxGenLen) {
            this.options.setMaxGenLen(maxGenLen);
            return this;
        }

        public BedrockLlamaChatOptions build() {
            return this.options;
        }
    }
}

