/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.jurassic2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockAi21Jurassic2ChatOptions
implements ChatOptions {
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="numResults")
    private Integer numResults;
    @JsonProperty(value="maxTokens")
    private Integer maxTokens;
    @JsonProperty(value="minTokens")
    private Integer minTokens;
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="topP")
    private Float topP;
    @JsonProperty(value="topKReturn")
    private Integer topK;
    @JsonProperty(value="stopSequences")
    private String[] stopSequences;
    @JsonProperty(value="frequencyPenalty")
    private Penalty frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private Penalty presencePenalty;
    @JsonProperty(value="countPenalty")
    private Penalty countPenalty;

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getNumResults() {
        return this.numResults;
    }

    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMinTokens() {
        return this.minTokens;
    }

    public void setMinTokens(Integer minTokens) {
        this.minTokens = minTokens;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public String[] getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(String[] stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Penalty getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Penalty frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Penalty getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Penalty presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Penalty getCountPenalty() {
        return this.countPenalty;
    }

    public void setCountPenalty(Penalty countPenalty) {
        this.countPenalty = countPenalty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BedrockAi21Jurassic2ChatOptions fromOptions(BedrockAi21Jurassic2ChatOptions fromOptions) {
        return BedrockAi21Jurassic2ChatOptions.builder().withPrompt(fromOptions.getPrompt()).withNumResults(fromOptions.getNumResults()).withMaxTokens(fromOptions.getMaxTokens()).withMinTokens(fromOptions.getMinTokens()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).withStopSequences(fromOptions.getStopSequences()).withFrequencyPenalty(fromOptions.getFrequencyPenalty()).withPresencePenalty(fromOptions.getPresencePenalty()).withCountPenalty(fromOptions.getCountPenalty()).build();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Penalty(@JsonProperty(value="scale") Float scale, @JsonProperty(value="applyToNumbers") Boolean applyToNumbers, @JsonProperty(value="applyToPunctuations") Boolean applyToPunctuations, @JsonProperty(value="applyToStopwords") Boolean applyToStopwords, @JsonProperty(value="applyToWhitespaces") Boolean applyToWhitespaces, @JsonProperty(value="applyToEmojis") Boolean applyToEmojis) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Float scale;
            private Boolean applyToNumbers = true;
            private Boolean applyToPunctuations = true;
            private Boolean applyToStopwords = true;
            private Boolean applyToWhitespaces = true;
            private Boolean applyToEmojis = true;

            public Builder scale(Float scale) {
                this.scale = scale;
                return this;
            }

            public Builder applyToNumbers(Boolean applyToNumbers) {
                this.applyToNumbers = applyToNumbers;
                return this;
            }

            public Builder applyToPunctuations(Boolean applyToPunctuations) {
                this.applyToPunctuations = applyToPunctuations;
                return this;
            }

            public Builder applyToStopwords(Boolean applyToStopwords) {
                this.applyToStopwords = applyToStopwords;
                return this;
            }

            public Builder applyToWhitespaces(Boolean applyToWhitespaces) {
                this.applyToWhitespaces = applyToWhitespaces;
                return this;
            }

            public Builder applyToEmojis(Boolean applyToEmojis) {
                this.applyToEmojis = applyToEmojis;
                return this;
            }

            public Penalty build() {
                return new Penalty(this.scale, this.applyToNumbers, this.applyToPunctuations, this.applyToStopwords, this.applyToWhitespaces, this.applyToEmojis);
            }
        }
    }

    public static class Builder {
        private final BedrockAi21Jurassic2ChatOptions request = new BedrockAi21Jurassic2ChatOptions();

        public Builder withPrompt(String prompt) {
            this.request.setPrompt(prompt);
            return this;
        }

        public Builder withNumResults(Integer numResults) {
            this.request.setNumResults(numResults);
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.request.setMaxTokens(maxTokens);
            return this;
        }

        public Builder withMinTokens(Integer minTokens) {
            this.request.setMinTokens(minTokens);
            return this;
        }

        public Builder withTemperature(Float temperature) {
            this.request.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Float topP) {
            this.request.setTopP(topP);
            return this;
        }

        public Builder withStopSequences(String[] stopSequences) {
            this.request.setStopSequences(stopSequences);
            return this;
        }

        public Builder withTopK(Integer topKReturn) {
            this.request.setTopK(topKReturn);
            return this;
        }

        public Builder withFrequencyPenalty(Penalty frequencyPenalty) {
            this.request.setFrequencyPenalty(frequencyPenalty);
            return this;
        }

        public Builder withPresencePenalty(Penalty presencePenalty) {
            this.request.setPresencePenalty(presencePenalty);
            return this;
        }

        public Builder withCountPenalty(Penalty countPenalty) {
            this.request.setCountPenalty(countPenalty);
            return this;
        }

        public BedrockAi21Jurassic2ChatOptions build() {
            return this.request;
        }
    }
}

