/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingOptions;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;

public class BedrockCohereEmbeddingModel
extends AbstractEmbeddingModel {
    private final CohereEmbeddingBedrockApi embeddingApi;
    private final BedrockCohereEmbeddingOptions defaultOptions;

    public BedrockCohereEmbeddingModel(CohereEmbeddingBedrockApi cohereEmbeddingBedrockApi) {
        this(cohereEmbeddingBedrockApi, BedrockCohereEmbeddingOptions.builder().withInputType(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.InputType.SEARCH_DOCUMENT).withTruncate(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.NONE).build());
    }

    public BedrockCohereEmbeddingModel(CohereEmbeddingBedrockApi cohereEmbeddingBedrockApi, BedrockCohereEmbeddingOptions options) {
        Assert.notNull((Object)cohereEmbeddingBedrockApi, (String)"CohereEmbeddingBedrockApi must not be null");
        Assert.notNull((Object)options, (String)"BedrockCohereEmbeddingOptions must not be null");
        this.embeddingApi = cohereEmbeddingBedrockApi;
        this.defaultOptions = options;
    }

    public List<Double> embed(Document document) {
        return this.embed(document.getContent());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        BedrockCohereEmbeddingOptions optionsToUse = this.mergeOptions(request.getOptions());
        CohereEmbeddingBedrockApi.CohereEmbeddingRequest apiRequest = new CohereEmbeddingBedrockApi.CohereEmbeddingRequest(request.getInstructions(), optionsToUse.getInputType(), optionsToUse.getTruncate());
        CohereEmbeddingBedrockApi.CohereEmbeddingResponse apiResponse = this.embeddingApi.embedding(apiRequest);
        AtomicInteger indexCounter = new AtomicInteger(0);
        List<Embedding> embeddings = apiResponse.embeddings().stream().map(e -> new Embedding(e, Integer.valueOf(indexCounter.getAndIncrement()))).toList();
        return new EmbeddingResponse(embeddings);
    }

    BedrockCohereEmbeddingOptions mergeOptions(EmbeddingOptions requestOptions) {
        BedrockCohereEmbeddingOptions options;
        BedrockCohereEmbeddingOptions bedrockCohereEmbeddingOptions = options = this.defaultOptions != null ? this.defaultOptions : BedrockCohereEmbeddingOptions.builder().withInputType(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.InputType.SEARCH_DOCUMENT).withTruncate(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.NONE).build();
        if (requestOptions != null && !EmbeddingOptions.EMPTY.equals(requestOptions)) {
            options = (BedrockCohereEmbeddingOptions)ModelOptionsUtils.merge((Object)requestOptions, (Object)options, BedrockCohereEmbeddingOptions.class);
        }
        return options;
    }
}

