/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.bedrock.cohere.api.CohereChatBedrockApi;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockCohereChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    Float temperature;
    @JsonProperty(value="p")
    Float topP;
    @JsonProperty(value="k")
    Integer topK;
    @JsonProperty(value="max_tokens")
    Integer maxTokens;
    @JsonProperty(value="stop_sequences")
    List<String> stopSequences;
    @JsonProperty(value="return_likelihoods")
    CohereChatBedrockApi.CohereChatRequest.ReturnLikelihoods returnLikelihoods;
    @JsonProperty(value="num_generations")
    Integer numGenerations;
    @JsonProperty(value="logit_bias")
    CohereChatBedrockApi.CohereChatRequest.LogitBias logitBias;
    @JsonProperty(value="truncate")
    CohereChatBedrockApi.CohereChatRequest.Truncate truncate;

    public static Builder builder() {
        return new Builder();
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public CohereChatBedrockApi.CohereChatRequest.ReturnLikelihoods getReturnLikelihoods() {
        return this.returnLikelihoods;
    }

    public void setReturnLikelihoods(CohereChatBedrockApi.CohereChatRequest.ReturnLikelihoods returnLikelihoods) {
        this.returnLikelihoods = returnLikelihoods;
    }

    public Integer getNumGenerations() {
        return this.numGenerations;
    }

    public void setNumGenerations(Integer numGenerations) {
        this.numGenerations = numGenerations;
    }

    public CohereChatBedrockApi.CohereChatRequest.LogitBias getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(CohereChatBedrockApi.CohereChatRequest.LogitBias logitBias) {
        this.logitBias = logitBias;
    }

    public CohereChatBedrockApi.CohereChatRequest.Truncate getTruncate() {
        return this.truncate;
    }

    public void setTruncate(CohereChatBedrockApi.CohereChatRequest.Truncate truncate) {
        this.truncate = truncate;
    }

    public static BedrockCohereChatOptions fromOptions(BedrockCohereChatOptions fromOptions) {
        return BedrockCohereChatOptions.builder().withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).withMaxTokens(fromOptions.getMaxTokens()).withStopSequences(fromOptions.getStopSequences()).withReturnLikelihoods(fromOptions.getReturnLikelihoods()).withNumGenerations(fromOptions.getNumGenerations()).withLogitBias(fromOptions.getLogitBias()).withTruncate(fromOptions.getTruncate()).build();
    }

    public static class Builder {
        private final BedrockCohereChatOptions options = new BedrockCohereChatOptions();

        public Builder withTemperature(Float temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withTopK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder withReturnLikelihoods(CohereChatBedrockApi.CohereChatRequest.ReturnLikelihoods returnLikelihoods) {
            this.options.setReturnLikelihoods(returnLikelihoods);
            return this;
        }

        public Builder withNumGenerations(Integer numGenerations) {
            this.options.setNumGenerations(numGenerations);
            return this;
        }

        public Builder withLogitBias(CohereChatBedrockApi.CohereChatRequest.LogitBias logitBias) {
            this.options.setLogitBias(logitBias);
            return this;
        }

        public Builder withTruncate(CohereChatBedrockApi.CohereChatRequest.Truncate truncate) {
            this.options.setTruncate(truncate);
            return this;
        }

        public BedrockCohereChatOptions build() {
            return this.options;
        }
    }
}

