/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.converse;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.bedrock.converse.api.BedrockCacheOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequencyPenalty")
    private Double frequencyPenalty;
    @JsonProperty(value="maxTokens")
    private Integer maxTokens;
    @JsonProperty(value="presencePenalty")
    private Double presencePenalty;
    @JsonIgnore
    private Map<String, String> requestParameters = new HashMap<String, String>();
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="topK")
    private Integer topK;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private BedrockCacheOptions cacheOptions;

    public static Builder builder() {
        return new Builder();
    }

    public static BedrockChatOptions fromOptions(BedrockChatOptions fromOptions) {
        fromOptions.getToolNames();
        return BedrockChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).maxTokens(fromOptions.getMaxTokens()).presencePenalty(fromOptions.getPresencePenalty()).requestParameters(new HashMap<String, String>(fromOptions.getRequestParameters())).stopSequences((List<String>)(fromOptions.getStopSequences() != null ? new ArrayList<String>(fromOptions.getStopSequences()) : null)).temperature(fromOptions.getTemperature()).topK(fromOptions.getTopK()).topP(fromOptions.getTopP()).toolCallbacks(new ArrayList<ToolCallback>(fromOptions.getToolCallbacks())).toolNames(new HashSet<String>(fromOptions.getToolNames())).toolContext(new HashMap<String, Object>(fromOptions.getToolContext())).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).cacheOptions(fromOptions.getCacheOptions()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return Set.copyOf(this.toolNames);
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(toolName -> Assert.hasText((String)toolName, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    @Nullable
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @JsonIgnore
    public BedrockCacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    @JsonIgnore
    public void setCacheOptions(BedrockCacheOptions cacheOptions) {
        this.cacheOptions = cacheOptions;
    }

    public BedrockChatOptions copy() {
        return BedrockChatOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BedrockChatOptions)) {
            return false;
        }
        BedrockChatOptions that = (BedrockChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.requestParameters, that.requestParameters) && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topK, that.topK) && Objects.equals(this.topP, that.topP) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.cacheOptions, that.cacheOptions);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.frequencyPenalty, this.maxTokens, this.presencePenalty, this.requestParameters, this.stopSequences, this.temperature, this.topK, this.topP, this.toolCallbacks, this.toolNames, this.toolContext, this.internalToolExecutionEnabled, this.cacheOptions);
    }

    public static final class Builder {
        private final BedrockChatOptions options = new BedrockChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.options.requestParameters = requestParameters;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder cacheOptions(BedrockCacheOptions cacheOptions) {
            this.options.setCacheOptions(cacheOptions);
            return this;
        }

        public BedrockChatOptions build() {
            return this.options;
        }
    }
}

