/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.converse.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetrics;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamTrace;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlockStart;

public final class ConverseApiUtils {
    public static final ChatResponse EMPTY_CHAT_RESPONSE = ChatResponse.builder().generations(List.of()).metadata("empty", (Object)true).build();

    private ConverseApiUtils() {
    }

    public static boolean isToolUseStart(ConverseStreamOutput event) {
        if (event == null || event.sdkEventType() == null || event.sdkEventType() != ConverseStreamOutput.EventType.CONTENT_BLOCK_START) {
            return false;
        }
        return ContentBlockStart.Type.TOOL_USE == ((ContentBlockStartEvent)event).start().type();
    }

    public static boolean isToolUseFinish(ConverseStreamOutput event) {
        return event != null && event.sdkEventType() != null && event.sdkEventType() == ConverseStreamOutput.EventType.METADATA;
    }

    public static Flux<ChatResponse> toChatResponse(Flux<ConverseStreamOutput> responses, ChatResponse perviousChatResponse) {
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return responses.map(event -> {
            if (ConverseApiUtils.isToolUseStart(event)) {
                isInsideTool.set(true);
            }
            return event;
        }).windowUntil(event -> {
            if (isInsideTool.get() && ConverseApiUtils.isToolUseFinish(event)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ToolUseAggregationEvent(), ConverseApiUtils::mergeToolUseEvents);
            return List.of(monoChunk);
        }).flatMap(mono -> mono).scanWith(() -> new Aggregation(), (lastAggregation, nextEvent) -> {
            if (nextEvent instanceof ToolUseAggregationEvent) {
                ToolUseAggregationEvent toolUseAggregationEvent = (ToolUseAggregationEvent)nextEvent;
                if (CollectionUtils.isEmpty(toolUseAggregationEvent.toolUseEntries())) {
                    return new Aggregation();
                }
                ArrayList<AssistantMessage.ToolCall> toolCalls = new ArrayList<AssistantMessage.ToolCall>();
                Integer promptTokens = 0;
                Integer generationTokens = 0;
                Integer totalTokens = 0;
                for (ToolUseAggregationEvent.ToolUseEntry toolUseEntry : toolUseAggregationEvent.toolUseEntries()) {
                    String functionCallId = toolUseEntry.id();
                    String functionName = toolUseEntry.name();
                    String functionArguments = toolUseEntry.input();
                    toolCalls.add(new AssistantMessage.ToolCall(functionCallId, "function", functionName, functionArguments));
                    if (toolUseEntry.usage() == null) continue;
                    promptTokens = promptTokens + toolUseEntry.usage().getPromptTokens();
                    generationTokens = generationTokens + toolUseEntry.usage().getCompletionTokens();
                    totalTokens = totalTokens + toolUseEntry.usage().getTotalTokens();
                }
                AssistantMessage assistantMessage = AssistantMessage.builder().content("").properties(Map.of()).toolCalls(toolCalls).build();
                Generation toolCallGeneration = new Generation(assistantMessage, ChatGenerationMetadata.builder().finishReason("tool_use").build());
                ChatResponseMetadata chatResponseMetaData = ChatResponseMetadata.builder().usage((Usage)new DefaultUsage(promptTokens, generationTokens, totalTokens)).build();
                return new Aggregation(MetadataAggregation.builder().copy(lastAggregation.metadataAggregation()).build(), new ChatResponse(List.of(toolCallGeneration), chatResponseMetaData));
            }
            if (nextEvent instanceof MessageStartEvent) {
                MessageStartEvent messageStartEvent = (MessageStartEvent)nextEvent;
                MetadataAggregation newMeta = MetadataAggregation.builder().copy(lastAggregation.metadataAggregation()).withRole(messageStartEvent.role().toString()).build();
                return new Aggregation(newMeta, EMPTY_CHAT_RESPONSE);
            }
            if (nextEvent instanceof MessageStopEvent) {
                MessageStopEvent messageStopEvent = (MessageStopEvent)nextEvent;
                MetadataAggregation newMeta = MetadataAggregation.builder().copy(lastAggregation.metadataAggregation()).withStopReason(messageStopEvent.stopReasonAsString()).withAdditionalModelResponseFields(messageStopEvent.additionalModelResponseFields()).build();
                return new Aggregation(newMeta, EMPTY_CHAT_RESPONSE);
            }
            if (nextEvent instanceof ContentBlockStartEvent) {
                ContentBlockStartEvent contentBlockStartEvent = (ContentBlockStartEvent)nextEvent;
                return new Aggregation();
            }
            if (nextEvent instanceof ContentBlockDeltaEvent) {
                ContentBlockDeltaEvent contentBlockDeltaEvent = (ContentBlockDeltaEvent)nextEvent;
                if (contentBlockDeltaEvent.delta().type().equals((Object)ContentBlockDelta.Type.TEXT)) {
                    Generation generation = new Generation(AssistantMessage.builder().content(contentBlockDeltaEvent.delta().text()).properties(Map.of()).build(), ChatGenerationMetadata.builder().finishReason(lastAggregation.metadataAggregation().stopReason()).build());
                    return new Aggregation(MetadataAggregation.builder().copy(lastAggregation.metadataAggregation()).build(), new ChatResponse(List.of(generation)));
                }
                if (contentBlockDeltaEvent.delta().type().equals((Object)ContentBlockDelta.Type.TOOL_USE)) {
                    // empty if block
                }
                return new Aggregation();
            }
            if (nextEvent instanceof ContentBlockStopEvent) {
                ContentBlockStopEvent contentBlockStopEvent = (ContentBlockStopEvent)nextEvent;
                return new Aggregation();
            }
            if (nextEvent instanceof ConverseStreamMetadataEvent) {
                ConverseStreamMetadataEvent metadataEvent = (ConverseStreamMetadataEvent)nextEvent;
                MetadataAggregation newMeta = MetadataAggregation.builder().copy(lastAggregation.metadataAggregation()).withTokenUsage(metadataEvent.usage()).withMetrics(metadataEvent.metrics()).withTrace(metadataEvent.trace()).build();
                Document modelResponseFields = lastAggregation.metadataAggregation().additionalModelResponseFields();
                ConverseStreamMetrics metrics = metadataEvent.metrics();
                DefaultUsage usage = new DefaultUsage(metadataEvent.usage().inputTokens(), metadataEvent.usage().outputTokens(), metadataEvent.usage().totalTokens());
                ChatResponseMetadata chatResponseMetaData = ChatResponseMetadata.builder().usage((Usage)usage).build();
                return new Aggregation(newMeta, new ChatResponse(List.of(), chatResponseMetaData));
            }
            return new Aggregation();
        }).filter(aggregation -> aggregation.chatResponse() != EMPTY_CHAT_RESPONSE).map(aggregation -> {
            ChatResponse chatResponse = aggregation.chatResponse();
            if (perviousChatResponse != null && perviousChatResponse.getMetadata() != null && perviousChatResponse.getMetadata().getUsage() != null) {
                ChatResponseMetadata.Builder metadataBuilder = ChatResponseMetadata.builder();
                Integer promptTokens = perviousChatResponse.getMetadata().getUsage().getPromptTokens();
                Integer generationTokens = perviousChatResponse.getMetadata().getUsage().getCompletionTokens();
                int totalTokens = perviousChatResponse.getMetadata().getUsage().getTotalTokens();
                if (chatResponse.getMetadata() != null) {
                    metadataBuilder.id(chatResponse.getMetadata().getId());
                    metadataBuilder.model(chatResponse.getMetadata().getModel());
                    metadataBuilder.rateLimit(chatResponse.getMetadata().getRateLimit());
                    metadataBuilder.promptMetadata(chatResponse.getMetadata().getPromptMetadata());
                    if (chatResponse.getMetadata().getUsage() != null) {
                        promptTokens = promptTokens + chatResponse.getMetadata().getUsage().getPromptTokens();
                        generationTokens = generationTokens + chatResponse.getMetadata().getUsage().getCompletionTokens();
                        totalTokens += chatResponse.getMetadata().getUsage().getTotalTokens().intValue();
                    }
                }
                metadataBuilder.usage((Usage)new DefaultUsage(promptTokens, generationTokens, Integer.valueOf(totalTokens)));
                return new ChatResponse(chatResponse.getResults(), metadataBuilder.build());
            }
            return aggregation.chatResponse();
        });
    }

    public static ConverseStreamOutput mergeToolUseEvents(ConverseStreamOutput previousEvent, ConverseStreamOutput event) {
        ToolUseAggregationEvent toolUseEventAggregator = (ToolUseAggregationEvent)previousEvent;
        if (event.sdkEventType() == ConverseStreamOutput.EventType.CONTENT_BLOCK_START) {
            ContentBlockStartEvent contentBlockStart = (ContentBlockStartEvent)event;
            if (ContentBlockStart.Type.TOOL_USE.equals((Object)contentBlockStart.start().type())) {
                ToolUseBlockStart cbToolUse = contentBlockStart.start().toolUse();
                return toolUseEventAggregator.withIndex(contentBlockStart.contentBlockIndex()).withId(cbToolUse.toolUseId()).withName(cbToolUse.name()).appendPartialJson("");
            }
        } else if (event.sdkEventType() == ConverseStreamOutput.EventType.CONTENT_BLOCK_DELTA) {
            ContentBlockDeltaEvent contentBlockDelta = (ContentBlockDeltaEvent)event;
            if (ContentBlockDelta.Type.TOOL_USE == contentBlockDelta.delta().type()) {
                return toolUseEventAggregator.appendPartialJson(contentBlockDelta.delta().toolUse().input());
            }
        } else {
            if (event.sdkEventType() == ConverseStreamOutput.EventType.CONTENT_BLOCK_STOP) {
                return toolUseEventAggregator;
            }
            if (event.sdkEventType() == ConverseStreamOutput.EventType.MESSAGE_STOP) {
                return toolUseEventAggregator;
            }
            if (event.sdkEventType() == ConverseStreamOutput.EventType.METADATA) {
                ConverseStreamMetadataEvent metadataEvent = (ConverseStreamMetadataEvent)event;
                DefaultUsage usage = new DefaultUsage(metadataEvent.usage().inputTokens(), metadataEvent.usage().outputTokens(), metadataEvent.usage().totalTokens());
                toolUseEventAggregator.withUsage(usage);
                if (!toolUseEventAggregator.isEmpty()) {
                    toolUseEventAggregator.squashIntoContentBlock();
                    return toolUseEventAggregator;
                }
            }
        }
        return event;
    }

    public static Document getChatOptionsAdditionalModelRequestFields(ChatOptions defaultOptions, ModelOptions promptOptions) {
        if (defaultOptions == null && promptOptions == null) {
            return null;
        }
        HashMap attributes = new HashMap();
        if (defaultOptions != null) {
            attributes.putAll(ModelOptionsUtils.objectToMap((Object)defaultOptions));
        }
        if (promptOptions != null) {
            if (promptOptions instanceof ChatOptions) {
                ChatOptions runtimeOptions = (ChatOptions)promptOptions;
                attributes.putAll(ModelOptionsUtils.objectToMap((Object)runtimeOptions));
            } else {
                throw new IllegalArgumentException("Prompt options are not of type ChatOptions:" + promptOptions.getClass().getSimpleName());
            }
        }
        attributes.remove("model");
        attributes.remove("proxyToolCalls");
        attributes.remove("functions");
        attributes.remove("toolContext");
        attributes.remove("toolCallbacks");
        attributes.remove("toolCallbacks");
        attributes.remove("toolNames");
        attributes.remove("internalToolExecutionEnabled");
        attributes.remove("temperature");
        attributes.remove("topK");
        attributes.remove("stopSequences");
        attributes.remove("maxTokens");
        attributes.remove("topP");
        return ConverseApiUtils.convertObjectToDocument(attributes);
    }

    public static Document convertObjectToDocument(Object value) {
        if (value == null) {
            return Document.fromNull();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Document.fromString((String)stringValue);
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return Document.fromBoolean((boolean)booleanValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return Document.fromNumber((int)integerValue);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return Document.fromNumber((long)longValue);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return Document.fromNumber((float)floatValue.floatValue());
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return Document.fromNumber((double)doubleValue);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return Document.fromNumber((BigDecimal)bigDecimalValue);
        }
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            return Document.fromNumber((BigInteger)bigIntegerValue);
        }
        if (value instanceof List) {
            List listValue = (List)value;
            return Document.fromList(listValue.stream().map(v -> ConverseApiUtils.convertObjectToDocument(v)).toList());
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            return ConverseApiUtils.convertMapToDocument(mapValue);
        }
        throw new IllegalArgumentException("Unsupported value type:" + value.getClass().getSimpleName());
    }

    public static Map<String, String> getRequestMetadata(Map<String, Object> metadata) {
        if (metadata.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            result.put(key, value.toString());
        }
        return result;
    }

    private static Document convertMapToDocument(Map<String, Object> value) {
        Map<String, Document> attr = value.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ConverseApiUtils.convertObjectToDocument(e.getValue())));
        return Document.fromMap(attr);
    }

    public static class ToolUseAggregationEvent
    implements ConverseStreamOutput {
        private Integer index;
        private String id;
        private String name;
        private String partialJson = "";
        private List<ToolUseEntry> toolUseEntries = new ArrayList<ToolUseEntry>();
        private DefaultUsage usage;

        public List<ToolUseEntry> toolUseEntries() {
            return this.toolUseEntries;
        }

        public boolean isEmpty() {
            return this.index == null || this.id == null || this.name == null || this.partialJson == null;
        }

        ToolUseAggregationEvent withIndex(Integer index) {
            this.index = index;
            return this;
        }

        ToolUseAggregationEvent withId(String id) {
            this.id = id;
            return this;
        }

        ToolUseAggregationEvent withName(String name) {
            this.name = name;
            return this;
        }

        ToolUseAggregationEvent withUsage(DefaultUsage usage) {
            this.usage = usage;
            return this;
        }

        ToolUseAggregationEvent appendPartialJson(String partialJson) {
            this.partialJson = this.partialJson + partialJson;
            return this;
        }

        void squashIntoContentBlock() {
            String json = StringUtils.hasText((String)this.partialJson) ? this.partialJson : "{}";
            this.toolUseEntries.add(new ToolUseEntry(this.index, this.id, this.name, json, this.usage));
            this.index = null;
            this.id = null;
            this.name = null;
            this.partialJson = "";
            this.usage = null;
        }

        public String toString() {
            return "EventToolUseBuilder [index=" + this.index + ", id=" + this.id + ", name=" + this.name + ", partialJson=" + this.partialJson + ", toolUseMap=]";
        }

        public List<SdkField<?>> sdkFields() {
            return List.of();
        }

        public void accept(ConverseStreamResponseHandler.Visitor visitor) {
            throw new UnsupportedOperationException();
        }

        public record ToolUseEntry(Integer index, String id, String name, String input, DefaultUsage usage) {
        }
    }

    public record Aggregation(MetadataAggregation metadataAggregation, ChatResponse chatResponse) {
        public Aggregation() {
            this(MetadataAggregation.builder().build(), EMPTY_CHAT_RESPONSE);
        }
    }

    public record MetadataAggregation(String role, String stopReason, Document additionalModelResponseFields, TokenUsage tokenUsage, ConverseStreamMetrics metrics, ConverseStreamTrace trace) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String role;
            private String stopReason;
            private Document additionalModelResponseFields;
            private TokenUsage tokenUsage;
            private ConverseStreamMetrics metrics;
            private ConverseStreamTrace trace;

            private Builder() {
            }

            public Builder copy(MetadataAggregation metadataAggregation) {
                this.role = metadataAggregation.role;
                this.stopReason = metadataAggregation.stopReason;
                this.additionalModelResponseFields = metadataAggregation.additionalModelResponseFields;
                this.tokenUsage = metadataAggregation.tokenUsage;
                this.metrics = metadataAggregation.metrics;
                this.trace = metadataAggregation.trace;
                return this;
            }

            public Builder withRole(String role) {
                this.role = role;
                return this;
            }

            public Builder withStopReason(String stopReason) {
                this.stopReason = stopReason;
                return this;
            }

            public Builder withAdditionalModelResponseFields(Document additionalModelResponseFields) {
                this.additionalModelResponseFields = additionalModelResponseFields;
                return this;
            }

            public Builder withTokenUsage(TokenUsage tokenUsage) {
                this.tokenUsage = tokenUsage;
                return this;
            }

            public Builder withMetrics(ConverseStreamMetrics metrics) {
                this.metrics = metrics;
                return this;
            }

            public Builder withTrace(ConverseStreamTrace trace) {
                this.trace = trace;
                return this;
            }

            public MetadataAggregation build() {
                return new MetadataAggregation(this.role, this.stopReason, this.additionalModelResponseFields, this.tokenUsage, this.metrics, this.trace);
            }
        }
    }
}

