/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.converse;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.bedrock.converse.api.BedrockMediaFormat;
import org.springframework.ai.bedrock.converse.api.ConverseApiUtils;
import org.springframework.ai.bedrock.converse.api.URLValidator;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.model.tool.LegacyToolCallingManager;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ConversationRole;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseMetrics;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentSource;
import software.amazon.awssdk.services.bedrockruntime.model.ImageBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ImageSource;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.S3Location;
import software.amazon.awssdk.services.bedrockruntime.model.StopReason;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.Tool;
import software.amazon.awssdk.services.bedrockruntime.model.ToolConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.ToolInputSchema;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolSpecification;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;
import software.amazon.awssdk.services.bedrockruntime.model.VideoBlock;
import software.amazon.awssdk.services.bedrockruntime.model.VideoFormat;
import software.amazon.awssdk.services.bedrockruntime.model.VideoSource;

public class BedrockProxyChatModel
extends AbstractToolCallSupport
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(BedrockProxyChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final BedrockRuntimeClient bedrockRuntimeClient;
    private final BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient;
    private ToolCallingChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private ChatModelObservationConvention observationConvention;
    public static final Sinks.EmitFailureHandler DEFAULT_EMIT_FAILURE_HANDLER = Sinks.EmitFailureHandler.busyLooping((Duration)Duration.ofSeconds(10L));

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public BedrockProxyChatModel(BedrockRuntimeClient bedrockRuntimeClient, BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient, FunctionCallingOptions defaultOptions, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, ObservationRegistry observationRegistry) {
        this(bedrockRuntimeClient, bedrockRuntimeAsyncClient, BedrockProxyChatModel.from(defaultOptions), observationRegistry, (ToolCallingManager)LegacyToolCallingManager.builder().functionCallbackResolver(functionCallbackResolver).functionCallbacks(toolFunctionCallbacks).build());
    }

    public BedrockProxyChatModel(BedrockRuntimeClient bedrockRuntimeClient, BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient, ToolCallingChatOptions defaultOptions, ObservationRegistry observationRegistry, ToolCallingManager toolCallingManager) {
        super(null, FunctionCallingOptions.builder().build(), List.of());
        Assert.notNull((Object)bedrockRuntimeClient, (String)"bedrockRuntimeClient must not be null");
        Assert.notNull((Object)bedrockRuntimeAsyncClient, (String)"bedrockRuntimeAsyncClient must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager must not be null");
        this.bedrockRuntimeClient = bedrockRuntimeClient;
        this.bedrockRuntimeAsyncClient = bedrockRuntimeAsyncClient;
        this.defaultOptions = defaultOptions;
        this.observationRegistry = observationRegistry;
        this.toolCallingManager = toolCallingManager;
    }

    @Deprecated
    private static ToolCallingChatOptions from(FunctionCallingOptions options) {
        return ToolCallingChatOptions.builder().model(options.getModel()).maxTokens(options.getMaxTokens()).stopSequences(options.getStopSequences()).temperature(options.getTemperature()).topP(options.getTopP()).toolCallbacks(options.getFunctionCallbacks()).toolNames(options.getFunctions()).internalToolExecutionEnabled(Boolean.valueOf(options.getProxyToolCalls() != null ? !options.getProxyToolCalls().booleanValue() : false)).toolContext(options.getToolContext()).build();
    }

    private static ToolCallingChatOptions from(ChatOptions options) {
        return ToolCallingChatOptions.builder().model(options.getModel()).maxTokens(options.getMaxTokens()).stopSequences(options.getStopSequences()).temperature(options.getTemperature()).topP(options.getTopP()).build();
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    private ChatResponse internalCall(Prompt prompt, ChatResponse perviousChatResponse) {
        ConverseRequest converseRequest = this.createRequest(prompt);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.BEDROCK_CONVERSE.value()).requestOptions(prompt.getOptions()).build();
        ChatResponse chatResponse = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ConverseResponse converseResponse = this.bedrockRuntimeClient.converse(converseRequest);
            logger.debug("ConverseResponse: {}", (Object)converseResponse);
            ChatResponse response = this.toChatResponse(converseResponse, perviousChatResponse);
            observationContext.setResponse((Object)response);
            return response;
        });
        if (ToolCallingChatOptions.isInternalToolExecutionEnabled((ChatOptions)prompt.getOptions()) && chatResponse != null && chatResponse.hasToolCalls() && chatResponse.hasFinishReasons(Set.of(StopReason.TOOL_USE.toString()))) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, chatResponse);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(chatResponse).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), chatResponse);
        }
        return chatResponse;
    }

    public ChatOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        ToolCallingChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (ToolCallingChatOptions)toolCallingChatOptions.copy();
            } else {
                chatOptions = prompt.getOptions();
                if (chatOptions instanceof FunctionCallingOptions) {
                    FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                    runtimeOptions = BedrockProxyChatModel.from(functionCallingOptions);
                } else {
                    runtimeOptions = BedrockProxyChatModel.from(prompt.getOptions());
                }
            }
        }
        ToolCallingChatOptions updatedRuntimeOptions = null;
        updatedRuntimeOptions = runtimeOptions == null ? (ToolCallingChatOptions)this.defaultOptions.copy() : ToolCallingChatOptions.builder().model(runtimeOptions.getModel() != null ? runtimeOptions.getModel() : this.defaultOptions.getModel()).frequencyPenalty(runtimeOptions.getFrequencyPenalty() != null ? runtimeOptions.getFrequencyPenalty() : this.defaultOptions.getFrequencyPenalty()).maxTokens(runtimeOptions.getMaxTokens() != null ? runtimeOptions.getMaxTokens() : this.defaultOptions.getMaxTokens()).presencePenalty(runtimeOptions.getPresencePenalty() != null ? runtimeOptions.getPresencePenalty() : this.defaultOptions.getPresencePenalty()).stopSequences(runtimeOptions.getStopSequences() != null ? runtimeOptions.getStopSequences() : this.defaultOptions.getStopSequences()).temperature(runtimeOptions.getTemperature() != null ? runtimeOptions.getTemperature() : this.defaultOptions.getTemperature()).topK(runtimeOptions.getTopK() != null ? runtimeOptions.getTopK() : this.defaultOptions.getTopK()).topP(runtimeOptions.getTopP() != null ? runtimeOptions.getTopP() : this.defaultOptions.getTopP()).toolCallbacks(runtimeOptions.getToolCallbacks() != null ? runtimeOptions.getToolCallbacks() : this.defaultOptions.getToolCallbacks()).toolNames(runtimeOptions.getToolNames() != null ? runtimeOptions.getToolNames() : this.defaultOptions.getToolNames()).toolContext(runtimeOptions.getToolContext() != null ? runtimeOptions.getToolContext() : this.defaultOptions.getToolContext()).internalToolExecutionEnabled(runtimeOptions.isInternalToolExecutionEnabled() != null ? runtimeOptions.isInternalToolExecutionEnabled() : this.defaultOptions.isInternalToolExecutionEnabled()).build();
        ToolCallingChatOptions.validateToolCallbacks((List)updatedRuntimeOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)updatedRuntimeOptions);
    }

    ConverseRequest createRequest(Prompt prompt) {
        List<Message> instructionMessages = prompt.getInstructions().stream().filter(message -> message.getMessageType() != MessageType.SYSTEM).map(message -> {
            if (message.getMessageType() == MessageType.USER) {
                ArrayList<ContentBlock> contents = new ArrayList<ContentBlock>();
                if (message instanceof UserMessage) {
                    UserMessage userMessage = (UserMessage)message;
                    contents.add(ContentBlock.fromText((String)userMessage.getText()));
                    if (!CollectionUtils.isEmpty((Collection)userMessage.getMedia())) {
                        List<ContentBlock> mediaContent = userMessage.getMedia().stream().map(this::mapMediaToContentBlock).toList();
                        contents.addAll(mediaContent);
                    }
                }
                return (Message)Message.builder().content(contents).role(ConversationRole.USER).build();
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                ArrayList<ContentBlock> contentBlocks = new ArrayList<ContentBlock>();
                if (StringUtils.hasText((String)message.getText())) {
                    contentBlocks.add(ContentBlock.fromText((String)message.getText()));
                }
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                        Document argumentsDocument = ConverseApiUtils.convertObjectToDocument(ModelOptionsUtils.jsonToMap((String)toolCall.arguments()));
                        contentBlocks.add(ContentBlock.fromToolUse((ToolUseBlock)((ToolUseBlock)ToolUseBlock.builder().toolUseId(toolCall.id()).name(toolCall.name()).input(argumentsDocument).build())));
                    }
                }
                return (Message)Message.builder().content(contentBlocks).role(ConversationRole.ASSISTANT).build();
            }
            if (message.getMessageType() == MessageType.TOOL) {
                List<ContentBlock> contentBlocks = ((ToolResponseMessage)message).getResponses().stream().map(toolResponse -> {
                    ToolResultBlock toolResultBlock = (ToolResultBlock)ToolResultBlock.builder().toolUseId(toolResponse.id()).content(new ToolResultContentBlock[]{(ToolResultContentBlock)ToolResultContentBlock.builder().text(toolResponse.responseData()).build()}).build();
                    return ContentBlock.fromToolResult((ToolResultBlock)toolResultBlock);
                }).toList();
                return (Message)Message.builder().content(contentBlocks).role(ConversationRole.USER).build();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).toList();
        List<SystemContentBlock> systemMessages = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(sysMessage -> (SystemContentBlock)SystemContentBlock.builder().text(sysMessage.getText()).build()).toList();
        ToolCallingChatOptions updatedRuntimeOptions = (ToolCallingChatOptions)prompt.getOptions().copy();
        ToolConfiguration toolConfiguration = null;
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions(updatedRuntimeOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            List<Tool> bedrockTools = toolDefinitions.stream().map(toolDefinition -> {
                String description = toolDefinition.description();
                String name = toolDefinition.name();
                String inputSchema = toolDefinition.inputSchema();
                return (Tool)Tool.builder().toolSpec((ToolSpecification)ToolSpecification.builder().name(name).description(description).inputSchema(ToolInputSchema.fromJson((Document)ConverseApiUtils.convertObjectToDocument(ModelOptionsUtils.jsonToMap((String)inputSchema)))).build()).build();
            }).toList();
            toolConfiguration = (ToolConfiguration)ToolConfiguration.builder().tools(bedrockTools).build();
        }
        InferenceConfiguration inferenceConfiguration = (InferenceConfiguration)InferenceConfiguration.builder().maxTokens(updatedRuntimeOptions.getMaxTokens()).stopSequences((Collection)updatedRuntimeOptions.getStopSequences()).temperature(updatedRuntimeOptions.getTemperature() != null ? Float.valueOf(updatedRuntimeOptions.getTemperature().floatValue()) : null).topP(updatedRuntimeOptions.getTopP() != null ? Float.valueOf(updatedRuntimeOptions.getTopP().floatValue()) : null).build();
        Document additionalModelRequestFields = ConverseApiUtils.getChatOptionsAdditionalModelRequestFields((ChatOptions)this.defaultOptions, (ModelOptions)prompt.getOptions());
        return (ConverseRequest)ConverseRequest.builder().modelId(updatedRuntimeOptions.getModel()).inferenceConfig(inferenceConfiguration).messages(instructionMessages).system(systemMessages).additionalModelRequestFields(additionalModelRequestFields).toolConfig(toolConfiguration).build();
    }

    private ContentBlock mapMediaToContentBlock(Media media) {
        MimeType mimeType = media.getMimeType();
        if (BedrockMediaFormat.isSupportedVideoFormat(mimeType).booleanValue()) {
            VideoFormat videoFormat = BedrockMediaFormat.getVideoFormat(mimeType);
            VideoSource videoSource = null;
            Object object = media.getData();
            if (object instanceof byte[]) {
                byte[] bytes = (byte[])object;
                videoSource = (VideoSource)VideoSource.builder().bytes(SdkBytes.fromByteArrayUnsafe((byte[])bytes)).build();
            } else {
                object = media.getData();
                if (object instanceof String) {
                    String uriText = (String)object;
                    videoSource = (VideoSource)VideoSource.builder().s3Location((S3Location)S3Location.builder().uri(uriText).build()).build();
                } else {
                    object = media.getData();
                    if (object instanceof URL) {
                        URL url = (URL)object;
                        try {
                            videoSource = (VideoSource)VideoSource.builder().s3Location((S3Location)S3Location.builder().uri(url.toURI().toString()).build()).build();
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalArgumentException(e);
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid video content type: " + String.valueOf(media.getData().getClass()));
                    }
                }
            }
            return ContentBlock.fromVideo((VideoBlock)((VideoBlock)VideoBlock.builder().source(videoSource).format(videoFormat).build()));
        }
        if (BedrockMediaFormat.isSupportedImageFormat(mimeType).booleanValue()) {
            ImageSource.Builder sourceBuilder;
            block33: {
                sourceBuilder = ImageSource.builder();
                Object uriText = media.getData();
                if (uriText instanceof byte[]) {
                    byte[] bytes = (byte[])uriText;
                    sourceBuilder.bytes(SdkBytes.fromByteArrayUnsafe((byte[])bytes)).build();
                } else {
                    uriText = media.getData();
                    if (uriText instanceof String) {
                        String text = (String)uriText;
                        if (URLValidator.isValidURLBasic(text)) {
                            try {
                                URL url = new URL(text);
                                URLConnection connection = url.openConnection();
                                try (InputStream is = connection.getInputStream();){
                                    sourceBuilder.bytes(SdkBytes.fromByteArrayUnsafe((byte[])StreamUtils.copyToByteArray((InputStream)is))).build();
                                    break block33;
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to read media data from URL: " + text, e);
                            }
                        }
                        sourceBuilder.bytes(SdkBytes.fromByteArray((byte[])Base64.getDecoder().decode(text)));
                    } else {
                        Object e = media.getData();
                        if (e instanceof URL) {
                            URL url = (URL)e;
                            try (InputStream is = url.openConnection().getInputStream();){
                                byte[] imageBytes = StreamUtils.copyToByteArray((InputStream)is);
                                sourceBuilder.bytes(SdkBytes.fromByteArrayUnsafe((byte[])imageBytes)).build();
                                break block33;
                            }
                            catch (IOException e2) {
                                throw new IllegalArgumentException("Failed to read media data from URL: " + String.valueOf(url), e2);
                            }
                        }
                        throw new IllegalArgumentException("Invalid Image content type: " + String.valueOf(media.getData().getClass()));
                    }
                }
            }
            return ContentBlock.fromImage((ImageBlock)((ImageBlock)ImageBlock.builder().source((ImageSource)sourceBuilder.build()).format(BedrockMediaFormat.getImageFormat(mimeType)).build()));
        }
        if (BedrockMediaFormat.isSupportedDocumentFormat(mimeType).booleanValue()) {
            return ContentBlock.fromDocument((DocumentBlock)((DocumentBlock)DocumentBlock.builder().name(media.getName()).format(BedrockMediaFormat.getDocumentFormat(mimeType)).source((DocumentSource)DocumentSource.builder().bytes(SdkBytes.fromByteArray((byte[])media.getDataAsByteArray())).build()).build()));
        }
        throw new IllegalArgumentException("Unsupported media format: " + String.valueOf(mimeType));
    }

    private static byte[] getContentMediaData(Object mediaData) {
        if (mediaData instanceof byte[]) {
            byte[] bytes = (byte[])mediaData;
            return bytes;
        }
        if (mediaData instanceof String) {
            String text = (String)mediaData;
            if (URLValidator.isValidURLBasic(text)) {
                byte[] byArray;
                block20: {
                    URL url = new URL(text);
                    URLConnection connection = url.openConnection();
                    InputStream is = connection.getInputStream();
                    try {
                        byArray = StreamUtils.copyToByteArray((InputStream)is);
                        if (is == null) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read media data from URL: " + text, e);
                        }
                    }
                    is.close();
                }
                return byArray;
            }
            return text.getBytes();
        }
        if (mediaData instanceof URL) {
            byte[] byArray;
            block21: {
                URL url = (URL)mediaData;
                InputStream is = url.openConnection().getInputStream();
                try {
                    byArray = StreamUtils.copyToByteArray((InputStream)is);
                    if (is == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read media data from URL: " + String.valueOf(url), e);
                    }
                }
                is.close();
            }
            return byArray;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaData.getClass().getSimpleName());
    }

    private ChatResponse toChatResponse(ConverseResponse response, ChatResponse perviousChatResponse) {
        List<ContentBlock> toolUseContentBlocks;
        Assert.notNull((Object)response, (String)"'response' must not be null.");
        Message message = response.output().message();
        List<Generation> generations = message.content().stream().filter(content -> content.type() != ContentBlock.Type.TOOL_USE).map(content -> new Generation(new AssistantMessage(content.text(), Map.of()), ChatGenerationMetadata.builder().finishReason(response.stopReasonAsString()).build())).toList();
        ArrayList<Generation> allGenerations = new ArrayList<Generation>(generations);
        if (response.stopReasonAsString() != null && generations.isEmpty()) {
            Generation generation = new Generation(new AssistantMessage(null, Map.of()), ChatGenerationMetadata.builder().finishReason(response.stopReasonAsString()).build());
            allGenerations.add(generation);
        }
        if (!CollectionUtils.isEmpty(toolUseContentBlocks = message.content().stream().filter(c -> c.type() == ContentBlock.Type.TOOL_USE).toList())) {
            ArrayList<AssistantMessage.ToolCall> toolCalls = new ArrayList<AssistantMessage.ToolCall>();
            for (ContentBlock toolUseContentBlock : toolUseContentBlocks) {
                String functionCallId = toolUseContentBlock.toolUse().toolUseId();
                String functionName = toolUseContentBlock.toolUse().name();
                String functionArguments = toolUseContentBlock.toolUse().input().toString();
                toolCalls.add(new AssistantMessage.ToolCall(functionCallId, "function", functionName, functionArguments));
            }
            AssistantMessage assistantMessage = new AssistantMessage("", Map.of(), toolCalls);
            Generation toolCallGeneration = new Generation(assistantMessage, ChatGenerationMetadata.builder().finishReason(response.stopReasonAsString()).build());
            allGenerations.add(toolCallGeneration);
        }
        Integer promptTokens = response.usage().inputTokens();
        Integer generationTokens = response.usage().outputTokens();
        int totalTokens = response.usage().totalTokens();
        if (perviousChatResponse != null && perviousChatResponse.getMetadata() != null && perviousChatResponse.getMetadata().getUsage() != null) {
            promptTokens = promptTokens + perviousChatResponse.getMetadata().getUsage().getPromptTokens();
            generationTokens = generationTokens + perviousChatResponse.getMetadata().getUsage().getCompletionTokens();
            totalTokens += perviousChatResponse.getMetadata().getUsage().getTotalTokens().intValue();
        }
        DefaultUsage usage = new DefaultUsage(promptTokens, generationTokens, Integer.valueOf(totalTokens));
        Document modelResponseFields = response.additionalModelResponseFields();
        ConverseMetrics metrics = response.metrics();
        ChatResponseMetadata chatResponseMetaData = ChatResponseMetadata.builder().id(response.responseMetadata() != null ? response.responseMetadata().requestId() : "Unknown").usage((Usage)usage).build();
        return new ChatResponse(allGenerations, chatResponseMetaData);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    private Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse perviousChatResponse) {
        Assert.notNull((Object)prompt, (String)"'prompt' must not be null");
        return Flux.deferContextual(contextView -> {
            ConverseRequest converseRequest = this.createRequest(prompt);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.BEDROCK_CONVERSE.value()).requestOptions(prompt.getOptions()).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            ConverseStreamRequest converseStreamRequest = (ConverseStreamRequest)ConverseStreamRequest.builder().modelId(converseRequest.modelId()).inferenceConfig(converseRequest.inferenceConfig()).messages((Collection)converseRequest.messages()).system((Collection)converseRequest.system()).additionalModelRequestFields(converseRequest.additionalModelRequestFields()).toolConfig(converseRequest.toolConfig()).build();
            Flux<ConverseStreamOutput> response = this.converseStream(converseStreamRequest);
            Flux<ChatResponse> chatResponses = ConverseApiUtils.toChatResponse(response, perviousChatResponse);
            Flux chatResponseFlux = chatResponses.switchMap(chatResponse -> {
                if (ToolCallingChatOptions.isInternalToolExecutionEnabled((ChatOptions)prompt.getOptions()) && chatResponse.hasToolCalls() && chatResponse.hasFinishReasons(Set.of(StopReason.TOOL_USE.toString()))) {
                    ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, chatResponse);
                    if (toolExecutionResult.returnDirect()) {
                        return Flux.just((Object)ChatResponse.builder().from(chatResponse).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                    }
                    return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)chatResponse);
                }
                return Flux.just((Object)chatResponse);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    public Flux<ConverseStreamOutput> converseStream(ConverseStreamRequest converseStreamRequest) {
        Assert.notNull((Object)converseStreamRequest, (String)"'converseStreamRequest' must not be null");
        Sinks.Many eventSink = Sinks.many().multicast().onBackpressureBuffer();
        ConverseStreamResponseHandler.Visitor visitor = ConverseStreamResponseHandler.Visitor.builder().onDefault(output -> {
            logger.debug("Received converse stream output:{}", output);
            eventSink.emitNext(output, DEFAULT_EMIT_FAILURE_HANDLER);
        }).build();
        ConverseStreamResponseHandler responseHandler = ((ConverseStreamResponseHandler.Builder)((ConverseStreamResponseHandler.Builder)((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().onEventStream(stream -> stream.subscribe(e -> e.accept(visitor)))).onComplete(() -> {
            eventSink.emitComplete(DEFAULT_EMIT_FAILURE_HANDLER);
            logger.info("Completed streaming response.");
        })).onError(error -> {
            logger.error("Error handling Bedrock converse stream response", error);
            eventSink.emitError(error, DEFAULT_EMIT_FAILURE_HANDLER);
        })).build();
        this.bedrockRuntimeAsyncClient.converseStream(converseStreamRequest, responseHandler);
        return eventSink.asFlux();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AwsCredentialsProvider credentialsProvider;
        private Region region = Region.US_EAST_1;
        private Duration timeout = Duration.ofMinutes(10L);
        private ToolCallingManager toolCallingManager;
        private ToolCallingChatOptions defaultOptions = ToolCallingChatOptions.builder().build();
        private FunctionCallbackResolver functionCallbackResolver;
        private List<FunctionCallback> toolFunctionCallbacks;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private ChatModelObservationConvention customObservationConvention;
        private BedrockRuntimeClient bedrockRuntimeClient;
        private BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient;

        private Builder() {
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        @Deprecated
        public Builder withCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
            Assert.notNull((Object)credentialsProvider, (String)"'credentialsProvider' must not be null.");
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            Assert.notNull((Object)credentialsProvider, (String)"'credentialsProvider' must not be null.");
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Deprecated
        public Builder withRegion(Region region) {
            Assert.notNull((Object)region, (String)"'region' must not be null.");
            this.region = region;
            return this;
        }

        public Builder region(Region region) {
            Assert.notNull((Object)region, (String)"'region' must not be null.");
            this.region = region;
            return this;
        }

        @Deprecated
        public Builder withTimeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"'timeout' must not be null.");
            this.timeout = timeout;
            return this;
        }

        public Builder timeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"'timeout' must not be null.");
            this.timeout = timeout;
            return this;
        }

        @Deprecated
        public Builder withDefaultOptions(FunctionCallingOptions defaultOptions) {
            Assert.notNull((Object)defaultOptions, (String)"'defaultOptions' must not be null.");
            return this.defaultOptions(ToolCallingChatOptions.builder().model(defaultOptions.getModel()).maxTokens(defaultOptions.getMaxTokens()).stopSequences(defaultOptions.getStopSequences()).temperature(defaultOptions.getTemperature()).topP(defaultOptions.getTopP()).toolCallbacks(defaultOptions.getFunctionCallbacks()).toolNames(defaultOptions.getFunctions()).internalToolExecutionEnabled(Boolean.valueOf(defaultOptions.getProxyToolCalls() != null ? !defaultOptions.getProxyToolCalls().booleanValue() : false)).toolContext(defaultOptions.getToolContext()).build());
        }

        public Builder defaultOptions(ToolCallingChatOptions defaultOptions) {
            Assert.notNull((Object)defaultOptions, (String)"'defaultOptions' must not be null.");
            this.defaultOptions = defaultOptions;
            return this;
        }

        @Deprecated
        public Builder withFunctionCallbackContext(FunctionCallbackResolver functionCallbackResolver) {
            this.functionCallbackResolver = functionCallbackResolver;
            return this;
        }

        public Builder functionCallbackResolver(FunctionCallbackResolver functionCallbackResolver) {
            this.functionCallbackResolver = functionCallbackResolver;
            return this;
        }

        @Deprecated
        public Builder withToolFunctionCallbacks(List<FunctionCallback> toolFunctionCallbacks) {
            this.toolFunctionCallbacks = toolFunctionCallbacks;
            return this;
        }

        @Deprecated
        public Builder withObservationRegistry(ObservationRegistry observationRegistry) {
            Assert.notNull((Object)observationRegistry, (String)"'observationRegistry' must not be null.");
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            Assert.notNull((Object)observationRegistry, (String)"'observationRegistry' must not be null.");
            this.observationRegistry = observationRegistry;
            return this;
        }

        @Deprecated
        public Builder withCustomObservationConvention(ChatModelObservationConvention observationConvention) {
            Assert.notNull((Object)observationConvention, (String)"'observationConvention' must not be null.");
            this.customObservationConvention = observationConvention;
            return this;
        }

        public Builder customObservationConvention(ChatModelObservationConvention observationConvention) {
            Assert.notNull((Object)observationConvention, (String)"'observationConvention' must not be null.");
            this.customObservationConvention = observationConvention;
            return this;
        }

        @Deprecated
        public Builder withBedrockRuntimeClient(BedrockRuntimeClient bedrockRuntimeClient) {
            this.bedrockRuntimeClient = bedrockRuntimeClient;
            return this;
        }

        public Builder bedrockRuntimeClient(BedrockRuntimeClient bedrockRuntimeClient) {
            this.bedrockRuntimeClient = bedrockRuntimeClient;
            return this;
        }

        @Deprecated
        public Builder withBedrockRuntimeAsyncClient(BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient) {
            this.bedrockRuntimeAsyncClient = bedrockRuntimeAsyncClient;
            return this;
        }

        public Builder bedrockRuntimeAsyncClient(BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient) {
            this.bedrockRuntimeAsyncClient = bedrockRuntimeAsyncClient;
            return this;
        }

        public BedrockProxyChatModel build() {
            if (this.bedrockRuntimeClient == null) {
                this.bedrockRuntimeClient = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).httpClientBuilder(null)).credentialsProvider(this.credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(this.timeout))).build();
            }
            if (this.bedrockRuntimeAsyncClient == null) {
                NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder().tcpKeepAlive(Boolean.valueOf(true)).connectionAcquisitionTimeout(Duration.ofSeconds(30L)).maxConcurrency(Integer.valueOf(200));
                BedrockRuntimeAsyncClientBuilder builder = (BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).httpClientBuilder((SdkAsyncHttpClient.Builder)httpClientBuilder)).credentialsProvider(this.credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(this.timeout));
                this.bedrockRuntimeAsyncClient = (BedrockRuntimeAsyncClient)builder.build();
            }
            BedrockProxyChatModel bedrockProxyChatModel = null;
            if (this.toolCallingManager != null) {
                Assert.isNull((Object)this.functionCallbackResolver, (String)"functionCallbackResolver cannot be set when toolCallingManager is set");
                Assert.isNull(this.toolFunctionCallbacks, (String)"toolFunctionCallbacks cannot be set when toolCallingManager is set");
                bedrockProxyChatModel = new BedrockProxyChatModel(this.bedrockRuntimeClient, this.bedrockRuntimeAsyncClient, this.defaultOptions, this.observationRegistry, this.toolCallingManager);
            } else if (this.functionCallbackResolver != null) {
                Assert.isNull((Object)this.toolCallingManager, (String)"toolCallingManager cannot be set when functionCallbackResolver is set");
                bedrockProxyChatModel = new BedrockProxyChatModel(this.bedrockRuntimeClient, this.bedrockRuntimeAsyncClient, (FunctionCallingOptions)this.defaultOptions, this.functionCallbackResolver, this.toolFunctionCallbacks, this.observationRegistry);
            } else {
                bedrockProxyChatModel = new BedrockProxyChatModel(this.bedrockRuntimeClient, this.bedrockRuntimeAsyncClient, this.defaultOptions, this.observationRegistry, DEFAULT_TOOL_CALLING_MANAGER);
            }
            if (this.customObservationConvention != null) {
                bedrockProxyChatModel.setObservationConvention(this.customObservationConvention);
            }
            return bedrockProxyChatModel;
        }
    }
}

