/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.EmbeddingsOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.springframework.ai.embedding.EmbeddingOptions;

public class AzureOpenAiEmbeddingOptions
implements EmbeddingOptions {
    private String user;
    private String deploymentName;
    private String inputType;
    private Integer dimensions;

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnore
    public String getModel() {
        return this.getDeploymentName();
    }

    @JsonIgnore
    public void setModel(String model) {
        this.setDeploymentName(model);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public EmbeddingsOptions toAzureOptions(List<String> instructions) {
        EmbeddingsOptions azureOptions = new EmbeddingsOptions(instructions);
        azureOptions.setModel(this.getDeploymentName());
        azureOptions.setUser(this.getUser());
        azureOptions.setInputType(this.getInputType());
        azureOptions.setDimensions(this.getDimensions());
        return azureOptions;
    }

    public static final class Builder {
        private final AzureOpenAiEmbeddingOptions options = new AzureOpenAiEmbeddingOptions();

        public Builder from(AzureOpenAiEmbeddingOptions fromOptions) {
            this.options.setUser(fromOptions.getUser());
            this.options.setDeploymentName(fromOptions.getDeploymentName());
            this.options.setInputType(fromOptions.getInputType());
            this.options.setDimensions(fromOptions.getDimensions());
            return this;
        }

        public Builder merge(EmbeddingOptions from) {
            if (from != null && from instanceof AzureOpenAiEmbeddingOptions) {
                AzureOpenAiEmbeddingOptions castFrom = (AzureOpenAiEmbeddingOptions)from;
                if (castFrom.getUser() != null) {
                    this.options.setUser(castFrom.getUser());
                }
                if (castFrom.getDeploymentName() != null) {
                    this.options.setDeploymentName(castFrom.getDeploymentName());
                }
                if (castFrom.getInputType() != null) {
                    this.options.setInputType(castFrom.getInputType());
                }
                if (castFrom.getDimensions() != null) {
                    this.options.setDimensions(castFrom.getDimensions());
                }
            }
            return this;
        }

        public Builder from(EmbeddingsOptions azureOptions) {
            this.options.setUser(azureOptions.getUser());
            this.options.setDeploymentName(azureOptions.getModel());
            this.options.setInputType(azureOptions.getInputType());
            this.options.setDimensions(azureOptions.getDimensions());
            return this;
        }

        public Builder user(String user) {
            this.options.setUser(user);
            return this;
        }

        public Builder deploymentName(String model) {
            this.options.setDeploymentName(model);
            return this;
        }

        public Builder inputType(String inputType) {
            this.options.inputType = inputType;
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        public AzureOpenAiEmbeddingOptions build() {
            return this.options;
        }
    }
}

