/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai.metadata;

import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.CompletionsUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.util.Assert;

public class AzureOpenAiUsage
implements Usage {
    private final CompletionsUsage usage;

    public AzureOpenAiUsage(CompletionsUsage usage) {
        Assert.notNull((Object)usage, (String)"CompletionsUsage must not be null");
        this.usage = usage;
    }

    public static AzureOpenAiUsage from(ChatCompletions chatCompletions) {
        Assert.notNull((Object)chatCompletions, (String)"ChatCompletions must not be null");
        return AzureOpenAiUsage.from(chatCompletions.getUsage());
    }

    public static AzureOpenAiUsage from(CompletionsUsage usage) {
        return new AzureOpenAiUsage(usage);
    }

    protected CompletionsUsage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return this.getUsage().getPromptTokens();
    }

    public Long getGenerationTokens() {
        return this.getUsage().getCompletionTokens();
    }

    public Long getTotalTokens() {
        return this.getUsage().getTotalTokens();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

