/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.AudioTranscriptionFormat;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureOpenAiAudioTranscriptionOptions
implements AudioTranscriptionOptions {
    public static final String DEFAULT_AUDIO_TRANSCRIPTION_MODEL = WhisperModel.WHISPER.getValue();
    @JsonProperty(value="model")
    private String model = DEFAULT_AUDIO_TRANSCRIPTION_MODEL;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="response_format")
    private TranscriptResponseFormat responseFormat = TranscriptResponseFormat.JSON;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="language")
    private String language;
    @JsonProperty(value="temperature")
    private Float temperature = Float.valueOf(0.0f);
    @JsonProperty(value="timestamp_granularities")
    private List<GranularityType> granularityType;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public TranscriptResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(TranscriptResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public List<GranularityType> getGranularityType() {
        return this.granularityType;
    }

    public void setGranularityType(List<GranularityType> granularityType) {
        this.granularityType = granularityType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.prompt == null ? 0 : this.prompt.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AzureOpenAiAudioTranscriptionOptions other = (AzureOpenAiAudioTranscriptionOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.prompt == null ? other.prompt != null : !this.prompt.equals(other.prompt)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.responseFormat == null) {
            return other.responseFormat == null;
        }
        return this.responseFormat.equals((Object)other.responseFormat);
    }

    public static enum TranscriptResponseFormat {
        JSON(AudioTranscriptionFormat.JSON, StructuredResponse.class),
        TEXT(AudioTranscriptionFormat.TEXT, String.class),
        SRT(AudioTranscriptionFormat.SRT, String.class),
        VERBOSE_JSON(AudioTranscriptionFormat.VERBOSE_JSON, StructuredResponse.class),
        VTT(AudioTranscriptionFormat.VTT, String.class);

        public final AudioTranscriptionFormat value;
        public final Class<?> responseType;

        private TranscriptResponseFormat(AudioTranscriptionFormat value, Class<?> responseType) {
            this.value = value;
            this.responseType = responseType;
        }

        public AudioTranscriptionFormat getValue() {
            return this.value;
        }

        public Class<?> getResponseType() {
            return this.responseType;
        }
    }

    public static class Builder {
        protected AzureOpenAiAudioTranscriptionOptions options;

        public Builder() {
            this.options = new AzureOpenAiAudioTranscriptionOptions();
        }

        public Builder(AzureOpenAiAudioTranscriptionOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.setDeploymentName(deploymentName);
            return this;
        }

        public Builder language(String language) {
            this.options.language = language;
            return this;
        }

        public Builder prompt(String prompt) {
            this.options.prompt = prompt;
            return this;
        }

        public Builder responseFormat(TranscriptResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder temperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder granularityType(List<GranularityType> granularityType) {
            this.options.granularityType = granularityType;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withDeploymentName(String deploymentName) {
            this.options.setDeploymentName(deploymentName);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withLanguage(String language) {
            this.options.language = language;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withPrompt(String prompt) {
            this.options.prompt = prompt;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withResponseFormat(TranscriptResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withTemperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withGranularityType(List<GranularityType> granularityType) {
            this.options.granularityType = granularityType;
            return this;
        }

        public AzureOpenAiAudioTranscriptionOptions build() {
            Assert.hasText((String)this.options.model, (String)"model must not be empty");
            Assert.notNull((Object)((Object)this.options.responseFormat), (String)"response_format must not be null");
            return this.options;
        }
    }

    public static enum WhisperModel {
        WHISPER("whisper");

        public final String value;

        private WhisperModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record StructuredResponse(@JsonProperty(value="language") String language, @JsonProperty(value="duration") Float duration, @JsonProperty(value="text") String text, @JsonProperty(value="words") List<Word> words, @JsonProperty(value="segments") List<Segment> segments) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Segment(@JsonProperty(value="id") Integer id, @JsonProperty(value="seek") Integer seek, @JsonProperty(value="start") Float start, @JsonProperty(value="end") Float end, @JsonProperty(value="text") String text, @JsonProperty(value="tokens") List<Integer> tokens, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="avg_logprob") Float avgLogprob, @JsonProperty(value="compression_ratio") Float compressionRatio, @JsonProperty(value="no_speech_prob") Float noSpeechProb) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Word(@JsonProperty(value="word") String word, @JsonProperty(value="start") Float start, @JsonProperty(value="end") Float end) {
        }
    }

    public static enum GranularityType {
        WORD(AudioTranscriptionTimestampGranularity.WORD),
        SEGMENT(AudioTranscriptionTimestampGranularity.SEGMENT);

        public final AudioTranscriptionTimestampGranularity value;

        private GranularityType(AudioTranscriptionTimestampGranularity value) {
            this.value = value;
        }

        public AudioTranscriptionTimestampGranularity getValue() {
            return this.value;
        }
    }
}

