/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureOpenAiChatOptions
implements FunctionCallingOptions {
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="response_format")
    private AzureOpenAiResponseFormat responseFormat;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonProperty(value="seed")
    private Long seed;
    @JsonProperty(value="log_probs")
    private Boolean logprobs;
    @JsonProperty(value="top_log_probs")
    private Integer topLogProbs;
    @JsonIgnore
    private AzureChatEnhancementConfiguration enhancements;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public static AzureOpenAiChatOptions fromOptions(AzureOpenAiChatOptions fromOptions) {
        return AzureOpenAiChatOptions.builder().withDeploymentName(fromOptions.getDeploymentName()).withFrequencyPenalty(fromOptions.getFrequencyPenalty() != null ? fromOptions.getFrequencyPenalty() : null).withLogitBias(fromOptions.getLogitBias()).withMaxTokens(fromOptions.getMaxTokens()).withN(fromOptions.getN()).withPresencePenalty(fromOptions.getPresencePenalty() != null ? fromOptions.getPresencePenalty() : null).withStop(fromOptions.getStop()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withUser(fromOptions.getUser()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).withResponseFormat(fromOptions.getResponseFormat()).withSeed(fromOptions.getSeed()).withLogprobs(fromOptions.isLogprobs()).withTopLogprobs(fromOptions.getTopLogProbs()).withEnhancements(fromOptions.getEnhancements()).withToolContext(fromOptions.getToolContext()).build();
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonIgnore
    public String getModel() {
        return this.getDeploymentName();
    }

    @JsonIgnore
    public void setModel(String model) {
        this.setDeploymentName(model);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    public AzureOpenAiResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Boolean isLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogProbs() {
        return this.topLogProbs;
    }

    public void setTopLogProbs(Integer topLogProbs) {
        this.topLogProbs = topLogProbs;
    }

    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    public void setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public AzureOpenAiChatOptions copy() {
        return AzureOpenAiChatOptions.fromOptions(this);
    }

    public static class Builder {
        protected AzureOpenAiChatOptions options;

        public Builder() {
            this.options = new AzureOpenAiChatOptions();
        }

        public Builder(AzureOpenAiChatOptions options) {
            this.options = options;
        }

        public Builder withDeploymentName(String deploymentName) {
            this.options.deploymentName = deploymentName;
            return this;
        }

        public Builder withFrequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder withLogitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder withN(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder withPresencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder withStop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withUser(String user) {
            this.options.user = user;
            return this;
        }

        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder withResponseFormat(AzureOpenAiResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder withSeed(Long seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder withLogprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder withTopLogprobs(Integer topLogprobs) {
            this.options.topLogProbs = topLogprobs;
            return this;
        }

        public Builder withEnhancements(AzureChatEnhancementConfiguration enhancements) {
            this.options.enhancements = enhancements;
            return this;
        }

        public Builder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public AzureOpenAiChatOptions build() {
            return this.options;
        }
    }
}

