/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai.metadata;

import com.azure.ai.openai.models.ImageGenerations;
import java.util.Objects;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.util.Assert;

public class AzureOpenAiImageResponseMetadata
extends ImageResponseMetadata {
    private final Long created;

    public static AzureOpenAiImageResponseMetadata from(ImageGenerations openAiImageResponse) {
        Assert.notNull((Object)openAiImageResponse, (String)"OpenAiImageResponse must not be null");
        return new AzureOpenAiImageResponseMetadata(openAiImageResponse.getCreatedAt().toEpochSecond());
    }

    protected AzureOpenAiImageResponseMetadata(Long created) {
        this.created = created;
    }

    public Long getCreated() {
        return this.created;
    }

    public String toString() {
        return "AzureOpenAiImageResponseMetadata{created=" + this.created + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AzureOpenAiImageResponseMetadata)) {
            return false;
        }
        AzureOpenAiImageResponseMetadata that = (AzureOpenAiImageResponseMetadata)((Object)o);
        return Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.created);
    }
}

