/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.models.AzureChatEnhancements;
import com.azure.ai.openai.models.AzureChatExtensionsMessageContext;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatChoiceLogProbabilityInfo;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatFinishDetails;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.ContentFilterResultsForChoice;
import com.azure.ai.openai.models.FunctionCall;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MergeUtils {
    private static final Class<?>[] CHAT_COMPLETIONS_CONSTRUCTOR_ARG_TYPES = new Class[]{String.class, OffsetDateTime.class, List.class, CompletionsUsage.class};
    private static final Class<?>[] chatChoiceConstructorArgumentTypes = new Class[]{ChatChoiceLogProbabilityInfo.class, Integer.TYPE, CompletionsFinishReason.class};
    private static final Class<?>[] chatResponseMessageConstructorArgumentTypes = new Class[]{ChatRole.class, String.class};

    private static <T> T newInstance(Class<?>[] argumentTypes, Class<T> clazz, Object ... args) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(argumentTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setField(Object classInstance, String fieldName, Object fieldValue) {
        try {
            Field field = classInstance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(classInstance, fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ChatCompletions emptyChatCompletions() {
        Object id = null;
        ArrayList choices = new ArrayList();
        Object usage = null;
        OffsetDateTime createdAt = OffsetDateTime.now();
        ChatCompletions chatCompletionsInstance = MergeUtils.newInstance(CHAT_COMPLETIONS_CONSTRUCTOR_ARG_TYPES, ChatCompletions.class, id, createdAt, choices, usage);
        ArrayList promptFilterResults = new ArrayList();
        MergeUtils.setField(chatCompletionsInstance, "promptFilterResults", promptFilterResults);
        Object systemFingerprint = null;
        MergeUtils.setField(chatCompletionsInstance, "systemFingerprint", systemFingerprint);
        return chatCompletionsInstance;
    }

    public static ChatCompletions mergeChatCompletions(ChatCompletions left, ChatCompletions right) {
        Assert.isTrue((left != null ? 1 : 0) != 0, (String)"");
        if (right == null) {
            Assert.isTrue((left.getId() != null ? 1 : 0) != 0, (String)"");
            return left;
        }
        Assert.isTrue((left.getId() != null || right.getId() != null ? 1 : 0) != 0, (String)"");
        String id = left.getId() != null ? left.getId() : right.getId();
        List<Object> choices = null;
        choices = right.getChoices() == null ? left.getChoices() : (CollectionUtils.isEmpty((Collection)left.getChoices()) ? right.getChoices() : List.of(MergeUtils.mergeChatChoice((ChatChoice)left.getChoices().get(0), (ChatChoice)right.getChoices().get(0))));
        CompletionsUsage usage = right.getUsage() == null ? left.getUsage() : right.getUsage();
        OffsetDateTime createdAt = left.getCreatedAt().isAfter(right.getCreatedAt()) ? left.getCreatedAt() : right.getCreatedAt();
        ChatCompletions instance = MergeUtils.newInstance(CHAT_COMPLETIONS_CONSTRUCTOR_ARG_TYPES, ChatCompletions.class, id, createdAt, choices, usage);
        List promptFilterResults = right.getPromptFilterResults() == null ? left.getPromptFilterResults() : right.getPromptFilterResults();
        MergeUtils.setField(instance, "promptFilterResults", promptFilterResults);
        String systemFingerprint = right.getSystemFingerprint() == null ? left.getSystemFingerprint() : right.getSystemFingerprint();
        MergeUtils.setField(instance, "systemFingerprint", systemFingerprint);
        return instance;
    }

    private static ChatChoice mergeChatChoice(ChatChoice left, ChatChoice right) {
        int index = Math.max(left.getIndex(), right.getIndex());
        CompletionsFinishReason finishReason = left.getFinishReason() != null ? left.getFinishReason() : right.getFinishReason();
        ChatChoiceLogProbabilityInfo logprobs = left.getLogprobs() != null ? left.getLogprobs() : right.getLogprobs();
        ChatChoice instance = MergeUtils.newInstance(chatChoiceConstructorArgumentTypes, ChatChoice.class, logprobs, index, finishReason);
        ChatResponseMessage message = null;
        message = left.getMessage() == null ? right.getMessage() : MergeUtils.mergeChatResponseMessage(left.getMessage(), right.getMessage());
        MergeUtils.setField(instance, "message", message);
        ChatResponseMessage delta = null;
        delta = left.getDelta() == null ? right.getDelta() : MergeUtils.mergeChatResponseMessage(left.getDelta(), right.getDelta());
        MergeUtils.setField(instance, "delta", delta);
        ContentFilterResultsForChoice contentFilterResults = left.getContentFilterResults() != null ? left.getContentFilterResults() : right.getContentFilterResults();
        MergeUtils.setField(instance, "contentFilterResults", contentFilterResults);
        ChatFinishDetails finishDetails = left.getFinishDetails() != null ? left.getFinishDetails() : right.getFinishDetails();
        MergeUtils.setField(instance, "finishDetails", finishDetails);
        AzureChatEnhancements enhancements = left.getEnhancements() != null ? left.getEnhancements() : right.getEnhancements();
        MergeUtils.setField(instance, "enhancements", enhancements);
        return instance;
    }

    private static ChatResponseMessage mergeChatResponseMessage(ChatResponseMessage left, ChatResponseMessage right) {
        ChatRole role = left.getRole() != null ? left.getRole() : right.getRole();
        String content = null;
        content = left.getContent() != null && right.getContent() != null ? left.getContent().concat(right.getContent()) : (left.getContent() == null ? right.getContent() : left.getContent());
        ChatResponseMessage instance = MergeUtils.newInstance(chatResponseMessageConstructorArgumentTypes, ChatResponseMessage.class, role, content);
        ArrayList<ChatCompletionsToolCall> toolCalls = new ArrayList<ChatCompletionsToolCall>();
        if (left.getToolCalls() == null) {
            if (right.getToolCalls() != null) {
                toolCalls.addAll(right.getToolCalls());
            }
        } else if (right.getToolCalls() == null) {
            toolCalls.addAll(left.getToolCalls());
        } else {
            toolCalls.addAll(left.getToolCalls());
            int lastToolIndex = toolCalls.size() - 1;
            ChatCompletionsToolCall lastTool = (ChatCompletionsToolCall)toolCalls.get(lastToolIndex);
            if (((ChatCompletionsToolCall)right.getToolCalls().get(0)).getId() == null) {
                lastTool = MergeUtils.mergeChatCompletionsToolCall(lastTool, (ChatCompletionsToolCall)right.getToolCalls().get(0));
                toolCalls.remove(lastToolIndex);
                toolCalls.add(lastTool);
            } else {
                toolCalls.add((ChatCompletionsToolCall)right.getToolCalls().get(0));
            }
        }
        MergeUtils.setField(instance, "toolCalls", toolCalls);
        FunctionCall functionCall = null;
        functionCall = left.getFunctionCall() == null ? right.getFunctionCall() : MergeUtils.mergeFunctionCall(left.getFunctionCall(), right.getFunctionCall());
        MergeUtils.setField(instance, "functionCall", functionCall);
        AzureChatExtensionsMessageContext context = left.getContext() != null ? left.getContext() : right.getContext();
        MergeUtils.setField(instance, "context", context);
        return instance;
    }

    private static ChatCompletionsToolCall mergeChatCompletionsToolCall(ChatCompletionsToolCall left, ChatCompletionsToolCall right) {
        Assert.isTrue((boolean)Objects.equals(left.getType(), right.getType()), (String)"Cannot merge different type of AccessibleChatCompletionsToolCall");
        if (!"function".equals(left.getType())) {
            throw new UnsupportedOperationException("Only function chat completion tool is supported");
        }
        String id = left.getId() != null ? left.getId() : right.getId();
        FunctionCall mergedFunction = MergeUtils.mergeFunctionCall(((ChatCompletionsFunctionToolCall)left).getFunction(), ((ChatCompletionsFunctionToolCall)right).getFunction());
        return new ChatCompletionsFunctionToolCall(id, mergedFunction);
    }

    private static FunctionCall mergeFunctionCall(FunctionCall left, FunctionCall right) {
        String name = left.getName() != null ? left.getName() : right.getName();
        Object arguments = null;
        arguments = left.getArguments() != null && right.getArguments() != null ? left.getArguments() + right.getArguments() : (left.getArguments() == null ? right.getArguments() : left.getArguments());
        return new FunctionCall(name, (String)arguments);
    }
}

