/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsJsonResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsTextResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolDefinition;
import com.azure.ai.openai.models.ChatMessageImageContentItem;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.ai.openai.models.ChatMessageTextContentItem;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.core.util.BinaryData;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.ai.azure.openai.AzureOpenAiChatOptions;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.azure.openai.MergeUtils;
import org.springframework.ai.azure.openai.metadata.AzureOpenAiUsage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.PromptMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AzureOpenAiChatModel
extends AbstractToolCallSupport
implements ChatModel {
    private static final String DEFAULT_DEPLOYMENT_NAME = "gpt-4o";
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private final OpenAIClient openAIClient;
    private final OpenAIAsyncClient openAIAsyncClient;
    private final AzureOpenAiChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder) {
        this(openAIClientBuilder, AzureOpenAiChatOptions.builder().withDeploymentName(DEFAULT_DEPLOYMENT_NAME).withTemperature(DEFAULT_TEMPERATURE).build());
    }

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions options) {
        this(openAIClientBuilder, options, null);
    }

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions options, FunctionCallbackContext functionCallbackContext) {
        this(openAIClientBuilder, options, functionCallbackContext, List.of());
    }

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions options, FunctionCallbackContext functionCallbackContext, List<FunctionCallback> toolFunctionCallbacks) {
        this(openAIClientBuilder, options, functionCallbackContext, List.of(), ObservationRegistry.NOOP);
    }

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions options, FunctionCallbackContext functionCallbackContext, List<FunctionCallback> toolFunctionCallbacks, ObservationRegistry observationRegistry) {
        super(functionCallbackContext, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)openAIClientBuilder, (String)"com.azure.ai.openai.OpenAIClient must not be null");
        Assert.notNull((Object)options, (String)"AzureOpenAiChatOptions must not be null");
        this.openAIClient = openAIClientBuilder.buildClient();
        this.openAIAsyncClient = openAIClientBuilder.buildAsyncClient();
        this.defaultOptions = options;
        this.observationRegistry = observationRegistry;
    }

    public AzureOpenAiChatOptions getDefaultOptions() {
        return AzureOpenAiChatOptions.fromOptions(this.defaultOptions);
    }

    public ChatResponse call(Prompt prompt) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.AZURE_OPENAI.value()).requestOptions((ChatOptions)(prompt.getOptions() != null ? prompt.getOptions() : this.defaultOptions)).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ChatCompletionsOptions options = this.toAzureChatCompletionsOptions(prompt);
            options.setStream(Boolean.valueOf(false));
            ChatCompletions chatCompletions = this.openAIClient.getChatCompletions(options.getModel(), options);
            ChatResponse chatResponse = this.toChatResponse(chatCompletions);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(response, Set.of(String.valueOf(CompletionsFinishReason.TOOL_CALLS).toLowerCase()))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.call(new Prompt(toolCallConversation, prompt.getOptions()));
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            ChatCompletionsOptions options = this.toAzureChatCompletionsOptions(prompt);
            options.setStream(Boolean.valueOf(true));
            Flux chatCompletionsStream = this.openAIAsyncClient.getChatCompletionsStream(options.getModel(), options);
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.AZURE_OPENAI.value()).requestOptions((ChatOptions)(prompt.getOptions() != null ? prompt.getOptions() : this.defaultOptions)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            AtomicBoolean isFunctionCall = new AtomicBoolean(false);
            Flux accessibleChatCompletionsFlux = chatCompletionsStream.filter(chatCompletions -> !CollectionUtils.isEmpty((Collection)chatCompletions.getChoices())).map(chatCompletions -> {
                List toolCalls = ((ChatChoice)chatCompletions.getChoices().get(0)).getDelta().getToolCalls();
                isFunctionCall.set(toolCalls != null && !toolCalls.isEmpty());
                return chatCompletions;
            }).windowUntil(chatCompletions -> {
                if (isFunctionCall.get() && ((ChatChoice)chatCompletions.getChoices().get(0)).getFinishReason() == CompletionsFinishReason.TOOL_CALLS) {
                    isFunctionCall.set(false);
                    return true;
                }
                return !isFunctionCall.get();
            }).concatMapIterable(window -> {
                Mono reduce = window.reduce((Object)MergeUtils.emptyChatCompletions(), MergeUtils::mergeChatCompletions);
                return List.of(reduce);
            }).flatMap(mono -> mono);
            return accessibleChatCompletionsFlux.switchMap(chatCompletions -> {
                ChatResponse chatResponse = this.toChatResponse((ChatCompletions)chatCompletions);
                if (!this.isProxyToolCalls(prompt, this.defaultOptions) && this.isToolCall(chatResponse, Set.of(String.valueOf(CompletionsFinishReason.TOOL_CALLS).toLowerCase()))) {
                    List toolCallConversation = this.handleToolCalls(prompt, chatResponse);
                    return this.stream(new Prompt(toolCallConversation, prompt.getOptions()));
                }
                Flux flux = Flux.just((Object)chatResponse).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
            });
        });
    }

    private ChatResponse toChatResponse(ChatCompletions chatCompletions) {
        List<Generation> generations = this.nullSafeList(chatCompletions.getChoices()).stream().map(choice -> {
            Map<String, Object> metadata = Map.of("id", chatCompletions.getId() != null ? chatCompletions.getId() : "", "choiceIndex", choice.getIndex(), "finishReason", choice.getFinishReason() != null ? String.valueOf(choice.getFinishReason()) : "");
            return this.buildGeneration((ChatChoice)choice, metadata);
        }).toList();
        PromptMetadata promptFilterMetadata = this.generatePromptMetadata(chatCompletions);
        return new ChatResponse(generations, AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata));
    }

    private Generation buildGeneration(ChatChoice choice, Map<String, Object> metadata) {
        ChatResponseMessage responseMessage = Optional.ofNullable(choice.getMessage()).orElse(choice.getDelta());
        List toolCalls = responseMessage.getToolCalls() == null ? List.of() : responseMessage.getToolCalls().stream().map(toolCall -> {
            ChatCompletionsFunctionToolCall tc1 = (ChatCompletionsFunctionToolCall)toolCall;
            String id = tc1.getId();
            String name = tc1.getFunction().getName();
            String arguments = tc1.getFunction().getArguments();
            return new AssistantMessage.ToolCall(id, "function", name, arguments);
        }).toList();
        AssistantMessage assistantMessage = new AssistantMessage(responseMessage.getContent(), metadata, toolCalls);
        ChatGenerationMetadata generationMetadata = this.generateChoiceMetadata(choice);
        return new Generation(assistantMessage, generationMetadata);
    }

    public static ChatResponseMetadata from(ChatCompletions chatCompletions, PromptMetadata promptFilterMetadata) {
        Assert.notNull((Object)chatCompletions, (String)"Azure OpenAI ChatCompletions must not be null");
        String id = chatCompletions.getId();
        AzureOpenAiUsage usage = chatCompletions.getUsage() != null ? AzureOpenAiUsage.from(chatCompletions) : new EmptyUsage();
        return ChatResponseMetadata.builder().withId(id).withUsage((Usage)usage).withModel(chatCompletions.getModel()).withPromptMetadata(promptFilterMetadata).withKeyValue("system-fingerprint", (Object)chatCompletions.getSystemFingerprint()).build();
    }

    ChatCompletionsOptions toAzureChatCompletionsOptions(Prompt prompt) {
        HashSet<String> functionsForThisRequest = new HashSet<String>();
        List azureMessages = prompt.getInstructions().stream().map(this::fromSpringAiMessage).flatMap(Collection::stream).toList();
        ChatCompletionsOptions options = new ChatCompletionsOptions(azureMessages);
        options = this.merge(options, this.defaultOptions);
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            functionsForThisRequest.addAll(this.defaultOptions.getFunctions());
        }
        if (prompt.getOptions() != null) {
            AzureOpenAiChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                updatedRuntimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, AzureOpenAiChatOptions.class);
            } else {
                updatedRuntimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AzureOpenAiChatOptions.class);
            }
            options = this.merge(updatedRuntimeOptions, options);
            functionsForThisRequest.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
        }
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            List<ChatCompletionsFunctionToolDefinition> tools = this.getFunctionTools(functionsForThisRequest);
            List<ChatCompletionsToolDefinition> tools2 = tools.stream().map(t -> t).toList();
            options.setTools(tools2);
        }
        return options;
    }

    private List<ChatCompletionsFunctionToolDefinition> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            FunctionDefinition functionDefinition = new FunctionDefinition(functionCallback.getName());
            functionDefinition.setDescription(functionCallback.getDescription());
            BinaryData parameters = BinaryData.fromObject((Object)ModelOptionsUtils.jsonToMap((String)functionCallback.getInputTypeSchema()));
            functionDefinition.setParameters(parameters);
            return new ChatCompletionsFunctionToolDefinition(functionDefinition);
        }).toList();
    }

    private List<ChatRequestMessage> fromSpringAiMessage(Message message) {
        switch (message.getMessageType()) {
            case USER: {
                UserMessage userMessage;
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(new ChatMessageTextContentItem(message.getContent()));
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    items.addAll(userMessage.getMedia().stream().map(media -> new ChatMessageImageContentItem(new ChatMessageImageUrl(this.getMediaUrl((Media)media)))).toList());
                }
                return List.of(new ChatRequestUserMessage(items));
            }
            case SYSTEM: {
                return List.of(new ChatRequestSystemMessage(message.getContent()));
            }
            case ASSISTANT: {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<ChatCompletionsToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        FunctionCall function = new FunctionCall(toolCall.name(), toolCall.arguments());
                        return new ChatCompletionsFunctionToolCall(toolCall.id(), function);
                    }).map(tc -> tc).toList();
                }
                ChatRequestAssistantMessage azureAssistantMessage = new ChatRequestAssistantMessage(message.getContent());
                azureAssistantMessage.setToolCalls(toolCalls);
                return List.of(azureAssistantMessage);
            }
            case TOOL: {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new ChatRequestToolMessage(tr.responseData(), tr.id())).map(crtm -> crtm).toList();
            }
        }
        throw new IllegalArgumentException("Unknown message type " + message.getMessageType());
    }

    private String getMediaUrl(Media media) {
        Object data = media.getData();
        if (data instanceof String) {
            String dataUrl = (String)data;
            return dataUrl;
        }
        if (data instanceof byte[]) {
            byte[] dataBytes = (byte[])data;
            String base64EncodedData = Base64.getEncoder().encodeToString(dataBytes);
            return "data:" + media.getMimeType() + ";base64," + base64EncodedData;
        }
        throw new IllegalArgumentException("Unknown media data type " + data.getClass().getName());
    }

    private ChatGenerationMetadata generateChoiceMetadata(ChatChoice choice) {
        return ChatGenerationMetadata.from((String)String.valueOf(choice.getFinishReason()), (Object)choice.getContentFilterResults());
    }

    private PromptMetadata generatePromptMetadata(ChatCompletions chatCompletions) {
        List promptFilterResults = this.nullSafeList(chatCompletions.getPromptFilterResults());
        return PromptMetadata.of(promptFilterResults.stream().map(promptFilterResult -> PromptMetadata.PromptFilterMetadata.from((int)promptFilterResult.getPromptIndex(), (Object)promptFilterResult.getContentFilterResults())).toList());
    }

    private <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private ChatCompletionsOptions merge(ChatCompletionsOptions fromAzureOptions, AzureOpenAiChatOptions toSpringAiOptions) {
        if (toSpringAiOptions == null) {
            return fromAzureOptions;
        }
        ChatCompletionsOptions mergedAzureOptions = new ChatCompletionsOptions(fromAzureOptions.getMessages());
        mergedAzureOptions.setStream(fromAzureOptions.isStream());
        mergedAzureOptions.setMaxTokens(fromAzureOptions.getMaxTokens() != null ? fromAzureOptions.getMaxTokens() : toSpringAiOptions.getMaxTokens());
        mergedAzureOptions.setLogitBias(fromAzureOptions.getLogitBias() != null ? fromAzureOptions.getLogitBias() : toSpringAiOptions.getLogitBias());
        mergedAzureOptions.setStop(fromAzureOptions.getStop() != null ? fromAzureOptions.getStop() : toSpringAiOptions.getStop());
        mergedAzureOptions.setTemperature(fromAzureOptions.getTemperature());
        if (mergedAzureOptions.getTemperature() == null && toSpringAiOptions.getTemperature() != null) {
            mergedAzureOptions.setTemperature(toSpringAiOptions.getTemperature());
        }
        mergedAzureOptions.setTopP(fromAzureOptions.getTopP());
        if (mergedAzureOptions.getTopP() == null && toSpringAiOptions.getTopP() != null) {
            mergedAzureOptions.setTopP(toSpringAiOptions.getTopP());
        }
        mergedAzureOptions.setFrequencyPenalty(fromAzureOptions.getFrequencyPenalty());
        if (mergedAzureOptions.getFrequencyPenalty() == null && toSpringAiOptions.getFrequencyPenalty() != null) {
            mergedAzureOptions.setFrequencyPenalty(toSpringAiOptions.getFrequencyPenalty());
        }
        mergedAzureOptions.setPresencePenalty(fromAzureOptions.getPresencePenalty());
        if (mergedAzureOptions.getPresencePenalty() == null && toSpringAiOptions.getPresencePenalty() != null) {
            mergedAzureOptions.setPresencePenalty(toSpringAiOptions.getPresencePenalty());
        }
        mergedAzureOptions.setResponseFormat(fromAzureOptions.getResponseFormat());
        if (mergedAzureOptions.getResponseFormat() == null && toSpringAiOptions.getResponseFormat() != null) {
            mergedAzureOptions.setResponseFormat(this.toAzureResponseFormat(toSpringAiOptions.getResponseFormat()));
        }
        mergedAzureOptions.setN(fromAzureOptions.getN() != null ? fromAzureOptions.getN() : toSpringAiOptions.getN());
        mergedAzureOptions.setUser(fromAzureOptions.getUser() != null ? fromAzureOptions.getUser() : toSpringAiOptions.getUser());
        mergedAzureOptions.setModel(fromAzureOptions.getModel() != null ? fromAzureOptions.getModel() : toSpringAiOptions.getDeploymentName());
        mergedAzureOptions.setSeed(fromAzureOptions.getSeed() != null ? fromAzureOptions.getSeed() : toSpringAiOptions.getSeed());
        mergedAzureOptions.setLogprobs(Boolean.valueOf(fromAzureOptions.isLogprobs() != null && fromAzureOptions.isLogprobs() != false || toSpringAiOptions.isLogprobs() != null && toSpringAiOptions.isLogprobs() != false));
        mergedAzureOptions.setTopLogprobs(fromAzureOptions.getTopLogprobs() != null ? fromAzureOptions.getTopLogprobs() : toSpringAiOptions.getTopLogProbs());
        mergedAzureOptions.setEnhancements(fromAzureOptions.getEnhancements() != null ? fromAzureOptions.getEnhancements() : toSpringAiOptions.getEnhancements());
        return mergedAzureOptions;
    }

    private ChatCompletionsOptions merge(AzureOpenAiChatOptions fromSpringAiOptions, ChatCompletionsOptions toAzureOptions) {
        if (fromSpringAiOptions == null) {
            return toAzureOptions;
        }
        ChatCompletionsOptions mergedAzureOptions = this.copy(toAzureOptions);
        if (fromSpringAiOptions.getMaxTokens() != null) {
            mergedAzureOptions.setMaxTokens(fromSpringAiOptions.getMaxTokens());
        }
        if (fromSpringAiOptions.getLogitBias() != null) {
            mergedAzureOptions.setLogitBias(fromSpringAiOptions.getLogitBias());
        }
        if (fromSpringAiOptions.getStop() != null) {
            mergedAzureOptions.setStop(fromSpringAiOptions.getStop());
        }
        if (fromSpringAiOptions.getTemperature() != null) {
            mergedAzureOptions.setTemperature(fromSpringAiOptions.getTemperature());
        }
        if (fromSpringAiOptions.getTopP() != null) {
            mergedAzureOptions.setTopP(fromSpringAiOptions.getTopP());
        }
        if (fromSpringAiOptions.getFrequencyPenalty() != null) {
            mergedAzureOptions.setFrequencyPenalty(fromSpringAiOptions.getFrequencyPenalty());
        }
        if (fromSpringAiOptions.getPresencePenalty() != null) {
            mergedAzureOptions.setPresencePenalty(fromSpringAiOptions.getPresencePenalty());
        }
        if (fromSpringAiOptions.getN() != null) {
            mergedAzureOptions.setN(fromSpringAiOptions.getN());
        }
        if (fromSpringAiOptions.getUser() != null) {
            mergedAzureOptions.setUser(fromSpringAiOptions.getUser());
        }
        if (fromSpringAiOptions.getDeploymentName() != null) {
            mergedAzureOptions.setModel(fromSpringAiOptions.getDeploymentName());
        }
        if (fromSpringAiOptions.getResponseFormat() != null) {
            mergedAzureOptions.setResponseFormat(this.toAzureResponseFormat(fromSpringAiOptions.getResponseFormat()));
        }
        if (fromSpringAiOptions.getSeed() != null) {
            mergedAzureOptions.setSeed(fromSpringAiOptions.getSeed());
        }
        if (fromSpringAiOptions.isLogprobs() != null) {
            mergedAzureOptions.setLogprobs(fromSpringAiOptions.isLogprobs());
        }
        if (fromSpringAiOptions.getTopLogProbs() != null) {
            mergedAzureOptions.setTopLogprobs(fromSpringAiOptions.getTopLogProbs());
        }
        if (fromSpringAiOptions.getEnhancements() != null) {
            mergedAzureOptions.setEnhancements(fromSpringAiOptions.getEnhancements());
        }
        return mergedAzureOptions;
    }

    private ChatCompletionsOptions copy(ChatCompletionsOptions fromOptions) {
        ChatCompletionsOptions copyOptions = new ChatCompletionsOptions(fromOptions.getMessages());
        copyOptions.setStream(fromOptions.isStream());
        if (fromOptions.getMaxTokens() != null) {
            copyOptions.setMaxTokens(fromOptions.getMaxTokens());
        }
        if (fromOptions.getLogitBias() != null) {
            copyOptions.setLogitBias(fromOptions.getLogitBias());
        }
        if (fromOptions.getStop() != null) {
            copyOptions.setStop(fromOptions.getStop());
        }
        if (fromOptions.getTemperature() != null) {
            copyOptions.setTemperature(fromOptions.getTemperature());
        }
        if (fromOptions.getTopP() != null) {
            copyOptions.setTopP(fromOptions.getTopP());
        }
        if (fromOptions.getFrequencyPenalty() != null) {
            copyOptions.setFrequencyPenalty(fromOptions.getFrequencyPenalty());
        }
        if (fromOptions.getPresencePenalty() != null) {
            copyOptions.setPresencePenalty(fromOptions.getPresencePenalty());
        }
        if (fromOptions.getN() != null) {
            copyOptions.setN(fromOptions.getN());
        }
        if (fromOptions.getUser() != null) {
            copyOptions.setUser(fromOptions.getUser());
        }
        if (fromOptions.getModel() != null) {
            copyOptions.setModel(fromOptions.getModel());
        }
        if (fromOptions.getResponseFormat() != null) {
            copyOptions.setResponseFormat(fromOptions.getResponseFormat());
        }
        if (fromOptions.getSeed() != null) {
            copyOptions.setSeed(fromOptions.getSeed());
        }
        copyOptions.setLogprobs(fromOptions.isLogprobs());
        if (fromOptions.getTopLogprobs() != null) {
            copyOptions.setTopLogprobs(fromOptions.getTopLogprobs());
        }
        if (fromOptions.getEnhancements() != null) {
            copyOptions.setEnhancements(fromOptions.getEnhancements());
        }
        return copyOptions;
    }

    private ChatCompletionsResponseFormat toAzureResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        if (responseFormat == AzureOpenAiResponseFormat.JSON) {
            return new ChatCompletionsJsonResponseFormat();
        }
        return new ChatCompletionsTextResponseFormat();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

