/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.AudioTranscription;
import com.azure.ai.openai.models.AudioTranscriptionFormat;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.azure.core.http.rest.Response;
import java.io.IOException;
import java.util.List;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.ai.audio.transcription.AudioTranscriptionPrompt;
import org.springframework.ai.audio.transcription.AudioTranscriptionResponse;
import org.springframework.ai.audio.transcription.AudioTranscriptionResponseMetadata;
import org.springframework.ai.azure.openai.AzureOpenAiAudioTranscriptionOptions;
import org.springframework.ai.azure.openai.metadata.AzureOpenAiAudioTranscriptionResponseMetadata;
import org.springframework.ai.model.Model;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AzureOpenAiAudioTranscriptionModel
implements Model<AudioTranscriptionPrompt, AudioTranscriptionResponse> {
    private static final List<AudioTranscriptionFormat> JSON_FORMATS = List.of(AudioTranscriptionFormat.JSON, AudioTranscriptionFormat.VERBOSE_JSON);
    private static final String FILENAME_MARKER = "filename.wav";
    private final OpenAIClient openAIClient;
    private final AzureOpenAiAudioTranscriptionOptions defaultOptions;

    public AzureOpenAiAudioTranscriptionModel(OpenAIClient openAIClient, AzureOpenAiAudioTranscriptionOptions options) {
        this.openAIClient = openAIClient;
        this.defaultOptions = options;
    }

    public String call(Resource audioResource) {
        AudioTranscriptionPrompt transcriptionRequest = new AudioTranscriptionPrompt(audioResource);
        return this.call(transcriptionRequest).getResult().getOutput();
    }

    public AudioTranscriptionResponse call(AudioTranscriptionPrompt audioTranscriptionPrompt) {
        String deploymentOrModelName = this.getDeploymentName(audioTranscriptionPrompt);
        com.azure.ai.openai.models.AudioTranscriptionOptions audioTranscriptionOptions = this.toAudioTranscriptionOptions(audioTranscriptionPrompt);
        AudioTranscriptionFormat responseFormat = audioTranscriptionOptions.getResponseFormat();
        if (JSON_FORMATS.contains(responseFormat)) {
            AudioTranscription audioTranscription = this.openAIClient.getAudioTranscription(deploymentOrModelName, FILENAME_MARKER, audioTranscriptionOptions);
            List<AzureOpenAiAudioTranscriptionOptions.StructuredResponse.Word> words = null;
            if (audioTranscription.getWords() != null) {
                words = audioTranscription.getWords().stream().map(w -> {
                    float start = w.getStart().toSeconds();
                    float end = w.getEnd().toSeconds();
                    return new AzureOpenAiAudioTranscriptionOptions.StructuredResponse.Word(w.getWord(), Float.valueOf(start), Float.valueOf(end));
                }).toList();
            }
            List<AzureOpenAiAudioTranscriptionOptions.StructuredResponse.Segment> segments = null;
            if (audioTranscription.getSegments() != null) {
                segments = audioTranscription.getSegments().stream().map(s -> {
                    float start = s.getStart().toSeconds();
                    float end = s.getEnd().toSeconds();
                    return new AzureOpenAiAudioTranscriptionOptions.StructuredResponse.Segment(s.getId(), s.getSeek(), Float.valueOf(start), Float.valueOf(end), s.getText(), s.getTokens(), Float.valueOf((float)s.getTemperature()), Float.valueOf((float)s.getAvgLogprob()), Float.valueOf((float)s.getCompressionRatio()), Float.valueOf((float)s.getNoSpeechProb()));
                }).toList();
            }
            Float duration = audioTranscription.getDuration() == null ? null : Float.valueOf(audioTranscription.getDuration().toSeconds());
            AzureOpenAiAudioTranscriptionOptions.StructuredResponse structuredResponse = new AzureOpenAiAudioTranscriptionOptions.StructuredResponse(audioTranscription.getLanguage(), duration, audioTranscription.getText(), words, segments);
            org.springframework.ai.audio.transcription.AudioTranscription transcript = new org.springframework.ai.audio.transcription.AudioTranscription(structuredResponse.text());
            AzureOpenAiAudioTranscriptionResponseMetadata metadata = AzureOpenAiAudioTranscriptionResponseMetadata.from(structuredResponse);
            return new AudioTranscriptionResponse(transcript, (AudioTranscriptionResponseMetadata)metadata);
        }
        Response audioTranscription = this.openAIClient.getAudioTranscriptionTextWithResponse(deploymentOrModelName, FILENAME_MARKER, audioTranscriptionOptions, null);
        String text = (String)audioTranscription.getValue();
        org.springframework.ai.audio.transcription.AudioTranscription transcript = new org.springframework.ai.audio.transcription.AudioTranscription(text);
        return new AudioTranscriptionResponse(transcript, (AudioTranscriptionResponseMetadata)AzureOpenAiAudioTranscriptionResponseMetadata.from(text));
    }

    private String getDeploymentName(AudioTranscriptionPrompt audioTranscriptionPrompt) {
        AzureOpenAiAudioTranscriptionOptions azureOpenAiAudioTranscriptionOptions;
        String deploymentName;
        AudioTranscriptionOptions runtimeOptions = audioTranscriptionPrompt.getOptions();
        if (this.defaultOptions != null) {
            runtimeOptions = (AudioTranscriptionOptions)ModelOptionsUtils.merge((Object)runtimeOptions, (Object)this.defaultOptions, AzureOpenAiAudioTranscriptionOptions.class);
        }
        if (runtimeOptions instanceof AzureOpenAiAudioTranscriptionOptions && StringUtils.hasText((String)(deploymentName = (azureOpenAiAudioTranscriptionOptions = (AzureOpenAiAudioTranscriptionOptions)runtimeOptions).getDeploymentName()))) {
            return deploymentName;
        }
        return runtimeOptions.getModel();
    }

    private com.azure.ai.openai.models.AudioTranscriptionOptions toAudioTranscriptionOptions(AudioTranscriptionPrompt audioTranscriptionPrompt) {
        AudioTranscriptionOptions runtimeOptions = audioTranscriptionPrompt.getOptions();
        if (this.defaultOptions != null) {
            runtimeOptions = (AudioTranscriptionOptions)ModelOptionsUtils.merge((Object)runtimeOptions, (Object)this.defaultOptions, AzureOpenAiAudioTranscriptionOptions.class);
        }
        byte[] bytes = AzureOpenAiAudioTranscriptionModel.toBytes(audioTranscriptionPrompt.getInstructions());
        com.azure.ai.openai.models.AudioTranscriptionOptions audioTranscriptionOptions = new com.azure.ai.openai.models.AudioTranscriptionOptions(bytes);
        if (runtimeOptions instanceof AzureOpenAiAudioTranscriptionOptions) {
            Float temperature;
            String prompt;
            String language;
            AzureOpenAiAudioTranscriptionOptions azureOpenAiAudioTranscriptionOptions = (AzureOpenAiAudioTranscriptionOptions)runtimeOptions;
            String model = azureOpenAiAudioTranscriptionOptions.getModel();
            if (StringUtils.hasText((String)model)) {
                audioTranscriptionOptions.setModel(model);
            }
            if (StringUtils.hasText((String)(language = azureOpenAiAudioTranscriptionOptions.getLanguage()))) {
                audioTranscriptionOptions.setLanguage(language);
            }
            if (StringUtils.hasText((String)(prompt = azureOpenAiAudioTranscriptionOptions.getPrompt()))) {
                audioTranscriptionOptions.setPrompt(prompt);
            }
            if ((temperature = azureOpenAiAudioTranscriptionOptions.getTemperature()) != null) {
                audioTranscriptionOptions.setTemperature(Double.valueOf(temperature.doubleValue()));
            }
            AzureOpenAiAudioTranscriptionOptions.TranscriptResponseFormat responseFormat = azureOpenAiAudioTranscriptionOptions.getResponseFormat();
            List<AzureOpenAiAudioTranscriptionOptions.GranularityType> granularityType = azureOpenAiAudioTranscriptionOptions.getGranularityType();
            if (responseFormat != null) {
                audioTranscriptionOptions.setResponseFormat(responseFormat.getValue());
                if (responseFormat == AzureOpenAiAudioTranscriptionOptions.TranscriptResponseFormat.VERBOSE_JSON && granularityType == null) {
                    granularityType = List.of(AzureOpenAiAudioTranscriptionOptions.GranularityType.SEGMENT);
                }
            }
            if (granularityType != null) {
                Assert.isTrue((responseFormat == AzureOpenAiAudioTranscriptionOptions.TranscriptResponseFormat.VERBOSE_JSON ? 1 : 0) != 0, (String)"response_format must be set to verbose_json to use timestamp granularities.");
                List<AudioTranscriptionTimestampGranularity> granularity = granularityType.stream().map(AzureOpenAiAudioTranscriptionOptions.GranularityType::getValue).toList();
                audioTranscriptionOptions.setTimestampGranularities(granularity);
            }
        }
        return audioTranscriptionOptions;
    }

    private static byte[] toBytes(Resource resource) {
        try {
            return resource.getInputStream().readAllBytes();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read resource: " + resource, e);
        }
    }
}

