/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.cosmosdb;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

class CosmosDBFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private Map<String, String> metadataFields;

    CosmosDBFilterExpressionConverter(Collection<String> columns) {
        this.metadataFields = columns.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    private Optional<String> getMetadataField(String name) {
        String metadataField = name;
        return Optional.ofNullable(this.metadataFields.get(metadataField));
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        String keyName = key.key();
        Optional<String> metadataField = this.getMetadataField(keyName);
        if (!metadataField.isPresent()) {
            throw new IllegalArgumentException(String.format("No metadata field %s has been configured", keyName));
        }
        context.append("c.metadata." + metadataField.get());
    }

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (Filter.ExpressionType.AND.equals((Object)expression.type()) || Filter.ExpressionType.OR.equals((Object)expression.type())) {
            this.doCompoundExpressionType(expression, context);
        } else {
            this.doSingleExpressionType(expression, context);
        }
    }

    private void doCompoundExpressionType(Filter.Expression expression, StringBuilder context) {
        int end;
        context.append(" (");
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        context.append(" (");
        this.convertOperand(expression.right(), context);
        int start = context.indexOf("[");
        if (start != -1) {
            context.replace(start, start + 1, "");
        }
        if ((end = context.indexOf("]")) != -1) {
            context.replace(end, end + 1, "");
        }
        context.append(")");
        context.append(")");
    }

    private void doSingleExpressionType(Filter.Expression expression, StringBuilder context) {
        int end;
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        context.append(" (");
        this.convertOperand(expression.right(), context);
        int start = context.indexOf("[");
        if (start != -1) {
            context.replace(start, start + 1, "");
        }
        if ((end = context.indexOf("]")) != -1) {
            context.replace(end, end + 1, "");
        }
        context.append(")");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " AND ";
            case Filter.ExpressionType.OR -> " OR ";
            case Filter.ExpressionType.EQ -> " = ";
            case Filter.ExpressionType.NE -> " != ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.IN -> " IN ";
            case Filter.ExpressionType.NIN -> " !IN ";
            default -> throw new RuntimeException("Not supported expression type:" + String.valueOf(exp.type()));
        };
    }
}

