/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.vertexai.autoconfigure.embedding;

import com.google.cloud.vertexai.VertexAI;
import org.springframework.ai.model.vertexai.autoconfigure.embedding.VertexAiEmbeddingConnectionProperties;
import org.springframework.ai.vertexai.embedding.VertexAiEmbeddingConnectionDetails;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={VertexAI.class})
@EnableConfigurationProperties(value={VertexAiEmbeddingConnectionProperties.class})
public class VertexAiEmbeddingConnectionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiEmbeddingConnectionDetails connectionDetails(VertexAiEmbeddingConnectionProperties connectionProperties) {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        VertexAiEmbeddingConnectionDetails.Builder connectionBuilder = VertexAiEmbeddingConnectionDetails.builder().projectId(connectionProperties.getProjectId()).location(connectionProperties.getLocation());
        if (StringUtils.hasText((String)connectionProperties.getApiEndpoint())) {
            connectionBuilder.apiEndpoint(connectionProperties.getApiEndpoint());
        }
        return connectionBuilder.build();
    }
}

