/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.elevenlabs.autoconfigure;

import org.springframework.ai.elevenlabs.ElevenLabsTextToSpeechModel;
import org.springframework.ai.elevenlabs.api.ElevenLabsApi;
import org.springframework.ai.model.elevenlabs.autoconfigure.ElevenLabsConnectionProperties;
import org.springframework.ai.model.elevenlabs.autoconfigure.ElevenLabsSpeechProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class, WebClientAutoConfiguration.class})
@ConditionalOnClass(value={ElevenLabsApi.class})
@EnableConfigurationProperties(value={ElevenLabsSpeechProperties.class, ElevenLabsConnectionProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.audio.speech"}, havingValue="elevenlabs", matchIfMissing=true)
public class ElevenLabsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ElevenLabsApi elevenLabsApi(ElevenLabsConnectionProperties connectionProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        return ElevenLabsApi.builder().baseUrl(connectionProperties.getBaseUrl()).apiKey(connectionProperties.getApiKey()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).webClientBuilder((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).responseErrorHandler(responseErrorHandler).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ElevenLabsTextToSpeechModel elevenLabsSpeechModel(ElevenLabsApi elevenLabsApi, ElevenLabsSpeechProperties speechProperties, RetryTemplate retryTemplate) {
        return ElevenLabsTextToSpeechModel.builder().elevenLabsApi(elevenLabsApi).defaultOptions(speechProperties.getOptions()).retryTemplate(retryTemplate).build();
    }
}

