/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.bedrock.converse.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.bedrock.converse.BedrockProxyChatModel;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionConfiguration;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionProperties;
import org.springframework.ai.model.bedrock.converse.autoconfigure.BedrockConverseProxyChatProperties;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;

@AutoConfiguration(after={ToolCallingAutoConfiguration.class})
@EnableConfigurationProperties(value={BedrockConverseProxyChatProperties.class, BedrockAwsConnectionConfiguration.class})
@ConditionalOnClass(value={BedrockProxyChatModel.class, BedrockRuntimeClient.class, BedrockRuntimeAsyncClient.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="bedrock-converse", matchIfMissing=true)
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockConverseProxyChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AwsCredentialsProvider.class, AwsRegionProvider.class})
    public BedrockProxyChatModel bedrockProxyChatModel(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, BedrockAwsConnectionProperties connectionProperties, BedrockConverseProxyChatProperties chatProperties, ToolCallingManager toolCallingManager, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<BedrockRuntimeClient> bedrockRuntimeClient, ObjectProvider<BedrockRuntimeAsyncClient> bedrockRuntimeAsyncClient, ObjectProvider<ToolExecutionEligibilityPredicate> bedrockToolExecutionEligibilityPredicate) {
        BedrockProxyChatModel chatModel = BedrockProxyChatModel.builder().credentialsProvider(credentialsProvider).region(regionProvider.getRegion()).timeout(connectionProperties.getTimeout()).connectionTimeout(connectionProperties.getConnectionTimeout()).asyncReadTimeout(connectionProperties.getAsyncReadTimeout()).connectionAcquisitionTimeout(connectionProperties.getConnectionAcquisitionTimeout()).socketTimeout(connectionProperties.getSocketTimeout()).defaultOptions(chatProperties.getOptions()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).toolCallingManager(toolCallingManager).toolExecutionEligibilityPredicate((ToolExecutionEligibilityPredicate)bedrockToolExecutionEligibilityPredicate.getIfUnique(DefaultToolExecutionEligibilityPredicate::new)).bedrockRuntimeClient((BedrockRuntimeClient)bedrockRuntimeClient.getIfAvailable()).bedrockRuntimeAsyncClient((BedrockRuntimeAsyncClient)bedrockRuntimeAsyncClient.getIfAvailable()).build();
        observationConvention.ifAvailable(arg_0 -> ((BedrockProxyChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }
}

