/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.bedrock.titan.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingModel;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionConfiguration;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionProperties;
import org.springframework.ai.model.bedrock.titan.autoconfigure.BedrockTitanEmbeddingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

@AutoConfiguration
@ConditionalOnClass(value={TitanEmbeddingBedrockApi.class})
@EnableConfigurationProperties(value={BedrockTitanEmbeddingProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding"}, havingValue="bedrock-titan", matchIfMissing=true)
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockTitanEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AwsCredentialsProvider.class, AwsRegionProvider.class})
    public TitanEmbeddingBedrockApi titanEmbeddingBedrockApi(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, BedrockTitanEmbeddingProperties properties, BedrockAwsConnectionProperties awsProperties, ObjectMapper objectMapper) {
        return new TitanEmbeddingBedrockApi(properties.getModel(), credentialsProvider, regionProvider.getRegion(), objectMapper, awsProperties.getTimeout());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={TitanEmbeddingBedrockApi.class})
    public BedrockTitanEmbeddingModel titanEmbeddingModel(TitanEmbeddingBedrockApi titanEmbeddingApi, BedrockTitanEmbeddingProperties properties) {
        return new BedrockTitanEmbeddingModel(titanEmbeddingApi).withInputType(properties.getInputType());
    }
}

