/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.anthropic.api.AnthropicCacheOptions;
import org.springframework.ai.anthropic.api.CitationDocument;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.StructuredOutputChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnthropicChatOptions
implements ToolCallingChatOptions,
StructuredOutputChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="metadata")
    private AnthropicApi.ChatCompletionRequest.Metadata metadata;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="tool_choice")
    private AnthropicApi.ToolChoice toolChoice;
    @JsonProperty(value="thinking")
    private AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking;
    @JsonIgnore
    private List<CitationDocument> citationDocuments = new ArrayList<CitationDocument>();
    @JsonIgnore
    private AnthropicCacheOptions cacheOptions = AnthropicCacheOptions.DISABLED;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    @JsonProperty(value="output_format")
    private AnthropicApi.ChatCompletionRequest.OutputFormat outputFormat;
    @JsonIgnore
    private AnthropicApi.SkillContainer skillContainer;

    public AnthropicCacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    public void setCacheOptions(AnthropicCacheOptions cacheOptions) {
        this.cacheOptions = cacheOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AnthropicChatOptions fromOptions(AnthropicChatOptions fromOptions) {
        return AnthropicChatOptions.builder().model(fromOptions.getModel()).maxTokens(fromOptions.getMaxTokens()).metadata(fromOptions.getMetadata()).stopSequences((List<String>)(fromOptions.getStopSequences() != null ? new ArrayList<String>(fromOptions.getStopSequences()) : null)).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).topK(fromOptions.getTopK()).toolChoice(fromOptions.getToolChoice()).thinking(fromOptions.getThinking()).toolCallbacks((List<ToolCallback>)(fromOptions.getToolCallbacks() != null ? new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()) : null)).toolNames((Set<String>)(fromOptions.getToolNames() != null ? new HashSet<String>(fromOptions.getToolNames()) : null)).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext((Map<String, Object>)(fromOptions.getToolContext() != null ? new HashMap<String, Object>(fromOptions.getToolContext()) : null)).httpHeaders((Map<String, String>)(fromOptions.getHttpHeaders() != null ? new HashMap<String, String>(fromOptions.getHttpHeaders()) : null)).cacheOptions(fromOptions.getCacheOptions()).citationDocuments((List<CitationDocument>)(fromOptions.getCitationDocuments() != null ? new ArrayList<CitationDocument>(fromOptions.getCitationDocuments()) : null)).outputFormat(fromOptions.getOutputFormat()).skillContainer(fromOptions.getSkillContainer()).build();
    }

    public AnthropicApi.SkillContainer getSkillContainer() {
        return this.skillContainer;
    }

    public void setSkillContainer(AnthropicApi.SkillContainer skillContainer) {
        this.skillContainer = skillContainer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public AnthropicApi.ChatCompletionRequest.Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
        this.metadata = metadata;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public AnthropicApi.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(AnthropicApi.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public AnthropicApi.ChatCompletionRequest.ThinkingConfig getThinking() {
        return this.thinking;
    }

    public void setThinking(AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking) {
        this.thinking = thinking;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    @JsonIgnore
    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    @JsonIgnore
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public List<CitationDocument> getCitationDocuments() {
        return this.citationDocuments;
    }

    public void setCitationDocuments(List<CitationDocument> citationDocuments) {
        Assert.notNull(citationDocuments, (String)"Citation documents cannot be null");
        this.citationDocuments = citationDocuments;
    }

    public void validateCitationConsistency() {
        if (this.citationDocuments.isEmpty()) {
            return;
        }
        boolean hasEnabledCitations = this.citationDocuments.stream().anyMatch(CitationDocument::isCitationsEnabled);
        boolean hasDisabledCitations = this.citationDocuments.stream().anyMatch(doc -> !doc.isCitationsEnabled());
        if (hasEnabledCitations && hasDisabledCitations) {
            throw new IllegalArgumentException("Anthropic Citations API requires all documents to have consistent citation settings. Either enable citations for all documents or disable for all documents.");
        }
    }

    public AnthropicApi.ChatCompletionRequest.OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(AnthropicApi.ChatCompletionRequest.OutputFormat outputFormat) {
        Assert.notNull((Object)outputFormat, (String)"outputFormat cannot be null");
        this.outputFormat = outputFormat;
    }

    @JsonIgnore
    public String getOutputSchema() {
        return this.getOutputFormat() != null ? ModelOptionsUtils.toJsonString(this.getOutputFormat().schema()) : null;
    }

    @JsonIgnore
    public void setOutputSchema(String outputSchema) {
        this.setOutputFormat(new AnthropicApi.ChatCompletionRequest.OutputFormat(outputSchema));
    }

    public AnthropicChatOptions copy() {
        return AnthropicChatOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnthropicChatOptions)) {
            return false;
        }
        AnthropicChatOptions that = (AnthropicChatOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.toolChoice, that.toolChoice) && Objects.equals(this.thinking, that.thinking) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.httpHeaders, that.httpHeaders) && Objects.equals(this.cacheOptions, that.cacheOptions) && Objects.equals(this.outputFormat, that.outputFormat) && Objects.equals(this.citationDocuments, that.citationDocuments) && Objects.equals(this.skillContainer, that.skillContainer);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.maxTokens, this.metadata, this.stopSequences, this.temperature, this.topP, this.topK, this.toolChoice, this.thinking, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.toolContext, this.httpHeaders, this.cacheOptions, this.outputFormat, this.citationDocuments, this.skillContainer);
    }

    public static final class Builder {
        private final AnthropicChatOptions options = new AnthropicChatOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(AnthropicApi.ChatModel model) {
            this.options.model = model.getValue();
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder metadata(AnthropicApi.ChatCompletionRequest.Metadata metadata) {
            this.options.metadata = metadata;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public Builder toolChoice(AnthropicApi.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder thinking(AnthropicApi.ChatCompletionRequest.ThinkingConfig thinking) {
            this.options.thinking = thinking;
            return this;
        }

        public Builder thinking(AnthropicApi.ThinkingType type, Integer budgetTokens) {
            this.options.thinking = new AnthropicApi.ChatCompletionRequest.ThinkingConfig(type, budgetTokens);
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder httpHeaders(Map<String, String> httpHeaders) {
            this.options.setHttpHeaders(httpHeaders);
            return this;
        }

        public Builder cacheOptions(AnthropicCacheOptions cacheOptions) {
            this.options.setCacheOptions(cacheOptions);
            return this;
        }

        public Builder citationDocuments(List<CitationDocument> citationDocuments) {
            this.options.setCitationDocuments(citationDocuments);
            return this;
        }

        public Builder citationDocuments(CitationDocument ... documents) {
            Assert.notNull((Object)documents, (String)"Citation documents cannot be null");
            this.options.citationDocuments.addAll(Arrays.asList(documents));
            return this;
        }

        public Builder addCitationDocument(CitationDocument document) {
            Assert.notNull((Object)document, (String)"Citation document cannot be null");
            this.options.citationDocuments.add(document);
            return this;
        }

        public Builder outputFormat(AnthropicApi.ChatCompletionRequest.OutputFormat outputFormat) {
            this.options.outputFormat = outputFormat;
            return this;
        }

        public Builder outputSchema(String outputSchema) {
            this.options.setOutputSchema(outputSchema);
            return this;
        }

        public Builder skillContainer(AnthropicApi.SkillContainer skillContainer) {
            this.options.setSkillContainer(skillContainer);
            return this;
        }

        public Builder skill(AnthropicApi.Skill skill) {
            Assert.notNull((Object)skill, (String)"Skill cannot be null");
            if (this.options.skillContainer == null) {
                this.options.skillContainer = AnthropicApi.SkillContainer.builder().skill(skill).build();
            } else {
                ArrayList<AnthropicApi.Skill> existingSkills = new ArrayList<AnthropicApi.Skill>(this.options.skillContainer.skills());
                existingSkills.add(skill);
                this.options.skillContainer = new AnthropicApi.SkillContainer(existingSkills);
            }
            return this;
        }

        public Builder anthropicSkill(AnthropicApi.AnthropicSkill anthropicSkill) {
            Assert.notNull((Object)((Object)anthropicSkill), (String)"AnthropicSkill cannot be null");
            return this.skill(anthropicSkill.toSkill());
        }

        public Builder anthropicSkill(AnthropicApi.AnthropicSkill anthropicSkill, String version) {
            Assert.notNull((Object)((Object)anthropicSkill), (String)"AnthropicSkill cannot be null");
            Assert.hasText((String)version, (String)"Version cannot be empty");
            return this.skill(anthropicSkill.toSkill(version));
        }

        public Builder customSkill(String skillId) {
            Assert.hasText((String)skillId, (String)"Skill ID cannot be empty");
            return this.skill(new AnthropicApi.Skill(AnthropicApi.SkillType.CUSTOM, skillId));
        }

        public Builder customSkill(String skillId, String version) {
            Assert.hasText((String)skillId, (String)"Skill ID cannot be empty");
            Assert.hasText((String)version, (String)"Version cannot be empty");
            return this.skill(new AnthropicApi.Skill(AnthropicApi.SkillType.CUSTOM, skillId, version));
        }

        public AnthropicChatOptions build() {
            this.options.validateCitationConsistency();
            return this.options;
        }
    }
}

