/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.api.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheBreakpointTracker {
    private static final Logger logger = LoggerFactory.getLogger(CacheBreakpointTracker.class);
    private int count = 0;
    private boolean hasWarned = false;

    CacheBreakpointTracker() {
    }

    public boolean canUse() {
        return this.count < 4;
    }

    public boolean allBreakpointsAreUsed() {
        return !this.canUse();
    }

    public void use() {
        if (this.count < 4) {
            ++this.count;
        } else if (!this.hasWarned) {
            logger.warn("Anthropic cache breakpoint limit (4) reached. Additional cache_control directives will be ignored. Consider using fewer cache strategies or simpler content structure.");
            this.hasWarned = true;
        }
    }

    public int getCount() {
        return this.count;
    }
}

