/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.AnthropicChatOptions;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.anthropic.api.AnthropicCacheStrategy;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Content;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.model.tool.internal.ToolCallReactiveContextHolder;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class AnthropicChatModel
implements ChatModel {
    public static final String DEFAULT_MODEL_NAME = AnthropicApi.ChatModel.CLAUDE_3_7_SONNET.getValue();
    public static final Integer DEFAULT_MAX_TOKENS = 500;
    public static final Double DEFAULT_TEMPERATURE = 0.8;
    private static final Logger logger = LoggerFactory.getLogger(AnthropicChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    public final RetryTemplate retryTemplate;
    private final AnthropicApi anthropicApi;
    private final AnthropicChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(anthropicApi, defaultOptions, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)anthropicApi, (String)"anthropicApi cannot be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.anthropicApi = anthropicApi;
        this.defaultOptions = defaultOptions;
        this.toolCallingManager = toolCallingManager;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.anthropicApi.chatCompletionEntity(request, this.getAdditionalHttpHeaders(prompt)));
            AnthropicApi.ChatCompletionResponse completionResponse = (AnthropicApi.ChatCompletionResponse)completionEntity.getBody();
            AnthropicApi.Usage usage = completionResponse.usage();
            EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(completionResponse.usage()) : new EmptyUsage();
            Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)completionEntity.getBody(), accumulatedUsage);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    private DefaultUsage getDefaultUsage(AnthropicApi.Usage usage) {
        return new DefaultUsage(usage.inputTokens(), usage.outputTokens(), Integer.valueOf(usage.inputTokens() + usage.outputTokens()), (Object)usage);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux<AnthropicApi.ChatCompletionResponse> response = this.anthropicApi.chatCompletionStream(request, this.getAdditionalHttpHeaders(prompt));
            Flux chatResponseFlux = response.flatMap(chatCompletionResponse -> {
                AnthropicApi.Usage usage = chatCompletionResponse.usage();
                EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(chatCompletionResponse.usage()) : new EmptyUsage();
                Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
                ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)chatCompletionResponse, accumulatedUsage);
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), chatResponse)) {
                    if (chatResponse.hasFinishReasons(Set.of("tool_use"))) {
                        return Flux.deferContextual(ctx -> {
                            ToolExecutionResult toolExecutionResult;
                            try {
                                ToolCallReactiveContextHolder.setContext((ContextView)ctx);
                                toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, chatResponse);
                            }
                            finally {
                                ToolCallReactiveContextHolder.clearContext();
                            }
                            if (toolExecutionResult.returnDirect()) {
                                return Flux.just((Object)ChatResponse.builder().from(chatResponse).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                            }
                            return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), chatResponse);
                        }).subscribeOn(Schedulers.boundedElastic());
                    }
                    return Mono.empty();
                }
                return Mono.just((Object)chatResponse);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponse toChatResponse(AnthropicApi.ChatCompletionResponse chatCompletion, Usage usage) {
        if (chatCompletion == null) {
            logger.warn("Null chat completion returned");
            return new ChatResponse(List.of());
        }
        ArrayList<Generation> generations = new ArrayList<Generation>();
        ArrayList<AssistantMessage.ToolCall> toolCalls = new ArrayList<AssistantMessage.ToolCall>();
        for (AnthropicApi.ContentBlock content : chatCompletion.content()) {
            switch (content.type()) {
                case TEXT: 
                case TEXT_DELTA: {
                    generations.add(new Generation(new AssistantMessage(content.text(), Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build()));
                    break;
                }
                case THINKING: 
                case THINKING_DELTA: {
                    HashMap<String, String> thinkingProperties = new HashMap<String, String>();
                    thinkingProperties.put("signature", content.signature());
                    generations.add(new Generation(new AssistantMessage(content.thinking(), thinkingProperties), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build()));
                    break;
                }
                case REDACTED_THINKING: {
                    HashMap<String, String> redactedProperties = new HashMap<String, String>();
                    redactedProperties.put("data", content.data());
                    generations.add(new Generation(new AssistantMessage(null, redactedProperties), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build()));
                    break;
                }
                case TOOL_USE: {
                    String functionCallId = content.id();
                    String functionName = content.name();
                    String functionArguments = JsonParser.toJson(content.input());
                    toolCalls.add(new AssistantMessage.ToolCall(functionCallId, "function", functionName, functionArguments));
                }
            }
        }
        if (chatCompletion.stopReason() != null && generations.isEmpty()) {
            Generation generation = new Generation(new AssistantMessage(null, Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            generations.add(generation);
        }
        if (!CollectionUtils.isEmpty(toolCalls)) {
            AssistantMessage assistantMessage = new AssistantMessage("", Map.of(), toolCalls);
            Generation toolCallGeneration = new Generation(assistantMessage, ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            generations.add(toolCallGeneration);
        }
        return new ChatResponse(generations, this.from(chatCompletion, usage));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result) {
        return this.from(result, (Usage)this.getDefaultUsage(result.usage()));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result, Usage usage) {
        Assert.notNull((Object)result, (String)"Anthropic ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id()).model(result.model()).usage(usage).keyValue("stop-reason", (Object)result.stopReason()).keyValue("stop-sequence", (Object)result.stopSequence()).keyValue("type", (Object)result.type()).build();
    }

    private AnthropicApi.ContentBlock.Source getSourceByMedia(Media media) {
        String data = this.fromMediaData(media.getData());
        if (data.startsWith("https://")) {
            return new AnthropicApi.ContentBlock.Source(data);
        }
        return new AnthropicApi.ContentBlock.Source(media.getMimeType().toString(), data);
    }

    private String fromMediaData(Object mediaData) {
        if (mediaData instanceof byte[]) {
            byte[] bytes = (byte[])mediaData;
            return Base64.getEncoder().encodeToString(bytes);
        }
        if (mediaData instanceof String) {
            String text = (String)mediaData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaData.getClass().getSimpleName());
    }

    private AnthropicApi.ContentBlock.Type getContentBlockTypeByMedia(Media media) {
        String mimeType = media.getMimeType().toString();
        if (mimeType.startsWith("image")) {
            return AnthropicApi.ContentBlock.Type.IMAGE;
        }
        if (mimeType.contains("pdf")) {
            return AnthropicApi.ContentBlock.Type.DOCUMENT;
        }
        throw new IllegalArgumentException("Unsupported media type: " + mimeType + ". Supported types are: images (image/*) and PDF documents (application/pdf)");
    }

    private MultiValueMap<String, String> getAdditionalHttpHeaders(Prompt prompt) {
        ChatOptions chatOptions;
        HashMap<String, String> headers = new HashMap<String, String>(this.defaultOptions.getHttpHeaders());
        if (prompt.getOptions() != null && (chatOptions = prompt.getOptions()) instanceof AnthropicChatOptions) {
            AnthropicChatOptions chatOptions2 = (AnthropicChatOptions)chatOptions;
            headers.putAll(chatOptions2.getHttpHeaders());
        }
        return CollectionUtils.toMultiValueMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.of((String)e.getValue()))));
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        AnthropicChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, AnthropicChatOptions.class);
            } else {
                runtimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AnthropicChatOptions.class);
            }
        }
        AnthropicChatOptions requestOptions = (AnthropicChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, AnthropicChatOptions.class);
        if (runtimeOptions != null) {
            if (runtimeOptions.getFrequencyPenalty() != null) {
                logger.warn("The frequencyPenalty option is not supported by Anthropic API. Ignoring.");
            }
            if (runtimeOptions.getPresencePenalty() != null) {
                logger.warn("The presencePenalty option is not supported by Anthropic API. Ignoring.");
            }
            requestOptions.setHttpHeaders(this.mergeHttpHeaders(runtimeOptions.getHttpHeaders(), this.defaultOptions.getHttpHeaders()));
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
            requestOptions.setCacheStrategy(runtimeOptions.getCacheStrategy() != null ? runtimeOptions.getCacheStrategy() : this.defaultOptions.getCacheStrategy());
            requestOptions.setCacheTtl(runtimeOptions.getCacheTtl() != null ? runtimeOptions.getCacheTtl() : this.defaultOptions.getCacheTtl());
        } else {
            requestOptions.setHttpHeaders(this.defaultOptions.getHttpHeaders());
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    private Map<String, String> mergeHttpHeaders(Map<String, String> runtimeHttpHeaders, Map<String, String> defaultHttpHeaders) {
        HashMap<String, String> mergedHttpHeaders = new HashMap<String, String>(defaultHttpHeaders);
        mergedHttpHeaders.putAll(runtimeHttpHeaders);
        return mergedHttpHeaders;
    }

    AnthropicApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        logger.debug("DEBUGINFO: prompt.getOptions() type: {}, value: {}", (Object)(prompt.getOptions() != null ? prompt.getOptions().getClass().getName() : "null"), (Object)prompt.getOptions());
        AnthropicChatOptions requestOptions = null;
        if (prompt.getOptions() instanceof AnthropicChatOptions) {
            requestOptions = (AnthropicChatOptions)prompt.getOptions();
            logger.debug("DEBUGINFO: Found AnthropicChatOptions - cacheStrategy: {}, cacheTtl: {}", (Object)requestOptions.getCacheStrategy(), (Object)requestOptions.getCacheTtl());
        } else {
            logger.debug("DEBUGINFO: Options is NOT AnthropicChatOptions, it's: {}", (Object)(prompt.getOptions() != null ? prompt.getOptions().getClass().getName() : "null"));
        }
        AnthropicCacheStrategy strategy = requestOptions != null ? requestOptions.getCacheStrategy() : AnthropicCacheStrategy.NONE;
        String cacheTtl = requestOptions != null ? requestOptions.getCacheTtl() : "5m";
        logger.debug("Cache strategy: {}, TTL: {}", (Object)strategy, (Object)cacheTtl);
        CacheBreakpointTracker breakpointsUsed = new CacheBreakpointTracker();
        AnthropicApi.ChatCompletionRequest.CacheControl cacheControl = null;
        if (strategy != AnthropicCacheStrategy.NONE) {
            if (cacheTtl != null && !cacheTtl.equals("5m")) {
                cacheControl = new AnthropicApi.ChatCompletionRequest.CacheControl("ephemeral", cacheTtl);
                logger.debug("Created cache control with TTL: type={}, ttl={}", (Object)"ephemeral", (Object)cacheTtl);
            } else {
                cacheControl = new AnthropicApi.ChatCompletionRequest.CacheControl("ephemeral");
                logger.debug("Created cache control with default TTL: type={}, ttl={}", (Object)"ephemeral", (Object)"5m");
            }
        }
        List<AnthropicApi.AnthropicMessage> userMessages = this.buildMessages(prompt, strategy, cacheControl, breakpointsUsed);
        Object systemContent = this.buildSystemContent(prompt, strategy, cacheControl, breakpointsUsed);
        AnthropicApi.ChatCompletionRequest request = new AnthropicApi.ChatCompletionRequest(this.defaultOptions.getModel(), userMessages, systemContent, this.defaultOptions.getMaxTokens(), this.defaultOptions.getTemperature(), stream);
        request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)requestOptions, (Object)request, AnthropicApi.ChatCompletionRequest.class);
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, AnthropicApi.ChatCompletionRequest.class);
            List<AnthropicApi.Tool> tools = this.getFunctionTools(toolDefinitions);
            if ((strategy == AnthropicCacheStrategy.SYSTEM_AND_TOOLS || strategy == AnthropicCacheStrategy.CONVERSATION_HISTORY) && breakpointsUsed.canUse()) {
                tools = this.addCacheToLastTool(tools, cacheControl, breakpointsUsed);
            }
            request = AnthropicApi.ChatCompletionRequest.from(request).tools(tools).build();
        }
        if ("1h".equals(cacheTtl) && requestOptions != null) {
            HashMap<String, String> headers = new HashMap<String, String>(requestOptions.getHttpHeaders());
            headers.put("anthropic-beta", "extended-cache-ttl-2025-04-11");
            requestOptions.setHttpHeaders(headers);
        }
        return request;
    }

    private List<AnthropicApi.Tool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            String name = toolDefinition.name();
            String description = toolDefinition.description();
            String inputSchema = toolDefinition.inputSchema();
            return new AnthropicApi.Tool(name, description, (Map)JsonParser.fromJson((String)inputSchema, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }).toList();
    }

    private List<AnthropicApi.AnthropicMessage> buildMessages(Prompt prompt, AnthropicCacheStrategy strategy, AnthropicApi.ChatCompletionRequest.CacheControl cacheControl, CacheBreakpointTracker breakpointsUsed) {
        List<Message> allMessages = prompt.getInstructions().stream().filter(message -> message.getMessageType() != MessageType.SYSTEM).toList();
        int lastUserIndex = -1;
        if (strategy == AnthropicCacheStrategy.CONVERSATION_HISTORY) {
            for (int i = allMessages.size() - 1; i >= 0; --i) {
                if (allMessages.get(i).getMessageType() != MessageType.USER) continue;
                lastUserIndex = i;
                break;
            }
        }
        ArrayList<AnthropicApi.AnthropicMessage> result = new ArrayList<AnthropicApi.AnthropicMessage>();
        for (int i = 0; i < allMessages.size(); ++i) {
            Message message2 = allMessages.get(i);
            boolean shouldApplyCache = false;
            if (strategy == AnthropicCacheStrategy.CONVERSATION_HISTORY && breakpointsUsed.canUse()) {
                if (lastUserIndex > 0) {
                    boolean bl = shouldApplyCache = i == lastUserIndex - 1;
                }
                if (shouldApplyCache) {
                    breakpointsUsed.use();
                }
            }
            if (message2.getMessageType() == MessageType.USER) {
                UserMessage userMessage;
                ArrayList<AnthropicApi.ContentBlock> contents = new ArrayList<AnthropicApi.ContentBlock>();
                if (shouldApplyCache && cacheControl != null) {
                    contents.add(new AnthropicApi.ContentBlock(message2.getText(), cacheControl));
                } else {
                    contents.add(new AnthropicApi.ContentBlock(message2.getText()));
                }
                if (message2 instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message2).getMedia())) {
                    List<AnthropicApi.ContentBlock> mediaContent = userMessage.getMedia().stream().map(media -> {
                        AnthropicApi.ContentBlock.Type contentBlockType = this.getContentBlockTypeByMedia((Media)media);
                        AnthropicApi.ContentBlock.Source source = this.getSourceByMedia((Media)media);
                        return new AnthropicApi.ContentBlock(contentBlockType, source);
                    }).toList();
                    contents.addAll(mediaContent);
                }
                result.add(new AnthropicApi.AnthropicMessage(contents, AnthropicApi.Role.valueOf(message2.getMessageType().name())));
                continue;
            }
            if (message2.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message2;
                ArrayList<AnthropicApi.ContentBlock> contentBlocks = new ArrayList<AnthropicApi.ContentBlock>();
                if (StringUtils.hasText((String)message2.getText())) {
                    contentBlocks.add(new AnthropicApi.ContentBlock(message2.getText()));
                }
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                        contentBlocks.add(new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_USE, toolCall.id(), toolCall.name(), ModelOptionsUtils.jsonToMap((String)toolCall.arguments())));
                    }
                }
                result.add(new AnthropicApi.AnthropicMessage(contentBlocks, AnthropicApi.Role.ASSISTANT));
                continue;
            }
            if (message2.getMessageType() == MessageType.TOOL) {
                List<AnthropicApi.ContentBlock> toolResponses = ((ToolResponseMessage)message2).getResponses().stream().map(toolResponse -> new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_RESULT, toolResponse.id(), toolResponse.responseData())).toList();
                result.add(new AnthropicApi.AnthropicMessage(toolResponses, AnthropicApi.Role.USER));
                continue;
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message2.getMessageType()));
        }
        return result;
    }

    private Object buildSystemContent(Prompt prompt, AnthropicCacheStrategy strategy, AnthropicApi.ChatCompletionRequest.CacheControl cacheControl, CacheBreakpointTracker breakpointsUsed) {
        String systemText = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(Content::getText).collect(Collectors.joining(System.lineSeparator()));
        if (!StringUtils.hasText((String)systemText)) {
            return null;
        }
        if ((strategy == AnthropicCacheStrategy.SYSTEM_ONLY || strategy == AnthropicCacheStrategy.SYSTEM_AND_TOOLS || strategy == AnthropicCacheStrategy.CONVERSATION_HISTORY) && breakpointsUsed.canUse() && cacheControl != null) {
            logger.debug("Applying cache control to system message - strategy: {}, cacheControl: {}", (Object)strategy, (Object)cacheControl);
            List<AnthropicApi.ContentBlock> systemBlocks = List.of(new AnthropicApi.ContentBlock(systemText, cacheControl));
            breakpointsUsed.use();
            return systemBlocks;
        }
        return systemText;
    }

    private List<AnthropicApi.Tool> addCacheToLastTool(List<AnthropicApi.Tool> tools, AnthropicApi.ChatCompletionRequest.CacheControl cacheControl, CacheBreakpointTracker breakpointsUsed) {
        if (tools == null || tools.isEmpty() || !breakpointsUsed.canUse() || cacheControl == null) {
            return tools;
        }
        ArrayList<AnthropicApi.Tool> modifiedTools = new ArrayList<AnthropicApi.Tool>();
        for (int i = 0; i < tools.size(); ++i) {
            AnthropicApi.Tool tool = tools.get(i);
            if (i == tools.size() - 1) {
                tool = new AnthropicApi.Tool(tool.name(), tool.description(), tool.inputSchema(), cacheControl);
                breakpointsUsed.use();
            }
            modifiedTools.add(tool);
        }
        return modifiedTools;
    }

    public ChatOptions getDefaultOptions() {
        return AnthropicChatOptions.fromOptions(this.defaultOptions);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    private class CacheBreakpointTracker {
        private int count = 0;
        private boolean hasWarned = false;

        private CacheBreakpointTracker() {
        }

        public boolean canUse() {
            return this.count < 4;
        }

        public void use() {
            if (this.count < 4) {
                ++this.count;
            } else if (!this.hasWarned) {
                logger.warn("Anthropic cache breakpoint limit (4) reached. Additional cache_control directives will be ignored. Consider using fewer cache strategies or simpler content structure.");
                this.hasWarned = true;
            }
        }

        public int getCount() {
            return this.count;
        }
    }

    public static final class Builder {
        private AnthropicApi anthropicApi;
        private AnthropicChatOptions defaultOptions = AnthropicChatOptions.builder().model(DEFAULT_MODEL_NAME).maxTokens(DEFAULT_MAX_TOKENS).temperature(DEFAULT_TEMPERATURE).build();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ToolCallingManager toolCallingManager;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();

        private Builder() {
        }

        public Builder anthropicApi(AnthropicApi anthropicApi) {
            this.anthropicApi = anthropicApi;
            return this;
        }

        public Builder defaultOptions(AnthropicChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public AnthropicChatModel build() {
            if (this.toolCallingManager != null) {
                return new AnthropicChatModel(this.anthropicApi, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new AnthropicChatModel(this.anthropicApi, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }
}

