/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.AnthropicChatOptions;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.metadata.UsageUtils;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.model.tool.LegacyToolCallingManager;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnthropicChatModel
extends AbstractToolCallSupport
implements ChatModel {
    public static final String DEFAULT_MODEL_NAME = AnthropicApi.ChatModel.CLAUDE_3_5_SONNET.getValue();
    public static final Integer DEFAULT_MAX_TOKENS = 500;
    public static final Double DEFAULT_TEMPERATURE = 0.8;
    private static final Logger logger = LoggerFactory.getLogger(AnthropicChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    public final RetryTemplate retryTemplate;
    private final AnthropicApi anthropicApi;
    private final AnthropicChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi) {
        this(anthropicApi, AnthropicChatOptions.builder().model(DEFAULT_MODEL_NAME).maxTokens(DEFAULT_MAX_TOKENS).temperature(DEFAULT_TEMPERATURE).build());
    }

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions) {
        this(anthropicApi, defaultOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate) {
        this(anthropicApi, defaultOptions, retryTemplate, null);
    }

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, FunctionCallbackResolver functionCallbackResolver) {
        this(anthropicApi, defaultOptions, retryTemplate, functionCallbackResolver, List.of());
    }

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks) {
        this(anthropicApi, defaultOptions, retryTemplate, functionCallbackResolver, toolFunctionCallbacks, ObservationRegistry.NOOP);
    }

    @Deprecated
    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, RetryTemplate retryTemplate, @Nullable FunctionCallbackResolver functionCallbackResolver, @Nullable List<FunctionCallback> toolFunctionCallbacks, ObservationRegistry observationRegistry) {
        this(anthropicApi, defaultOptions, (ToolCallingManager)LegacyToolCallingManager.builder().functionCallbackResolver(functionCallbackResolver).functionCallbacks(toolFunctionCallbacks).build(), retryTemplate, observationRegistry);
        logger.warn("This constructor is deprecated and will be removed in the next milestone. Please use the MistralAiChatModel.Builder or the new constructor accepting ToolCallingManager instead.");
    }

    public AnthropicChatModel(AnthropicApi anthropicApi, AnthropicChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(null, (FunctionCallingOptions)AnthropicChatOptions.builder().build(), List.of());
        Assert.notNull((Object)anthropicApi, (String)"anthropicApi cannot be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        this.anthropicApi = anthropicApi;
        this.defaultOptions = defaultOptions;
        this.toolCallingManager = toolCallingManager;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).requestOptions(prompt.getOptions()).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.anthropicApi.chatCompletionEntity(request));
            AnthropicApi.ChatCompletionResponse completionResponse = (AnthropicApi.ChatCompletionResponse)completionEntity.getBody();
            AnthropicApi.Usage usage = completionResponse.usage();
            EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(completionResponse.usage()) : new EmptyUsage();
            Usage accumulatedUsage = UsageUtils.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)completionEntity.getBody(), accumulatedUsage);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (ToolCallingChatOptions.isInternalToolExecutionEnabled((ChatOptions)prompt.getOptions()) && response != null && response.hasToolCalls()) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    private DefaultUsage getDefaultUsage(AnthropicApi.Usage usage) {
        return new DefaultUsage(usage.inputTokens(), usage.outputTokens(), Integer.valueOf(usage.inputTokens() + usage.outputTokens()), (Object)usage);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            AnthropicApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AnthropicApi.PROVIDER_NAME).requestOptions(prompt.getOptions()).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux<AnthropicApi.ChatCompletionResponse> response = this.anthropicApi.chatCompletionStream(request);
            Flux chatResponseFlux = response.switchMap(chatCompletionResponse -> {
                AnthropicApi.Usage usage = chatCompletionResponse.usage();
                EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(chatCompletionResponse.usage()) : new EmptyUsage();
                Usage accumulatedUsage = UsageUtils.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
                ChatResponse chatResponse = this.toChatResponse((AnthropicApi.ChatCompletionResponse)chatCompletionResponse, accumulatedUsage);
                if (ToolCallingChatOptions.isInternalToolExecutionEnabled((ChatOptions)prompt.getOptions()) && chatResponse.hasToolCalls() && chatResponse.hasFinishReasons(Set.of("tool_use"))) {
                    ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, chatResponse);
                    if (toolExecutionResult.returnDirect()) {
                        return Flux.just((Object)ChatResponse.builder().from(chatResponse).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                    }
                    return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), chatResponse);
                }
                return Mono.just((Object)chatResponse);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponse toChatResponse(AnthropicApi.ChatCompletionResponse chatCompletion, Usage usage) {
        List<AnthropicApi.ContentBlock> toolToUseList;
        if (chatCompletion == null) {
            logger.warn("Null chat completion returned");
            return new ChatResponse(List.of());
        }
        List<Generation> generations = chatCompletion.content().stream().filter(content -> content.type() != AnthropicApi.ContentBlock.Type.TOOL_USE).map(content -> new Generation(new AssistantMessage(content.text(), Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build())).toList();
        ArrayList<Generation> allGenerations = new ArrayList<Generation>(generations);
        if (chatCompletion.stopReason() != null && generations.isEmpty()) {
            Generation generation = new Generation(new AssistantMessage(null, Map.of()), ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            allGenerations.add(generation);
        }
        if (!CollectionUtils.isEmpty(toolToUseList = chatCompletion.content().stream().filter(c -> c.type() == AnthropicApi.ContentBlock.Type.TOOL_USE).toList())) {
            ArrayList<AssistantMessage.ToolCall> toolCalls = new ArrayList<AssistantMessage.ToolCall>();
            for (AnthropicApi.ContentBlock toolToUse : toolToUseList) {
                String functionCallId = toolToUse.id();
                String functionName = toolToUse.name();
                String functionArguments = JsonParser.toJson(toolToUse.input());
                toolCalls.add(new AssistantMessage.ToolCall(functionCallId, "function", functionName, functionArguments));
            }
            AssistantMessage assistantMessage = new AssistantMessage("", Map.of(), toolCalls);
            Generation toolCallGeneration = new Generation(assistantMessage, ChatGenerationMetadata.builder().finishReason(chatCompletion.stopReason()).build());
            allGenerations.add(toolCallGeneration);
        }
        return new ChatResponse(allGenerations, this.from(chatCompletion, usage));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result) {
        return this.from(result, (Usage)this.getDefaultUsage(result.usage()));
    }

    private ChatResponseMetadata from(AnthropicApi.ChatCompletionResponse result, Usage usage) {
        Assert.notNull((Object)result, (String)"Anthropic ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id()).model(result.model()).usage(usage).keyValue("stop-reason", (Object)result.stopReason()).keyValue("stop-sequence", (Object)result.stopSequence()).keyValue("type", (Object)result.type()).build();
    }

    private String fromMediaData(Object mediaData) {
        if (mediaData instanceof byte[]) {
            byte[] bytes = (byte[])mediaData;
            return Base64.getEncoder().encodeToString(bytes);
        }
        if (mediaData instanceof String) {
            String text = (String)mediaData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaData.getClass().getSimpleName());
    }

    private AnthropicApi.ContentBlock.Type getContentBlockTypeByMedia(Media media) {
        String mimeType = media.getMimeType().toString();
        if (mimeType.startsWith("image")) {
            return AnthropicApi.ContentBlock.Type.IMAGE;
        }
        if (mimeType.contains("pdf")) {
            return AnthropicApi.ContentBlock.Type.DOCUMENT;
        }
        throw new IllegalArgumentException("Unsupported media type: " + mimeType + ". Supported types are: images (image/*) and PDF documents (application/pdf)");
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        AnthropicChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, AnthropicChatOptions.class);
            } else {
                chatOptions = prompt.getOptions();
                if (chatOptions instanceof FunctionCallingOptions) {
                    FunctionCallingOptions functionCallingOptions = (FunctionCallingOptions)chatOptions;
                    runtimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)functionCallingOptions, FunctionCallingOptions.class, AnthropicChatOptions.class);
                } else {
                    runtimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AnthropicChatOptions.class);
                }
            }
        }
        AnthropicChatOptions requestOptions = (AnthropicChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, AnthropicChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.isInternalToolExecutionEnabled(), (Object)this.defaultOptions.isInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.isInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    AnthropicApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<AnthropicApi.AnthropicMessage> userMessages = prompt.getInstructions().stream().filter(message -> message.getMessageType() != MessageType.SYSTEM).map(message -> {
            if (message.getMessageType() == MessageType.USER) {
                UserMessage userMessage;
                ArrayList<AnthropicApi.ContentBlock> contents = new ArrayList<AnthropicApi.ContentBlock>(List.of(new AnthropicApi.ContentBlock(message.getText())));
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    List<AnthropicApi.ContentBlock> mediaContent = userMessage.getMedia().stream().map(media -> {
                        AnthropicApi.ContentBlock.Type contentBlockType = this.getContentBlockTypeByMedia((Media)media);
                        AnthropicApi.ContentBlock.Source source = new AnthropicApi.ContentBlock.Source(media.getMimeType().toString(), this.fromMediaData(media.getData()));
                        return new AnthropicApi.ContentBlock(contentBlockType, source);
                    }).toList();
                    contents.addAll(mediaContent);
                }
                return new AnthropicApi.AnthropicMessage(contents, AnthropicApi.Role.valueOf(message.getMessageType().name()));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                ArrayList<AnthropicApi.ContentBlock> contentBlocks = new ArrayList<AnthropicApi.ContentBlock>();
                if (StringUtils.hasText((String)message.getText())) {
                    contentBlocks.add(new AnthropicApi.ContentBlock(message.getText()));
                }
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                        contentBlocks.add(new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_USE, toolCall.id(), toolCall.name(), ModelOptionsUtils.jsonToMap((String)toolCall.arguments())));
                    }
                }
                return new AnthropicApi.AnthropicMessage(contentBlocks, AnthropicApi.Role.ASSISTANT);
            }
            if (message.getMessageType() == MessageType.TOOL) {
                List<AnthropicApi.ContentBlock> toolResponses = ((ToolResponseMessage)message).getResponses().stream().map(toolResponse -> new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_RESULT, toolResponse.id(), toolResponse.responseData())).toList();
                return new AnthropicApi.AnthropicMessage(toolResponses, AnthropicApi.Role.USER);
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).toList();
        String systemPrompt = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(m -> m.getText()).collect(Collectors.joining(System.lineSeparator()));
        AnthropicApi.ChatCompletionRequest request = new AnthropicApi.ChatCompletionRequest(this.defaultOptions.getModel(), userMessages, systemPrompt, this.defaultOptions.getMaxTokens(), this.defaultOptions.getTemperature(), stream);
        AnthropicChatOptions requestOptions = (AnthropicChatOptions)prompt.getOptions();
        request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)requestOptions, (Object)request, AnthropicApi.ChatCompletionRequest.class);
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            request = (AnthropicApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, AnthropicApi.ChatCompletionRequest.class);
            request = AnthropicApi.ChatCompletionRequest.from(request).withTools(this.getFunctionTools(toolDefinitions)).build();
        }
        return request;
    }

    private List<AnthropicApi.Tool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            String name = toolDefinition.name();
            String description = toolDefinition.description();
            String inputSchema = toolDefinition.inputSchema();
            return new AnthropicApi.Tool(name, description, (Map)JsonParser.fromJson((String)inputSchema, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }).toList();
    }

    public ChatOptions getDefaultOptions() {
        return AnthropicChatOptions.fromOptions(this.defaultOptions);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AnthropicApi anthropicApi;
        private AnthropicChatOptions defaultOptions = AnthropicChatOptions.builder().model(DEFAULT_MODEL_NAME).maxTokens(DEFAULT_MAX_TOKENS).temperature(DEFAULT_TEMPERATURE).build();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private FunctionCallbackResolver functionCallbackResolver;
        private List<FunctionCallback> toolCallbacks;
        private ToolCallingManager toolCallingManager;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder anthropicApi(AnthropicApi anthropicApi) {
            this.anthropicApi = anthropicApi;
            return this;
        }

        public Builder defaultOptions(AnthropicChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        @Deprecated
        public Builder functionCallbackResolver(FunctionCallbackResolver functionCallbackResolver) {
            this.functionCallbackResolver = functionCallbackResolver;
            return this;
        }

        @Deprecated
        public Builder toolCallbacks(List<FunctionCallback> toolCallbacks) {
            this.toolCallbacks = toolCallbacks;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public AnthropicChatModel build() {
            if (this.toolCallingManager != null) {
                Assert.isNull((Object)this.functionCallbackResolver, (String)"functionCallbackResolver cannot be set when toolCallingManager is set");
                Assert.isNull(this.toolCallbacks, (String)"toolCallbacks cannot be set when toolCallingManager is set");
                return new AnthropicChatModel(this.anthropicApi, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry);
            }
            if (this.functionCallbackResolver != null) {
                Assert.isNull((Object)this.toolCallingManager, (String)"toolCallingManager cannot be set when functionCallbackResolver is set");
                List<FunctionCallback> toolCallbacks = this.toolCallbacks != null ? this.toolCallbacks : List.of();
                return new AnthropicChatModel(this.anthropicApi, this.defaultOptions, this.retryTemplate, this.functionCallbackResolver, toolCallbacks, this.observationRegistry);
            }
            return new AnthropicChatModel(this.anthropicApi, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry);
        }
    }
}

