/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.RepositoryRestResourceProvider;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.webmvc.api.RouterFunctionProvider;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiResource
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider;
    private final Optional<RouterFunctionProvider> routerFunctionProvider;
    private final Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider;

    public OpenApiResource(String groupName, ObjectFactory<OpenAPIBuilder> openAPIBuilderObjectFactory, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> actuatorProvider, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
        this.repositoryRestResourceProvider = repositoryRestResourceProvider;
    }

    @Autowired
    public OpenApiResource(ObjectFactory<OpenAPIBuilder> openAPIBuilderObjectFactory, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> actuatorProvider, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
        this.repositoryRestResourceProvider = repositoryRestResourceProvider;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        if (!this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter()) {
            return Json.mapper().writeValueAsString((Object)openAPI);
        }
        return Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        if (!this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter()) {
            return this.getYamlMapper().writeValueAsString((Object)openAPI);
        }
        return this.getYamlMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map);
        if (this.actuatorProvider.isPresent()) {
            map = ((ActuatorProvider)this.actuatorProvider.get()).getMethods();
            this.openAPIBuilder.addTag(new HashSet(map.values()), ((ActuatorProvider)this.actuatorProvider.get()).getTag());
            this.calculatePath(restControllers, map);
        }
        if (this.springSecurityOAuth2Provider.isPresent()) {
            SecurityOAuth2Provider securityOAuth2Provider = this.springSecurityOAuth2Provider.get();
            Map mapOauth = securityOAuth2Provider.getHandlerMethods();
            Map requestMappingMapSec = securityOAuth2Provider.getFrameworkEndpoints();
            Class[] additionalRestClasses = (Class[])requestMappingMapSec.values().stream().map(Object::getClass).toArray(Class[]::new);
            AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
            this.calculatePath(requestMappingMapSec, mapOauth);
        }
        this.routerFunctionProvider.ifPresent(routerFunctions -> routerFunctions.getWebMvcRouterFunctionPaths().ifPresent(routerBeans -> routerBeans.forEach((arg_0, arg_1) -> ((OpenApiResource)this).getRouterFunctionPaths(arg_0, arg_1))));
        if (this.repositoryRestResourceProvider.isPresent()) {
            RepositoryRestResourceProvider restResourceProvider = this.repositoryRestResourceProvider.get();
            List operationList = restResourceProvider.getRouterOperations(this.openAPIBuilder.getCalculatedOpenAPI());
            this.calculatePath(operationList);
        }
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = entry.getKey();
            HandlerMethod handlerMethod = entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            LinkedHashMap regexMap = new LinkedHashMap();
            for (String pattern : patterns) {
                String operationPath = PathUtils.parsePath((String)pattern, regexMap);
                if ((!this.actuatorProvider.isPresent() || !((ActuatorProvider)this.actuatorProvider.get()).isRestController(operationPath, handlerMethod.getBeanType())) && !this.isRestController(restControllers, handlerMethod, operationPath) || !this.isPackageToScan(handlerMethod.getBeanType().getPackage()) || !this.isPathToMatch(operationPath)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                if (requestMethods.isEmpty()) {
                    requestMethods = this.getDefaultAllowedHttpMethods();
                }
                this.calculatePath(handlerMethod, operationPath, requestMethods);
            }
        }
    }

    protected boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        ResponseBody responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), ResponseBody.class);
        if (responseBodyAnnotation == null) {
            responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), ResponseBody.class);
        }
        return (responseBodyAnnotation != null && restControllers.containsKey(handlerMethod.getBean().toString()) || this.isAdditionalRestController(handlerMethod.getBeanType())) && operationPath.startsWith("/") && (this.springDocConfigProperties.isModelAndViewAllowed() || !ModelAndView.class.isAssignableFrom(handlerMethod.getMethod().getReturnType()));
    }

    protected void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        super.initOpenAPIBuilder();
        String requestUrl = this.decode(request.getRequestURL().toString());
        String calculatedUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.openAPIBuilder.setServerBaseUrl(calculatedUrl);
    }
}

