/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ActuatorProvider {
    private final WebMvcEndpointHandlerMapping webMvcEndpointHandlerMapping;

    public ActuatorProvider(WebMvcEndpointHandlerMapping webMvcEndpointHandlerMapping) {
        this.webMvcEndpointHandlerMapping = webMvcEndpointHandlerMapping;
    }

    public Map<RequestMappingInfo, HandlerMethod> getMethods() {
        return this.webMvcEndpointHandlerMapping.getHandlerMethods();
    }

    public Tag getTag() {
        Tag actuatorTag = new Tag();
        actuatorTag.setName("Actuator");
        actuatorTag.setDescription("Monitor and interact");
        actuatorTag.setExternalDocs(new ExternalDocumentation().url("https://docs.spring.io/spring-boot/docs/current/actuator-api/html/").description("Spring Boot Actuator Web API Documentation"));
        return actuatorTag;
    }

    public boolean isRestController(String operationPath) {
        return operationPath.startsWith("/");
    }
}

