/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.MediaAttributes;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.method.HandlerMethod;

@Component
public class RequestBuilder
extends AbstractRequestBuilder {
    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MediaAttributes mediaAttributes) {
        operation.setOperationId(handlerMethod.getMethod().getName());
        LocalVariableTableParameterNameDiscoverer d = new LocalVariableTableParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
        java.lang.reflect.Parameter[] parameters = handlerMethod.getMethod().getParameters();
        for (int i = 0; i < pNames.length; ++i) {
            Parameter parameter = null;
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)this.getParameterAnnotation(handlerMethod, parameters[i], i, io.swagger.v3.oas.annotations.Parameter.class);
            if (parameterDoc != null) {
                if (parameterDoc.hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, null);
            }
            parameter = this.buildParams(pNames[i], components, parameters[i], i, parameter, handlerMethod);
            if ((parameter = this.buildParamDefault(requestMethod, pNames[i], parameters[i], parameter)) != null && parameter.getName() != null) {
                this.applyBeanValidatorAnnotations(parameter, Arrays.asList(parameters[i].getAnnotations()));
                operationParameters.add(parameter);
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = (io.swagger.v3.oas.annotations.parameters.RequestBody)this.getParameterAnnotation(handlerMethod, parameters[i], i, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
            RequestBody requestBody = null;
            if (requestBodyDoc != null) {
                requestBody = this.requestBodyBuilder.buildRequestBodyFromDoc(requestBodyDoc, mediaAttributes.getClassConsumes(), mediaAttributes.getMethodConsumes(), components, null).orElse(null);
            }
            RequestPart requestPart = (RequestPart)this.getParameterAnnotation(handlerMethod, parameters[i], i, RequestPart.class);
            String paramName = null;
            if (requestPart != null) {
                paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
            }
            paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)pNames[i]);
            requestBody = this.buildRequestBody(requestBody, components, mediaAttributes.getAllConsumes(), parameters[i], parameterDoc, paramName);
            operation.setRequestBody(requestBody);
        }
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        return operation;
    }
}

