/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
class SwaggerWelcome
implements InitializingBean {
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    @Value(value="${springdoc.swagger-ui.configUrl:#{null}}")
    private String originConfigUrl;
    @Value(value="${springdoc.swagger-ui.url:#{null}}")
    private String swaggerUiUrl;
    @Value(value="${springdoc.swagger-ui.oauth2RedirectUrl:#{null}}")
    private String oauth2RedirectUrl;
    @Autowired
    private SwaggerUiConfigProperties swaggerUiConfig;
    private String uiRootPath;

    SwaggerWelcome() {
    }

    public void afterPropertiesSet() {
        this.calculateUiRootPath();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi(HttpServletRequest request) {
        StringBuilder sbUrl = new StringBuilder("redirect:").append(this.uiRootPath);
        sbUrl.append("/swagger-ui/index.html");
        this.buildConfigUrl(request);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl.toString());
        return uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfig.getConfigUrl()}).build().encode().toString();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> openapiYaml(HttpServletRequest request) {
        this.buildConfigUrl(request);
        return this.swaggerUiConfig.getConfigParameters();
    }

    private String buildUrl(HttpServletRequest request, String docsUrl) {
        String contextPath = request.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        return contextPath + docsUrl;
    }

    private void buildConfigUrl(HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)this.originConfigUrl)) {
            String url = this.buildUrl(request, this.apiDocsUrl);
            String swaggerConfigUrl = url + "/" + "swagger-config";
            this.swaggerUiConfig.setConfigUrl(swaggerConfigUrl);
            if (SwaggerUiConfigProperties.getSwaggerUrls().isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)this.swaggerUiUrl)) {
                    this.swaggerUiConfig.setUrl(url);
                } else {
                    this.swaggerUiConfig.setUrl(this.swaggerUiUrl);
                }
            } else {
                SwaggerUiConfigProperties.addUrl((String)url);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.oauth2RedirectUrl)) {
            this.swaggerUiConfig.setOauth2RedirectUrl(ServletUriComponentsBuilder.fromCurrentContextPath().path(this.uiRootPath).path("/swagger-ui/oauth2-redirect.html").build().toString());
        } else if (!this.swaggerUiConfig.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            this.swaggerUiConfig.setOauth2RedirectUrl(ServletUriComponentsBuilder.fromCurrentContextPath().path(this.uiRootPath).path(this.swaggerUiConfig.getOauth2RedirectUrl()).build().toString());
        }
    }

    private void calculateUiRootPath() {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        if (this.swaggerPath.contains("/")) {
            sbUrl.append(this.swaggerPath.substring(0, this.swaggerPath.lastIndexOf("/")));
        }
        this.uiRootPath = sbUrl.toString();
    }
}

