/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import io.swagger.v3.oas.annotations.Operation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
class SwaggerWelcome {
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;

    SwaggerWelcome() {
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String uiRootPath = "";
        if (this.swaggerPath.contains("/")) {
            uiRootPath = this.swaggerPath.substring(0, this.swaggerPath.lastIndexOf(47));
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("redirect:");
        sbUrl.append(uiRootPath);
        sbUrl.append("/swagger-ui/index.html?url=");
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
            sbUrl.append(contextPath).append(this.apiDocsUrl);
        } else {
            sbUrl.append(contextPath).append(this.apiDocsUrl);
        }
        sbUrl.append("&validatorUrl=");
        return sbUrl.toString();
    }
}

