/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.data;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springdoc.core.data.ControllerType;
import org.springdoc.core.data.DataRestRepository;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.parsers.ReturnTypeParser;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.utils.SpringDocDataRestUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestResponseService {
    private final GenericResponseService genericResponseService;
    private final SpringDocDataRestUtils springDocDataRestUtils;
    private static final RequestMethod[] requestMethodsEntityModel = new RequestMethod[]{RequestMethod.PATCH, RequestMethod.POST, RequestMethod.PUT};

    public DataRestResponseService(GenericResponseService genericResponseService, SpringDocDataRestUtils springDocDataRestUtils) {
        this.genericResponseService = genericResponseService;
        this.springDocDataRestUtils = springDocDataRestUtils;
    }

    public void buildSearchResponse(Operation operation, HandlerMethod handlerMethod, OpenAPI openAPI, MethodResourceMapping methodResourceMapping, Class<?> domainType, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository) {
        ApiResponses apiResponses;
        MethodParameter methodParameterReturn = handlerMethod.getReturnType();
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responsesArray = this.genericResponseService.getApiResponses(methodResourceMapping.getMethod());
        if (!responsesArray.isEmpty() || !CollectionUtils.isEmpty((Map)operation.getResponses())) {
            apiResponses = this.genericResponseService.build(openAPI.getComponents(), new HandlerMethod(methodResourceMapping.getMethod().getDeclaringClass(), methodResourceMapping.getMethod()), operation, methodAttributes);
        } else {
            apiResponses = new ApiResponses();
            ApiResponse apiResponse = new ApiResponse();
            Type returnType = this.findSearchReturnType(methodResourceMapping, domainType);
            Content content = this.genericResponseService.buildContent(openAPI.getComponents(), methodParameterReturn.getParameterAnnotations(), methodAttributes.getMethodProduces(), null, returnType);
            this.springDocDataRestUtils.buildTextUriContent(content);
            apiResponse.setContent(content);
            this.addResponse200(apiResponses, apiResponse);
            this.addResponse404(apiResponses);
        }
        operation.setResponses(apiResponses);
    }

    public void buildEntityResponse(Operation operation, HandlerMethod handlerMethod, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, DataRestRepository dataRestRepository, ResourceMetadata resourceMetadata) {
        MethodParameter methodParameterReturn = handlerMethod.getReturnType();
        Type returnType = this.getType(methodParameterReturn, requestMethod, dataRestRepository, resourceMetadata);
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        Content content = this.genericResponseService.buildContent(openAPI.getComponents(), methodParameterReturn.getParameterAnnotations(), methodAttributes.getMethodProduces(), null, returnType);
        this.springDocDataRestUtils.buildTextUriContent(content);
        apiResponse.setContent(content);
        this.addResponse(requestMethod, operationPath, apiResponses, apiResponse);
        operation.setResponses(apiResponses);
    }

    private void addResponse(RequestMethod requestMethod, String operationPath, ApiResponses apiResponses, ApiResponse apiResponse) {
        switch (requestMethod) {
            case GET: {
                this.addResponse200(apiResponses, apiResponse);
                if (!operationPath.contains("/{id}")) break;
                this.addResponse404(apiResponses);
                break;
            }
            case POST: {
                apiResponses.put((Object)String.valueOf(HttpStatus.CREATED.value()), (Object)apiResponse.description(HttpStatus.CREATED.getReasonPhrase()));
                break;
            }
            case DELETE: {
                this.addResponse204(apiResponses);
                this.addResponse404(apiResponses);
                break;
            }
            case PUT: {
                this.addResponse200(apiResponses, apiResponse);
                apiResponses.put((Object)String.valueOf(HttpStatus.CREATED.value()), (Object)new ApiResponse().content(apiResponse.getContent()).description(HttpStatus.CREATED.getReasonPhrase()));
                this.addResponse204(apiResponses);
                break;
            }
            case PATCH: {
                this.addResponse200(apiResponses, apiResponse);
                this.addResponse204(apiResponses);
                break;
            }
            default: {
                throw new IllegalArgumentException(requestMethod.name());
            }
        }
    }

    private Type findSearchReturnType(MethodResourceMapping methodResourceMapping, Class<?> domainType) {
        Type returnType;
        Type returnRepoType = ReturnTypeParser.resolveType(methodResourceMapping.getMethod().getGenericReturnType(), methodResourceMapping.getMethod().getDeclaringClass());
        if (methodResourceMapping.isPagingResource()) {
            returnType = this.resolveGenericType(PagedModel.class, EntityModel.class, domainType);
        } else {
            if (ResolvableType.forType((Type)returnRepoType).getRawClass() != null && Iterable.class.isAssignableFrom(Objects.requireNonNull(ResolvableType.forType((Type)returnRepoType).getRawClass()))) {
                return this.getTypeForCollectionModel(domainType, methodResourceMapping.isPagingResource());
            }
            returnType = ClassUtils.isPrimitiveOrWrapper((Class)methodResourceMapping.getReturnedDomainType()) ? methodResourceMapping.getReturnedDomainType() : ResolvableType.forClassWithGenerics(EntityModel.class, (Class[])new Class[]{domainType}).getType();
        }
        return returnType;
    }

    private Type getType(MethodParameter methodParameterReturn, RequestMethod requestMethod, DataRestRepository dataRestRepository, ResourceMetadata resourceMetadata) {
        Type returnType = ReturnTypeParser.resolveType(methodParameterReturn.getGenericParameterType(), methodParameterReturn.getContainingClass());
        Class returnedEntityType = dataRestRepository.getReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (ResponseEntity.class.equals((Object)parameterizedType.getRawType())) {
                return this.getTypeForResponseEntity(requestMethod, dataRestRepository, returnedEntityType, parameterizedType);
            }
            if (HttpEntity.class.equals((Object)parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                ParameterizedType wildcardTypeUpperBound = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
                if (RepresentationModel.class.equals((Object)wildcardTypeUpperBound.getRawType())) {
                    return this.resolveGenericType(HttpEntity.class, RepresentationModel.class, returnedEntityType);
                }
            } else if (CollectionModel.class.equals((Object)parameterizedType.getRawType()) && Object.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
                return this.getTypeForCollectionModel(returnedEntityType, resourceMetadata.isPagingResource());
            }
        }
        return returnType;
    }

    private Type getTypeForResponseEntity(RequestMethod requestMethod, DataRestRepository dataRestRepository, Class returnedEntityType, ParameterizedType parameterizedType) {
        if (Object.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            return ResolvableType.forClassWithGenerics(ResponseEntity.class, (Class[])new Class[]{returnedEntityType}).getType();
        }
        if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
            return this.getTypeForParameterizedType(requestMethod, dataRestRepository, returnedEntityType, parameterizedType);
        }
        if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
            return this.getTypeForWildcardType(requestMethod, dataRestRepository, returnedEntityType, parameterizedType);
        }
        return null;
    }

    private Type getTypeForCollectionModel(Class returnedEntityType, boolean pagingResource) {
        if (pagingResource) {
            return this.resolveGenericType(PagedModel.class, EntityModel.class, returnedEntityType);
        }
        return this.resolveGenericType(CollectionModel.class, EntityModel.class, returnedEntityType);
    }

    private Type getTypeForWildcardType(RequestMethod requestMethod, DataRestRepository dataRestRepository, Class returnedEntityType, ParameterizedType parameterizedType) {
        ParameterizedType wildcardTypeUpperBound;
        WildcardType wildcardType = (WildcardType)parameterizedType.getActualTypeArguments()[0];
        if (wildcardType.getUpperBounds()[0] instanceof ParameterizedType && RepresentationModel.class.equals((Object)(wildcardTypeUpperBound = (ParameterizedType)wildcardType.getUpperBounds()[0]).getRawType())) {
            Class type = this.findType(requestMethod, dataRestRepository);
            if (MapModel.class.equals((Object)type)) {
                return ResolvableType.forClassWithGenerics(ResponseEntity.class, (Class[])new Class[]{type}).getType();
            }
            return this.resolveGenericType(ResponseEntity.class, type, returnedEntityType);
        }
        return null;
    }

    private Type getTypeForParameterizedType(RequestMethod requestMethod, DataRestRepository dataRestRepository, Class returnedEntityType, ParameterizedType parameterizedType) {
        ParameterizedType parameterizedType1 = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
        Class rawType = ResolvableType.forType((Type)parameterizedType1.getRawType()).getRawClass();
        if (rawType != null && rawType.isAssignableFrom(RepresentationModel.class)) {
            Class type = this.findType(requestMethod, dataRestRepository);
            if (MapModel.class.equals((Object)type)) {
                return ResolvableType.forClassWithGenerics(ResponseEntity.class, (Class[])new Class[]{type}).getType();
            }
            return this.resolveGenericType(ResponseEntity.class, type, returnedEntityType);
        }
        if (EntityModel.class.equals((Object)parameterizedType1.getRawType())) {
            return this.resolveGenericType(ResponseEntity.class, EntityModel.class, returnedEntityType);
        }
        return null;
    }

    private Class findType(RequestMethod requestMethod, DataRestRepository dataRestRepository) {
        if (ControllerType.ENTITY.equals((Object)dataRestRepository.getControllerType())) {
            if (Arrays.stream(requestMethodsEntityModel).anyMatch(arg_0 -> requestMethod.equals(arg_0))) {
                return EntityModel.class;
            }
        }
        if (ControllerType.PROPERTY.equals((Object)dataRestRepository.getControllerType())) {
            if (dataRestRepository.isCollectionLike()) {
                return CollectionModel.class;
            }
            if (dataRestRepository.isMap()) {
                return MapModel.class;
            }
            return EntityModel.class;
        }
        return RepresentationModel.class;
    }

    private Type resolveGenericType(Class<?> container, Class<?> generic, Class<?> domainType) {
        Type type = ResolvableType.forClassWithGenerics(generic, (Class[])new Class[]{domainType}).getType();
        return ResolvableType.forClassWithGenerics(container, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)type)}).getType();
    }

    private void addResponse200(ApiResponses apiResponses, ApiResponse apiResponse) {
        apiResponses.put((Object)String.valueOf(HttpStatus.OK.value()), (Object)apiResponse.description(HttpStatus.OK.getReasonPhrase()));
    }

    private void addResponse204(ApiResponses apiResponses) {
        apiResponses.put((Object)String.valueOf(HttpStatus.NO_CONTENT.value()), (Object)new ApiResponse().description(HttpStatus.NO_CONTENT.getReasonPhrase()));
    }

    private void addResponse404(ApiResponses apiResponses) {
        apiResponses.put((Object)String.valueOf(HttpStatus.NOT_FOUND.value()), (Object)new ApiResponse().description(HttpStatus.NOT_FOUND.getReasonPhrase()));
    }

    private static class MapModel
    extends RepresentationModel<MapModel> {
        private final Map content;

        public MapModel(Map content, Link ... links) {
            super(Arrays.asList(links));
            this.content = content;
        }

        @JsonAnyGetter
        public Map getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapModel mapModel = (MapModel)((Object)o);
            return Objects.equals(this.getContent(), mapModel.getContent());
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getContent());
        }
    }
}

