/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.GeneralInfoBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.RequestBodyBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class OpenApiResource
extends AbstractOpenApiResource {
    private RequestMappingInfoHandlerMapping requestMappingHandlerMapping;

    public OpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, GeneralInfoBuilder infoBuilder, RequestBodyBuilder requestBodyBuilder, RequestMappingInfoHandlerMapping requestMappingHandlerMapping) {
        super(openAPIBuilder, requestBuilder, responseBuilder, operationParser, requestBodyBuilder, infoBuilder);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            String operationPath = (String)patterns.iterator().next();
            if (!operationPath.startsWith("/") || !restControllers.containsKey(handlerMethod.getBean().toString())) continue;
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            this.calculatePath(this.openAPIBuilder, handlerMethod, operationPath, requestMethods);
        }
    }

    private void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        StringBuffer requestUrl = request.getRequestURL();
        String serverBaseUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.generalInfoBuilder.setServerBaseUrl(serverBaseUrl);
    }
}

