/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome
implements InitializingBean {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected final SwaggerUiConfigParameters swaggerUiConfigParameters;

    public AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
        this.swaggerUiConfigParameters = swaggerUiConfigParameters;
    }

    public void afterPropertiesSet() {
        this.springDocConfigProperties.getGroupConfigs().forEach(groupConfig -> this.swaggerUiConfigParameters.addGroup(groupConfig.getGroup()));
        this.calculateUiRootPath(new StringBuilder[0]);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        return contextPath + docsUrl;
    }

    protected void buildConfigUrl(String contextPath, UriComponentsBuilder uriComponentsBuilder) {
        String apiDocsUrl = this.springDocConfigProperties.getApiDocs().getPath();
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            String url = this.buildUrl(contextPath, apiDocsUrl);
            String swaggerConfigUrl = url + "/" + "swagger-config";
            this.swaggerUiConfigParameters.setConfigUrl(swaggerConfigUrl);
            if (CollectionUtils.isEmpty(this.swaggerUiConfigParameters.getUrls())) {
                String swaggerUiUrl = this.swaggerUiConfig.getUrl();
                if (StringUtils.isEmpty((CharSequence)swaggerUiUrl)) {
                    this.swaggerUiConfigParameters.setUrl(url);
                } else {
                    this.swaggerUiConfigParameters.setUrl(swaggerUiUrl);
                }
            } else {
                this.swaggerUiConfigParameters.addUrl(url);
            }
        }
        this.calculateOauth2RedirectUrl(uriComponentsBuilder);
    }

    protected UriComponentsBuilder getUriComponentsBuilder(String sbUrl) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl);
        if (this.swaggerUiConfig.isDisplayQueryParams() && StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getUrl())) {
            this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
        } else if (this.swaggerUiConfig.isDisplayQueryParamsWithoutOauth2() && StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getUrl())) {
            this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !"oauth2RedirectUrl".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
        } else {
            uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfigParameters.getConfigUrl()});
            if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getLayout())) {
                uriBuilder.queryParam("layout", new Object[]{this.swaggerUiConfigParameters.getLayout()});
            }
            if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getFilter())) {
                uriBuilder.queryParam("filter", new Object[]{this.swaggerUiConfigParameters.getFilter()});
            }
        }
        return uriBuilder;
    }

    protected abstract void calculateOauth2RedirectUrl(UriComponentsBuilder var1);

    protected abstract void calculateUiRootPath(StringBuilder ... var1);
}

