/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;

public interface ReturnTypeParser {
    public static Type resolveType(Type genericType, @Nullable Class<?> contextClass) {
        if (contextClass != null) {
            ResolvableType resolvedType;
            if (genericType instanceof TypeVariable) {
                Class resolved;
                ResolvableType resolvedTypeVariable = ReturnTypeParser.resolveVariable((TypeVariable)genericType, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE && (resolved = resolvedTypeVariable.resolve()) != null) {
                    return resolved;
                }
            } else if (genericType instanceof ParameterizedType && (resolvedType = ResolvableType.forType((Type)genericType)).hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                ResolvableType contextType = ResolvableType.forClass(contextClass);
                ReturnTypeParser.findTypeForGenerics(generics, typeArguments, contextType);
                Class rawClass = resolvedType.getRawClass();
                if (rawClass != null) {
                    return ResolvableType.forClassWithGenerics((Class)rawClass, (Class[])generics).getType();
                }
            }
        }
        return genericType;
    }

    public static void findTypeForGenerics(Class<?>[] generics, Type[] typeArguments, ResolvableType contextType) {
        for (int i = 0; i < typeArguments.length; ++i) {
            Type typeArgument = typeArguments[i];
            if (typeArgument instanceof TypeVariable) {
                ResolvableType resolvedTypeArgument = ReturnTypeParser.resolveVariable((TypeVariable)typeArgument, contextType);
                if (resolvedTypeArgument != ResolvableType.NONE) {
                    generics[i] = resolvedTypeArgument.resolve();
                    continue;
                }
                generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                continue;
            }
            generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
        }
    }

    public static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
            return resolvedType;
        }
        ResolvableType superType = contextType.getSuperType();
        if (superType != ResolvableType.NONE && (resolvedType = ReturnTypeParser.resolveVariable(typeVariable, superType)).resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = ReturnTypeParser.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    default public Type getReturnType(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            return ReturnTypeParser.resolveType(methodParameter.getGenericParameterType(), methodParameter.getContainingClass());
        }
        return methodParameter.getParameterType();
    }

    public static Type getType(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            return ReturnTypeParser.resolveType(methodParameter.getGenericParameterType(), methodParameter.getContainingClass());
        }
        return methodParameter.getParameterType();
    }
}

