/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class ConverterUtils {
    private static final List<Class<?>> RESULT_WRAPPERS_TO_IGNORE = new ArrayList();
    private static final List<Class<?>> RESPONSE_TYPES_TO_IGNORE = new ArrayList();

    private ConverterUtils() {
    }

    public static void addResponseWrapperToIgnore(Class<?> cls) {
        RESULT_WRAPPERS_TO_IGNORE.add(cls);
    }

    public static void addResponseTypeToIgnore(Class<?> cls) {
        RESPONSE_TYPES_TO_IGNORE.add(cls);
    }

    public static boolean isResponseTypeWrapper(Class<?> rawClass) {
        return RESULT_WRAPPERS_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public static boolean isResponseTypeToIgnore(Class<?> rawClass) {
        return RESPONSE_TYPES_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public static void removeResponseWrapperToIgnore(Class<?> classes) {
        List<Class> classesToIgnore = Arrays.asList(classes);
        if (RESULT_WRAPPERS_TO_IGNORE.containsAll(classesToIgnore)) {
            RESULT_WRAPPERS_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    public static void removeResponseTypeToIgnore(Class<?> classes) {
        List<Class> classesToIgnore = Arrays.asList(classes);
        if (RESPONSE_TYPES_TO_IGNORE.containsAll(classesToIgnore)) {
            RESPONSE_TYPES_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    static {
        RESULT_WRAPPERS_TO_IGNORE.add(Callable.class);
        RESULT_WRAPPERS_TO_IGNORE.add(ResponseEntity.class);
        RESULT_WRAPPERS_TO_IGNORE.add(HttpEntity.class);
        RESULT_WRAPPERS_TO_IGNORE.add(CompletionStage.class);
    }
}

