/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class ConverterUtils {
    private static final List<Class<?>> RESULT_WRAPPERS_TO_IGNORE = new ArrayList();

    private ConverterUtils() {
    }

    public static void addResponseWrapperToIgnore(Class<?> cls) {
        RESULT_WRAPPERS_TO_IGNORE.add(cls);
    }

    public static boolean isResponseTypeWrapper(Class<?> rawClass) {
        return RESULT_WRAPPERS_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    static {
        RESULT_WRAPPERS_TO_IGNORE.add(Callable.class);
        RESULT_WRAPPERS_TO_IGNORE.add(ResponseEntity.class);
        RESULT_WRAPPERS_TO_IGNORE.add(HttpEntity.class);
        RESULT_WRAPPERS_TO_IGNORE.add(CompletionStage.class);
    }
}

