/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractParameterBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.RequestInfo;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequestBuilder {
    protected static final List<Class> PARAM_TYPES_TO_IGNORE = new ArrayList<Class>();
    private static final String[] ANNOTATIONS_FOR_REQUIRED = new String[]{NotNull.class.getName(), "javax.validation.constraints.NotBlank", "javax.validation.constraints.NotEmpty"};
    private static final String POSITIVE_OR_ZERO = "javax.validation.constraints.PositiveOrZero";
    private static final String NEGATIVE_OR_ZERO = "javax.validation.constraints.NegativeOrZero";
    private final AbstractParameterBuilder parameterBuilder;
    private final RequestBodyBuilder requestBodyBuilder;
    private final OperationBuilder operationBuilder;

    protected AbstractRequestBuilder(AbstractParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, OperationBuilder operationBuilder) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyBuilder = requestBodyBuilder;
        this.operationBuilder = operationBuilder;
    }

    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MethodAttributes methodAttributes) {
        String operationId = this.operationBuilder.getOperationId(handlerMethod.getMethod().getName(), operation.getOperationId());
        operation.setOperationId(operationId);
        LocalVariableTableParameterNameDiscoverer d = this.parameterBuilder.getLocalSpringDocParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        Parameter[] parameters = handlerMethod.getMethod().getParameters();
        String[] reflectionParametersNames = (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
        if (pNames == null) {
            pNames = reflectionParametersNames;
        }
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo(methodAttributes);
        List operationParameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
        Map<String, io.swagger.v3.oas.annotations.Parameter> parametersDocMap = this.getApiParameters(handlerMethod.getMethod());
        for (int i = 0; i < pNames.length; ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = null;
            String pName = pNames[i] == null ? reflectionParametersNames[i] : pNames[i];
            io.swagger.v3.oas.annotations.Parameter parameterDoc = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters[i], i, io.swagger.v3.oas.annotations.Parameter.class);
            if (parameterDoc == null) {
                parameterDoc = parametersDocMap.get(pName);
            }
            if (parameterDoc != null) {
                if (parameterDoc.hidden()) continue;
                parameter2 = this.parameterBuilder.buildParameterFromDoc(parameterDoc, null, methodAttributes.getJsonViewAnnotation());
            }
            if (this.isParamToIgnore(parameters[i])) continue;
            ParameterInfo parameterInfo = new ParameterInfo(pName, parameters[i], parameter2, i);
            parameter2 = this.buildParams(parameterInfo, components, handlerMethod, requestMethod, methodAttributes.getJsonViewAnnotation());
            if (this.isValidParameter(parameter2 = this.parameterBuilder.mergeParameter(operationParameters, parameter2))) {
                this.applyBeanValidatorAnnotations(parameter2, Arrays.asList(parameters[i].getAnnotations()));
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            requestBodyInfo.incrementNbParam();
            requestBodyInfo.setRequestBody(operation.getRequestBody());
            this.requestBodyBuilder.calculateRequestBodyInfo(components, handlerMethod, methodAttributes, i, parameterInfo, requestBodyInfo);
        }
        LinkedHashMap map = operationParameters.stream().collect(Collectors.toMap(io.swagger.v3.oas.models.parameters.Parameter::getName, parameter -> parameter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        for (Map.Entry<String, io.swagger.v3.oas.annotations.Parameter> entry : parametersDocMap.entrySet()) {
            if (entry.getKey() == null || map.containsKey(entry.getKey()) || entry.getValue().hidden()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter3 = this.parameterBuilder.buildParameterFromDoc(entry.getValue(), components, methodAttributes.getJsonViewAnnotation());
            map.put(entry.getKey(), parameter3);
        }
        this.setParams(operation, new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(map.values()), requestBodyInfo);
        operation = this.customiseOperation(operation, handlerMethod);
        return operation;
    }

    protected abstract Operation customiseOperation(Operation var1, HandlerMethod var2);

    protected boolean isParamToIgnore(Parameter parameter) {
        if (parameter.isAnnotationPresent(PathVariable.class)) {
            return false;
        }
        return this.parameterBuilder.isAnnotationToIgnore(parameter) || PARAM_TYPES_TO_IGNORE.contains(parameter.getType()) || AnnotationUtils.findAnnotation(parameter.getType(), Hidden.class) != null;
    }

    private void setParams(Operation operation, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, RequestBodyInfo requestBodyInfo) {
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
    }

    private boolean isValidParameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
        return parameter != null && (parameter.getName() != null || parameter.get$ref() != null);
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParams(ParameterInfo parameterInfo, Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, JsonView jsonView) {
        Parameter parameters = parameterInfo.getParameter();
        int index = parameterInfo.getIndex();
        RequestHeader requestHeader = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, RequestHeader.class);
        RequestParam requestParam = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, RequestParam.class);
        PathVariable pathVar = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, PathVariable.class);
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        if (requestHeader != null) {
            RequestInfo requestInfo = new RequestInfo(RequestInfo.ParameterType.HEADER_PARAM, requestHeader.value(), requestHeader.required(), requestHeader.defaultValue());
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        } else if (requestParam != null) {
            RequestInfo requestInfo = new RequestInfo(RequestInfo.ParameterType.QUERY_PARAM, requestParam.value(), requestParam.required(), requestParam.defaultValue());
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        } else if (pathVar != null) {
            String pName = parameterInfo.getpName();
            String name = StringUtils.isBlank((CharSequence)pathVar.value()) ? pName : pathVar.value();
            parameterInfo.setpName(name);
            RequestInfo requestInfo = new RequestInfo(RequestInfo.ParameterType.PATH_PARAM, pathVar.value(), Boolean.TRUE, null);
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        }
        if (RequestMethod.GET.equals((Object)requestMethod)) {
            parameter = this.buildParam("query", components, parameterInfo, Boolean.TRUE, null, jsonView);
        }
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(ParameterInfo parameterInfo, Components components, RequestInfo requestInfo, JsonView jsonView) {
        String pName = parameterInfo.getpName();
        String name = StringUtils.isBlank((CharSequence)requestInfo.value()) ? pName : requestInfo.value();
        parameterInfo.setpName(name);
        io.swagger.v3.oas.models.parameters.Parameter parameter = !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestInfo.defaultValue()) ? this.buildParam(requestInfo.type(), components, parameterInfo, false, requestInfo.defaultValue(), jsonView) : this.buildParam(requestInfo.type(), components, parameterInfo, requestInfo.required(), null, jsonView);
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(String in, Components components, ParameterInfo parameterInfo, Boolean required, String defaultValue, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = parameterInfo.getParameterModel();
        String name = parameterInfo.getpName();
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameterInfo.setParameterModel(parameter);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn(in);
        }
        if (required != null && parameter.getRequired() == null) {
            parameter.setRequired(required);
        }
        if (parameter.getSchema() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo.getParameter(), name, null, jsonView);
            if (defaultValue != null) {
                schema.setDefault((Object)defaultValue);
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    private void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), (Annotation)annotation));
        }
        boolean annotationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (annotationExists) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(POSITIVE_OR_ZERO)) {
            schema.setMinimum(BigDecimal.ZERO);
        }
        if (annos.containsKey(NEGATIVE_OR_ZERO)) {
            schema.setMaximum(BigDecimal.ZERO);
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    public RequestBodyBuilder getRequestBodyBuilder() {
        return this.requestBodyBuilder;
    }

    private Map<String, io.swagger.v3.oas.annotations.Parameter> getApiParameters(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiParametersDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameters.class);
        LinkedHashMap apiParametersMap = apiParametersDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        Set apiParametersDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameters.class);
        LinkedHashMap apiParametersDocDeclaringClassMap = apiParametersDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParametersDocDeclaringClassMap);
        Set apiParameterDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocMap = apiParameterDoc.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocMap);
        Set apiParameterDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocDeclaringClassMap = apiParameterDocDeclaringClass.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocDeclaringClassMap);
        return apiParametersMap;
    }

    static {
        PARAM_TYPES_TO_IGNORE.add(WebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(NativeWebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(Principal.class);
        PARAM_TYPES_TO_IGNORE.add(HttpMethod.class);
        PARAM_TYPES_TO_IGNORE.add(Locale.class);
        PARAM_TYPES_TO_IGNORE.add(TimeZone.class);
        PARAM_TYPES_TO_IGNORE.add(InputStream.class);
        PARAM_TYPES_TO_IGNORE.add(ZoneId.class);
        PARAM_TYPES_TO_IGNORE.add(Reader.class);
        PARAM_TYPES_TO_IGNORE.add(OutputStream.class);
        PARAM_TYPES_TO_IGNORE.add(Writer.class);
        PARAM_TYPES_TO_IGNORE.add(Map.class);
        PARAM_TYPES_TO_IGNORE.add(Model.class);
        PARAM_TYPES_TO_IGNORE.add(ModelMap.class);
        PARAM_TYPES_TO_IGNORE.add(Errors.class);
        PARAM_TYPES_TO_IGNORE.add(BindingResult.class);
        PARAM_TYPES_TO_IGNORE.add(SessionStatus.class);
        PARAM_TYPES_TO_IGNORE.add(UriComponentsBuilder.class);
        PARAM_TYPES_TO_IGNORE.add(RequestAttribute.class);
    }
}

