/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Arrays;
import org.springdoc.core.MethodAttributes;

public class RequestBodyInfo {
    private RequestBody requestBody;
    private Schema mergedSchema;
    private int nbParams;

    public RequestBodyInfo(MethodAttributes methodAttributes) {
        String[] allConsumes = methodAttributes.getAllConsumes();
        if (Arrays.stream(allConsumes).anyMatch("multipart/form-data"::equals)) {
            this.initMergedSchema();
        }
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void incrementNbParam() {
        ++this.nbParams;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public Schema getMergedSchema() {
        if (this.mergedSchema == null && this.nbParams > 1) {
            this.mergedSchema = new ObjectSchema();
        }
        return this.mergedSchema;
    }

    public Schema initMergedSchema() {
        if (this.mergedSchema == null) {
            this.mergedSchema = new ObjectSchema();
        }
        return this.mergedSchema;
    }

    public void setMergedSchema(Schema mergedSchema) {
        this.mergedSchema = mergedSchema;
    }

    public int getNbParams() {
        return this.nbParams;
    }

    public void setNbParams(int nbParams) {
        this.nbParams = nbParams;
    }
}

