/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.ParameterBuilder;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.RequestBodyInfo;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractRequestBuilder {
    private ParameterBuilder parameterBuilder;
    private RequestBodyBuilder requestBodyBuilder;

    protected AbstractRequestBuilder(ParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyBuilder = requestBodyBuilder;
    }

    protected abstract boolean isParamTypeToIgnore(Class<?> var1);

    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MediaAttributes mediaAttributes) {
        operation.setOperationId(handlerMethod.getMethod().getName());
        LocalVariableTableParameterNameDiscoverer d = new LocalVariableTableParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        List existingParamDoc = operation.getParameters();
        java.lang.reflect.Parameter[] parameters = handlerMethod.getMethod().getParameters();
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
        for (int i = 0; i < pNames.length; ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = null;
            String pName = pNames[i];
            Class<?> paramType = parameters[i].getType();
            Parameter parameterDoc = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters[i], i, Parameter.class);
            if (parameterDoc != null) {
                if (parameterDoc.hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, null);
            }
            if (this.isParamTypeToIgnore(paramType)) continue;
            parameter = this.buildParams(pName, components, parameters[i], i, parameter, handlerMethod, requestMethod);
            if (this.isValidPararameter(parameter = this.parameterBuilder.mergeParameter(existingParamDoc, parameter))) {
                this.applyBeanValidatorAnnotations(parameter, Arrays.asList(parameters[i].getAnnotations()));
                operationParameters.add(parameter);
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            requestBodyInfo.incrementNbParam();
            ParameterInfo parameterInfo = new ParameterInfo(pName, parameters[i], parameterDoc);
            requestBodyInfo.setRequestBody(operation.getRequestBody());
            this.requestBodyBuilder.calculateRequestBodyInfo(components, handlerMethod, mediaAttributes, i, parameterInfo, requestBodyInfo);
        }
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
        return operation;
    }

    private boolean isValidPararameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
        return parameter != null && (parameter.getName() != null || parameter.get$ref() != null);
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParams(String pName, Components components, java.lang.reflect.Parameter parameters, int index, io.swagger.v3.oas.models.parameters.Parameter parameter, HandlerMethod handlerMethod, RequestMethod requestMethod) {
        RequestHeader requestHeader = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, RequestHeader.class);
        RequestParam requestParam = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, RequestParam.class);
        PathVariable pathVar = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters, index, PathVariable.class);
        if (requestHeader != null) {
            String name = StringUtils.isBlank((CharSequence)requestHeader.value()) ? pName : requestHeader.value();
            parameter = this.buildParam("header", components, parameters, requestHeader.required(), name, parameter);
        } else if (requestParam != null) {
            String name = StringUtils.isBlank((CharSequence)requestParam.value()) ? pName : requestParam.value();
            parameter = this.buildParam("query", components, parameters, requestParam.required(), name, parameter);
        } else if (pathVar != null) {
            String name = StringUtils.isBlank((CharSequence)pathVar.value()) ? pName : pathVar.value();
            parameter = this.buildParam("path", components, parameters, Boolean.TRUE, name, parameter);
        }
        if (RequestMethod.GET.equals((Object)requestMethod)) {
            if (parameter == null) {
                parameter = this.buildParam("query", components, parameters, Boolean.TRUE, pName, null);
            } else if (parameter.getName() == null) {
                parameter.setName(pName);
            }
        }
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(String in, Components components, java.lang.reflect.Parameter parameters, Boolean required, String name, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        }
        parameter.setIn(in);
        parameter.setRequired(required);
        parameter.setName(name);
        if (parameter.getSchema() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameters, name, null, null);
            parameter.setSchema(schema);
        }
        return parameter;
    }

    private void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), (Annotation)annotation));
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.valueOf(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.valueOf(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }
}

