/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.ParameterBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.method.HandlerMethod;

@Component
public class RequestBodyBuilder {
    private ParameterBuilder parameterBuilder;

    public RequestBodyBuilder(ParameterBuilder parameterBuilder) {
        this.parameterBuilder = parameterBuilder;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, String[] classConsumes, String[] methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        } else {
            requestBodyObject.setDescription("default response");
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])requestBody.extensions());
            if (extensions != null) {
                for (Map.Entry entry : extensions.entrySet()) {
                    requestBodyObject.addExtension((String)entry.getKey(), entry.getValue());
                }
            }
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((io.swagger.v3.oas.annotations.media.Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes), (String[])(methodConsumes == null ? new String[]{} : methodConsumes), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public RequestBody calculateRequestBody(Components components, HandlerMethod handlerMethod, MediaAttributes mediaAttributes, String[] pNames, java.lang.reflect.Parameter[] parameters, int i, Parameter parameterDoc) {
        RequestBody requestBody = null;
        io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters[i], i, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
        if (requestBodyDoc != null) {
            requestBody = this.buildRequestBodyFromDoc(requestBodyDoc, mediaAttributes.getClassConsumes(), mediaAttributes.getMethodConsumes(), components, null).orElse(null);
        }
        RequestPart requestPart = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameters[i], i, RequestPart.class);
        String paramName = null;
        if (requestPart != null) {
            paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
        }
        paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)pNames[i]);
        return this.buildRequestBody(requestBody, components, mediaAttributes.getAllConsumes(), parameters[i], parameterDoc, paramName);
    }

    protected RequestBody buildRequestBody(RequestBody requestBody, Components components, String[] allConsumes, java.lang.reflect.Parameter parameter, Parameter parameterDoc, String paramName) {
        if (requestBody == null) {
            requestBody = new RequestBody();
        }
        Schema schema = this.parameterBuilder.calculateSchema(components, parameter, paramName);
        MediaType mediaType = null;
        if (schema != null && schema.getType() != null) {
            mediaType = new MediaType();
            mediaType.setSchema(schema);
        } else {
            Class<?> returnType = parameter.getType();
            mediaType = this.calculateSchema(components, returnType);
        }
        Content content1 = new Content();
        if (ArrayUtils.isNotEmpty((Object[])allConsumes)) {
            for (String value : allConsumes) {
                this.setMediaTypeToContent(schema, content1, value);
            }
        } else {
            content1.addMediaType("*/*", mediaType);
        }
        requestBody.setContent(content1);
        if (parameterDoc != null) {
            if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
                requestBody.setDescription(parameterDoc.description());
            }
            requestBody.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        return requestBody;
    }

    private MediaType calculateSchema(Components components, Type returnType) {
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
        MediaType mediaType = new MediaType();
        if (resolvedSchema.schema != null) {
            Map schemaMap;
            Schema returnTypeSchema = resolvedSchema.schema;
            if (returnTypeSchema != null) {
                mediaType.setSchema(returnTypeSchema);
            }
            if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return mediaType;
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }
}

