/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.request;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.tool.request.BladeHttpServletRequestWrapper;
import org.springblade.core.tool.request.RequestProperties;
import org.springblade.core.tool.request.XssHttpServletRequestWrapper;
import org.springblade.core.tool.request.XssProperties;
import org.springframework.util.AntPathMatcher;

public class BladeRequestFilter
implements Filter {
    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (!this.requestProperties.getEnabled().booleanValue() || this.isRequestSkip(path)) {
            chain.doFilter(request, response);
        } else if (!this.xssProperties.getEnabled().booleanValue() || this.isXssSkip(path)) {
            BladeHttpServletRequestWrapper bladeRequest = new BladeHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)bladeRequest, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    private boolean isRequestSkip(String path) {
        return this.requestProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    private boolean isXssSkip(String path) {
        return this.xssProperties.getSkipUrl().stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, path));
    }

    public void destroy() {
    }

    public BladeRequestFilter(RequestProperties requestProperties, XssProperties xssProperties) {
        this.requestProperties = requestProperties;
        this.xssProperties = xssProperties;
    }
}

