/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.qiniu.common.Zone;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springblade.core.oss.QiniuTemplate;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.BladeOssRule;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="qiniu")
public class QiniuConfiguration {
    private OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new BladeOssRule();
    }

    @Bean
    public Configuration qiniuConfiguration() {
        return new Configuration(Zone.autoZone());
    }

    @Bean
    public Auth auth() {
        return Auth.create((String)this.ossProperties.getAccessKey(), (String)this.ossProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public UploadManager uploadManager(Configuration cfg) {
        return new UploadManager(cfg);
    }

    @Bean
    @ConditionalOnBean(value={Configuration.class})
    public BucketManager bucketManager(Configuration cfg) {
        return new BucketManager(Auth.create((String)this.ossProperties.getAccessKey(), (String)this.ossProperties.getSecretKey()), cfg);
    }

    @Bean
    @ConditionalOnMissingBean(value={QiniuTemplate.class})
    @ConditionalOnBean(value={Auth.class, UploadManager.class, BucketManager.class, OssRule.class})
    public QiniuTemplate qiniuTemplate(Auth auth, UploadManager uploadManager, BucketManager bucketManager, OssRule ossRule) {
        return new QiniuTemplate(auth, uploadManager, bucketManager, this.ossProperties, ossRule);
    }

    public QiniuConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

