/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.prompt;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.method.prompt.AbstractMcpPromptMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncMcpPromptMethodCallback
extends AbstractMcpPromptMethodCallback
implements BiFunction<McpAsyncServerExchange, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> {
    private AsyncMcpPromptMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.prompt);
    }

    @Override
    public Mono<McpSchema.GetPromptResult> apply(McpAsyncServerExchange exchange, McpSchema.GetPromptRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        return Mono.defer(() -> {
            try {
                Object[] args = this.buildArgs(this.method, exchange, request);
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.bean, args);
                if (result instanceof Mono) {
                    return ((Mono)result).map(r -> this.convertToGetPromptResult(r));
                }
                return Mono.just((Object)this.convertToGetPromptResult(result));
            }
            catch (Exception e) {
                return Mono.error((Throwable)new AbstractMcpPromptMethodCallback.McpPromptMethodException("Error invoking prompt method: " + this.method.getName(), e));
            }
        });
    }

    @Override
    protected boolean isExchangeOrContextType(Class<?> paramType) {
        return McpAsyncServerExchange.class.isAssignableFrom(paramType);
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!Mono.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must return a Mono<T> where T is one of GetPromptResult, List<PromptMessage>, List<String>, PromptMessage, or String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpPromptMethodCallback.AbstractBuilder<Builder, AsyncMcpPromptMethodCallback> {
        @Override
        public AsyncMcpPromptMethodCallback build() {
            this.validate();
            return new AsyncMcpPromptMethodCallback(this);
        }
    }
}

