/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.complete;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManager;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.springaicommunity.mcp.annotation.CompleteAdapter;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;

public abstract class AbstractMcpCompleteMethodCallback {
    protected final Method method;
    protected final Object bean;
    protected final String prompt;
    protected final String uri;
    protected final McpSchema.CompleteReference completeReference;
    protected final List<String> uriVariables;
    protected final McpUriTemplateManager uriTemplateManager;

    protected AbstractMcpCompleteMethodCallback(Method method, Object bean, String prompt, String uri, McpUriTemplateManagerFactory uriTemplateManagerFactory) {
        Assert.notNull((Object)method, (String)"Method can't be null!");
        Assert.notNull((Object)bean, (String)"Bean can't be null!");
        Assert.notNull((Object)uriTemplateManagerFactory, (String)"URI template manager factory can't be null!");
        if ((prompt == null || prompt.isEmpty()) && (uri == null || uri.isEmpty())) {
            throw new IllegalArgumentException("Either prompt or uri must be provided!");
        }
        if (prompt != null && !prompt.isEmpty() && uri != null && !uri.isEmpty()) {
            throw new IllegalArgumentException("Only one of prompt or uri can be provided!");
        }
        this.method = method;
        this.bean = bean;
        this.prompt = prompt;
        this.uri = uri;
        this.completeReference = prompt != null && !prompt.isEmpty() ? new McpSchema.PromptReference(prompt) : new McpSchema.ResourceReference(uri);
        if (uri != null && !uri.isEmpty()) {
            this.uriTemplateManager = uriTemplateManagerFactory.create(this.uri);
            this.uriVariables = this.uriTemplateManager.getVariableNames();
        } else {
            this.uriTemplateManager = null;
            this.uriVariables = new ArrayList<String>();
        }
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        this.validateParameters(method);
    }

    protected abstract void validateReturnType(Method var1);

    protected void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        int nonSpecialParamCount = 0;
        for (Parameter param : parameters) {
            if (param.isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(param.getType())) continue;
            ++nonSpecialParamCount;
        }
        if (nonSpecialParamCount > 3) {
            throw new IllegalArgumentException("Method can have at most 3 input parameters (excluding @McpProgressToken and McpMeta): " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + nonSpecialParamCount + " parameters");
        }
        boolean hasExchangeParam = false;
        boolean hasRequestParam = false;
        boolean hasArgumentParam = false;
        boolean hasProgressTokenParam = false;
        boolean hasMetaParam = false;
        for (Parameter param : parameters) {
            Class<?> paramType = param.getType();
            if (param.isAnnotationPresent(McpProgressToken.class)) {
                if (hasProgressTokenParam) {
                    throw new IllegalArgumentException("Method cannot have more than one @McpProgressToken parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasProgressTokenParam = true;
                continue;
            }
            if (McpMeta.class.isAssignableFrom(paramType)) {
                if (hasMetaParam) {
                    throw new IllegalArgumentException("Method cannot have more than one McpMeta parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasMetaParam = true;
                continue;
            }
            if (this.isExchangeType(paramType)) {
                if (hasExchangeParam) {
                    throw new IllegalArgumentException("Method cannot have more than one exchange parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasExchangeParam = true;
                continue;
            }
            if (McpSchema.CompleteRequest.class.isAssignableFrom(paramType)) {
                if (hasRequestParam) {
                    throw new IllegalArgumentException("Method cannot have more than one CompleteRequest parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasRequestParam = true;
                continue;
            }
            if (McpSchema.CompleteRequest.CompleteArgument.class.isAssignableFrom(paramType)) {
                if (hasArgumentParam) {
                    throw new IllegalArgumentException("Method cannot have more than one CompleteArgument parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasArgumentParam = true;
                continue;
            }
            if (String.class.isAssignableFrom(paramType)) continue;
            throw new IllegalArgumentException("Method parameters must be exchange, CompleteRequest, CompleteArgument, or String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + paramType.getName());
        }
    }

    protected Object[] buildArgs(Method method, Object exchange, McpSchema.CompleteRequest request) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            Class<?> paramType = param.getType();
            args[i] = param.isAnnotationPresent(McpProgressToken.class) ? null : (McpMeta.class.isAssignableFrom(paramType) ? (request != null ? new McpMeta(request.meta()) : new McpMeta(null)) : (this.isExchangeType(paramType) ? exchange : (McpSchema.CompleteRequest.class.isAssignableFrom(paramType) ? request : (McpSchema.CompleteRequest.CompleteArgument.class.isAssignableFrom(paramType) ? request.argument() : (String.class.isAssignableFrom(paramType) ? request.argument().value() : null)))));
        }
        return args;
    }

    protected abstract boolean isExchangeType(Class<?> var1);

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, R>, R> {
        protected Method method;
        protected Object bean;
        protected McpUriTemplateManagerFactory uriTemplateManagerFactory;
        protected String prompt;
        protected String uri;

        protected AbstractBuilder() {
        }

        public T method(Method method) {
            this.method = method;
            return (T)this;
        }

        public T bean(Object bean) {
            this.bean = bean;
            return (T)this;
        }

        public T prompt(String prompt) {
            this.prompt = prompt;
            return (T)this;
        }

        public T uri(String uri) {
            this.uri = uri;
            return (T)this;
        }

        public T reference(McpSchema.CompleteReference completeReference) {
            if (completeReference instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptRef = (McpSchema.PromptReference)completeReference;
                this.prompt = promptRef.name();
                this.uri = "";
            } else if (completeReference instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceRef = (McpSchema.ResourceReference)completeReference;
                this.prompt = "";
                this.uri = resourceRef.uri();
            }
            return (T)this;
        }

        public T complete(McpComplete complete) {
            McpSchema.CompleteReference completeRef = CompleteAdapter.asCompleteReference(complete);
            if (completeRef instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptRef = (McpSchema.PromptReference)completeRef;
                this.prompt = promptRef.name();
                this.uri = "";
            } else if (completeRef instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceRef = (McpSchema.ResourceReference)completeRef;
                this.prompt = "";
                this.uri = resourceRef.uri();
            }
            return (T)this;
        }

        public T uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return (T)this;
        }

        protected void validate() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method must not be null");
            }
            if (this.bean == null) {
                throw new IllegalArgumentException("Bean must not be null");
            }
            if ((this.prompt == null || this.prompt.isEmpty()) && (this.uri == null || this.uri.isEmpty())) {
                throw new IllegalArgumentException("Either prompt or uri must be provided");
            }
            if (this.prompt != null && !this.prompt.isEmpty() && this.uri != null && !this.uri.isEmpty()) {
                throw new IllegalArgumentException("Only one of prompt or uri can be provided");
            }
            if (this.uriTemplateManagerFactory == null) {
                this.uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();
            }
        }

        public abstract R build();
    }

    public static class McpCompleteMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public McpCompleteMethodException(String message, Throwable cause) {
            super(message, cause);
        }

        public McpCompleteMethodException(String message) {
            super(message);
        }
    }
}

