/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.spockframework.spring.SpringBean;
import org.spockframework.spring.SpringSpy;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RootBeanDefinition;

class QualifierDefinition {
    private final Field field;
    private final DependencyDescriptor descriptor;
    private final Set<Annotation> annotations;

    QualifierDefinition(Field field, Set<Annotation> annotations) {
        this.field = field;
        this.descriptor = new DependencyDescriptor(field, true);
        this.annotations = annotations;
    }

    public boolean matches(ConfigurableListableBeanFactory beanFactory, String beanName) {
        return beanFactory.isAutowireCandidate(beanName, this.descriptor);
    }

    public void applyTo(RootBeanDefinition definition) {
        definition.setQualifiedElement((AnnotatedElement)this.field);
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        QualifierDefinition other = (QualifierDefinition)obj;
        return this.annotations.equals(other.annotations);
    }

    public static QualifierDefinition forElement(AnnotatedElement element) {
        Field field;
        Set<Annotation> annotations;
        if (element != null && element instanceof Field && !(annotations = QualifierDefinition.getQualifierAnnotations(field = (Field)element)).isEmpty()) {
            return new QualifierDefinition(field, annotations);
        }
        return null;
    }

    private static Set<Annotation> getQualifierAnnotations(Field field) {
        Annotation[] candidates = field.getDeclaredAnnotations();
        HashSet<Annotation> annotations = new HashSet<Annotation>(candidates.length);
        for (Annotation candidate : candidates) {
            if (QualifierDefinition.isMockOrSpyAnnotation(candidate)) continue;
            annotations.add(candidate);
        }
        return annotations;
    }

    private static boolean isMockOrSpyAnnotation(Annotation candidate) {
        Class<? extends Annotation> type = candidate.annotationType();
        return type.equals(SpringBean.class) || type.equals(SpringSpy.class);
    }
}

