/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.Longs;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.spf4j.base.Either;
import org.spf4j.base.Strings;
import org.spf4j.io.Csv;
import org.spf4j.tsdb2.TSDBReader;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.DataBlock;
import org.spf4j.tsdb2.avro.DataRow;
import org.spf4j.tsdb2.avro.TableDef;

public final class TSDBQuery {
    private static final DateTimeFormatter DATE_FMT = ISODateTimeFormat.dateTime();

    private TSDBQuery() {
    }

    public static ListMultimap<String, TableDef> getAllTables(File tsdbFile) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (!read.isLeft()) continue;
                TableDef tdef = read.getLeft();
                result.put((Object)tdef.getName(), (Object)tdef);
            }
        }
        return result;
    }

    public static ListMultimap<String, TableDef> getTables(File tsdbFile, Set<String> tables) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                TableDef tdef;
                String name;
                if (!read.isLeft() || !tables.contains(name = (tdef = read.getLeft()).getName())) continue;
                result.put((Object)name, (Object)tdef);
            }
        }
        return result;
    }

    public static ListMultimap<String, TableDefEx> getAllTablesWithDataRanges(File tsdbFile) throws IOException {
        ArrayListMultimap result = ArrayListMultimap.create();
        TLongObjectHashMap id2Def = new TLongObjectHashMap();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (read.isLeft()) {
                    TableDef left = read.getLeft();
                    TableDefEx tableDefEx = new TableDefEx(left, Long.MAX_VALUE, 0L);
                    id2Def.put(left.id, (Object)tableDefEx);
                    result.put((Object)tableDefEx.getTableDef().getName(), (Object)tableDefEx);
                    continue;
                }
                DataBlock right = read.getRight();
                long baseTs = right.baseTimestamp;
                for (DataRow row : right.getValues()) {
                    TableDefEx tdex = (TableDefEx)id2Def.get(row.tableDefId);
                    if (tdex == null) {
                        throw new IOException("Potentially corupted file data row with no tableDef " + (Object)((Object)row));
                    }
                    long ts = baseTs + (long)row.relTimeStamp;
                    if (ts < tdex.getStartTime()) {
                        tdex.setStartTime(ts);
                    }
                    if (ts <= tdex.getEndTime()) continue;
                    tdex.setEndTime(ts);
                }
            }
        }
        return result;
    }

    @Nonnull
    public static List<TableDef> getTableDef(File tsdbFile, String tableName) throws IOException {
        ArrayList<TableDef> result = new ArrayList<TableDef>();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (!read.isLeft()) continue;
                TableDef left = read.getLeft();
                if (!Strings.equals(tableName, left.name)) continue;
                result.add(left);
            }
        }
        return result;
    }

    public static TimeSeries getTimeSeries(File tsdbFile, long[] tableIds, long startTimeMillis, long endTimeMillis) throws IOException {
        TLongArrayList timestamps = new TLongArrayList();
        ArrayList<long[]> metrics = new ArrayList<long[]>();
        try (TSDBReader reader = new TSDBReader(tsdbFile, 8192);){
            Either<TableDef, DataBlock> read;
            while ((read = reader.read()) != null) {
                if (!read.isRight()) continue;
                DataBlock data = read.getRight();
                long baseTs = data.baseTimestamp;
                for (DataRow row : data.getValues()) {
                    for (long tableId : tableIds) {
                        long ts;
                        if (tableId != row.tableDefId || (ts = baseTs + (long)row.relTimeStamp) < startTimeMillis || ts > endTimeMillis) continue;
                        timestamps.add(ts);
                        metrics.add(Longs.toArray(row.data));
                    }
                }
            }
        }
        return new TimeSeries(timestamps.toArray(), (long[][])metrics.toArray((T[])new long[metrics.size()][]));
    }

    public static long[] getIds(Collection<TableDef> tableDefs) {
        long[] result = new long[tableDefs.size()];
        int i = 0;
        for (TableDef tdef : tableDefs) {
            result[i++] = tdef.id;
        }
        return result;
    }

    public static void writeCsvTable(File tsDB, String tableName, File output) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8));){
            TSDBQuery.writeAsCsv(writer, tsDB, tableName);
        }
    }

    public static void writeAsCsv(Appendable writer, File tsDB, String tableName) throws IOException {
        List<TableDef> tableDefs = TSDBQuery.getTableDef(tsDB, tableName);
        TimeSeries data = TSDBQuery.getTimeSeries(tsDB, TSDBQuery.getIds(tableDefs), 0L, Long.MAX_VALUE);
        Csv.writeCsvElement("timestamp", writer);
        for (ColumnDef col : tableDefs.get(0).getColumns()) {
            writer.append(',');
            Csv.writeCsvElement(col.getName(), writer);
        }
        writer.append('\n');
        long[] timestamps = data.getTimeStamps();
        long[][] values = data.getValues();
        for (int i = 0; i < timestamps.length; ++i) {
            Csv.writeCsvElement(DATE_FMT.print(timestamps[i]), writer);
            for (long val : values[i]) {
                writer.append(',');
                Csv.writeCsvElement(Long.toString(val), writer);
            }
            writer.append('\n');
        }
    }

    public static void writeCsvTables(File tsDB, Set<String> tableNames, File output) throws IOException {
        if (tableNames.isEmpty()) {
            return;
        }
        ListMultimap<String, TableDef> tables = TSDBQuery.getTables(tsDB, tableNames);
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8));){
            TableDef table = (TableDef)((Object)tables.values().iterator().next());
            Csv.writeCsvElement("table", writer);
            writer.append(',');
            Csv.writeCsvElement("timestamp", writer);
            for (ColumnDef columnDef : table.getColumns()) {
                writer.append(',');
                Csv.writeCsvElement(columnDef.getName(), writer);
            }
            ((Writer)writer).write(10);
            for (Map.Entry entry : tables.asMap().entrySet()) {
                TimeSeries data = TSDBQuery.getTimeSeries(tsDB, TSDBQuery.getIds((Collection)entry.getValue()), 0L, Long.MAX_VALUE);
                long[] timestamps = data.getTimeStamps();
                long[][] values = data.getValues();
                for (int i = 0; i < timestamps.length; ++i) {
                    Csv.writeCsvElement((CharSequence)entry.getKey(), writer);
                    writer.append(',');
                    Csv.writeCsvElement(formatter.print(timestamps[i]), writer);
                    for (long val : values[i]) {
                        writer.append(',');
                        Csv.writeCsvElement(Long.toString(val), writer);
                    }
                    ((Writer)writer).write(10);
                }
            }
        }
    }

    @Nullable
    public static ColumnDef getColumnDefIfExists(TableDef td, String columnName) {
        for (ColumnDef cdef : td.getColumns()) {
            if (!Strings.equals(columnName, cdef.getName())) continue;
            return cdef;
        }
        return null;
    }

    @Nonnull
    public static ColumnDef getColumnDef(TableDef td, String columnName) {
        for (ColumnDef cdef : td.getColumns()) {
            if (!Strings.equals(columnName, cdef.getName())) continue;
            return cdef;
        }
        throw new IllegalArgumentException("Column " + columnName + " not found in " + (Object)((Object)td));
    }

    public static int getColumnIndex(TableDef td, String columnName) {
        int i = 0;
        for (ColumnDef cdef : td.getColumns()) {
            if (Strings.equals(columnName, cdef.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] getColumnNames(TableDef td) {
        List<ColumnDef> columns = td.getColumns();
        String[] result = new String[columns.size()];
        int i = 0;
        for (ColumnDef cd : columns) {
            result[i++] = cd.getName();
        }
        return result;
    }

    public static String[] getColumnUnitsOfMeasurement(TableDef td) {
        List<ColumnDef> columns = td.getColumns();
        String[] result = new String[columns.size()];
        int i = 0;
        for (ColumnDef cd : columns) {
            result[i++] = cd.getUnitOfMeasurement();
        }
        return result;
    }

    public static final class TableDefEx {
        private final TableDef tableDef;
        private long startTime;
        private long endTime;

        public TableDefEx(TableDef tableDef, long startTime, long endTime) {
            this.tableDef = tableDef;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public TableDef getTableDef() {
            return this.tableDef;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String toString() {
            return "TableDefEx{tableDef=" + (Object)((Object)this.tableDef) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
        }
    }
}

