/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.text;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.Strings;
import org.spf4j.text.FormatInfo;

public final class MessageFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private int hash = 0;
    private Locale locale;
    private StringBuilder pattern;
    private FormatInfo[] formats = new FormatInfo[0];
    private int maxOffset = -1;
    private static final int SEG_RAW = 0;
    private static final int SEG_INDEX = 1;
    private static final int SEG_TYPE = 2;
    private static final int SEG_MODIFIER = 3;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_DATE = 2;
    private static final int TYPE_TIME = 3;
    private static final int TYPE_CHOICE = 4;
    private static final String[] TYPE_KEYWORDS = new String[]{"", "number", "date", "time", "choice"};
    private static final int MODIFIER_DEFAULT = 0;
    private static final int MODIFIER_CURRENCY = 1;
    private static final int MODIFIER_PERCENT = 2;
    private static final int MODIFIER_INTEGER = 3;
    private static final String[] NUMBER_MODIFIER_KEYWORDS = new String[]{"", "currency", "percent", "integer"};
    private static final String[] DATE_TIME_MODIFIER_KEYWORDS = new String[]{"", "short", "medium", "long", "full"};
    private static final int[] DATE_TIME_MODIFIERS = new int[]{2, 3, 2, 1, 0};
    private static final Constructor<AttributedString> ASC = AccessController.doPrivileged(new PrivilegedAction<Constructor<AttributedString>>(){

        @Override
        public Constructor<AttributedString> run() {
            try {
                Constructor<AttributedString> constructor = AttributedString.class.getDeclaredConstructor(AttributedCharacterIterator[].class);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
    });

    public MessageFormat(String pattern) {
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.applyPattern(pattern);
    }

    public MessageFormat(String pattern, Locale locale) {
        this.locale = locale;
        this.applyPattern(pattern);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public void applyPattern(String pattern) {
        StringBuilder[] segments = new StringBuilder[4];
        int length = pattern.length();
        segments[0] = new StringBuilder(length);
        int part = 0;
        int formatNumber = 0;
        boolean inQuote = false;
        int braceStack = 0;
        this.maxOffset = -1;
        block7: for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (part == 0) {
                if (ch == '\'') {
                    int next = i + 1;
                    if (next < length && pattern.charAt(next) == '\'') {
                        segments[part].append(ch);
                        i = next;
                        continue;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    part = 1;
                    if (segments[part] != null) continue;
                    segments[part] = new StringBuilder();
                    continue;
                }
                segments[part].append(ch);
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                if (ch != '\'') continue;
                inQuote = false;
                continue;
            }
            switch (ch) {
                case ',': {
                    if (part < 3) {
                        if (segments[++part] != null) continue block7;
                        segments[part] = new StringBuilder();
                        continue block7;
                    }
                    segments[part].append(ch);
                    continue block7;
                }
                case '{': {
                    ++braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '}': {
                    if (braceStack == 0) {
                        part = 0;
                        this.makeFormat(formatNumber, segments);
                        ++formatNumber;
                        segments[1] = null;
                        segments[2] = null;
                        segments[3] = null;
                        continue block7;
                    }
                    --braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case ' ': {
                    if (part == 2 && segments[2].length() <= 0) continue block7;
                    segments[part].append(ch);
                    continue block7;
                }
                case '\'': {
                    inQuote = true;
                }
                default: {
                    segments[part].append(ch);
                }
            }
        }
        if (braceStack == 0 && part != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern: " + pattern);
        }
        this.pattern = segments[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "ITC_INHERITANCE_TYPE_CHECKING"})
    public String toPattern() {
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i <= this.maxOffset; ++i) {
            FormatInfo finfo = this.formats[i];
            int offset = finfo.getOffset();
            MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, offset, result);
            lastOffset = offset;
            result.append('{').append(finfo.getArgumentNumber());
            Format fmt = finfo.getFormat();
            if (fmt != null) {
                if (fmt instanceof NumberFormat) {
                    if (fmt.equals(NumberFormat.getInstance(this.locale))) {
                        result.append(",number");
                    } else if (fmt.equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        result.append(",number,currency");
                    } else if (fmt.equals(NumberFormat.getPercentInstance(this.locale))) {
                        result.append(",number,percent");
                    } else if (fmt.equals(NumberFormat.getIntegerInstance(this.locale))) {
                        result.append(",number,integer");
                    } else if (fmt instanceof DecimalFormat) {
                        result.append(",number,").append(((DecimalFormat)fmt).toPattern());
                    } else {
                        if (!(fmt instanceof ChoiceFormat)) throw new UnsupportedOperationException("Unsupported format " + fmt);
                        result.append(",choice,").append(((ChoiceFormat)fmt).toPattern());
                    }
                } else {
                    int index;
                    if (!(fmt instanceof DateFormat)) throw new UnsupportedOperationException("Unsupported format " + fmt);
                    for (index = 0; index < DATE_TIME_MODIFIERS.length; ++index) {
                        DateFormat df = DateFormat.getDateInstance(DATE_TIME_MODIFIERS[index], this.locale);
                        if (fmt.equals(df)) {
                            result.append(",date");
                            break;
                        }
                        df = DateFormat.getTimeInstance(DATE_TIME_MODIFIERS[index], this.locale);
                        if (!fmt.equals(df)) continue;
                        result.append(",time");
                        break;
                    }
                    if (index >= DATE_TIME_MODIFIERS.length) {
                        if (!(fmt instanceof SimpleDateFormat)) throw new UnsupportedOperationException("Unsupported format " + fmt);
                        result.append(",date,").append(((SimpleDateFormat)fmt).toPattern());
                    } else if (index != 0) {
                        result.append(',').append(DATE_TIME_MODIFIER_KEYWORDS[index]);
                    }
                }
            }
            result.append('}');
        }
        MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.pattern.length(), result);
        return result.toString();
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            FormatInfo finfo = this.formats[i];
            int j = finfo.getArgumentNumber();
            if (j >= newFormats.length) continue;
            this.formats[i] = new FormatInfo(newFormats[j], finfo.getOffset(), j);
        }
    }

    public void setFormats(Format[] newFormats) {
        int runsToCopy = newFormats.length;
        if (runsToCopy > this.maxOffset + 1) {
            runsToCopy = this.maxOffset + 1;
        }
        for (int i = 0; i < runsToCopy; ++i) {
            FormatInfo finfo = this.formats[i];
            this.formats[i] = new FormatInfo(newFormats[i], finfo.getOffset(), finfo.getArgumentNumber());
        }
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        for (int j = 0; j <= this.maxOffset; ++j) {
            FormatInfo finfo = this.formats[j];
            int argNr = finfo.getArgumentNumber();
            if (argNr != argumentIndex) continue;
            this.formats[j] = new FormatInfo(newFormat, finfo.getOffset(), argNr);
        }
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        FormatInfo finfo = this.formats[formatElementIndex];
        this.formats[formatElementIndex] = new FormatInfo(newFormat, finfo.getOffset(), finfo.getArgumentNumber());
    }

    public Format[] getFormats() {
        Format[] resultArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, resultArray, 0, this.maxOffset + 1);
        return resultArray;
    }

    public final Appendable format(Object[] arguments, Appendable result, FieldPosition pos) throws IOException {
        return this.subformat(arguments, result, pos, null);
    }

    public static String format(String pattern, Object ... arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    public final Appendable format(Object arguments, Appendable result, FieldPosition pos) throws IOException {
        return this.subformat((Object[])arguments, result, pos, null);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(@Nonnull Object arguments) {
        StringBuilder result = new StringBuilder();
        ArrayList<AttributedCharacterIterator> iterators = new ArrayList<AttributedCharacterIterator>();
        try {
            this.subformat((Object[])arguments, result, null, iterators);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (iterators.isEmpty()) {
            return MessageFormat.createAttributedCharacterIterator("");
        }
        return MessageFormat.createAttributedCharacterIterator(iterators.toArray(new AttributedCharacterIterator[iterators.size()]));
    }

    @Nullable
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS", "STT_STRING_PARSING_A_FIELD"})
    public Object[] parse(@Nullable String source, @Nonnull ParsePosition pos) {
        if (source == null) {
            return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
        }
        int maximumArgumentNumber = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            FormatInfo finfo = this.formats[i];
            int argumentNumber = finfo.getArgumentNumber();
            if (argumentNumber <= maximumArgumentNumber) continue;
            maximumArgumentNumber = argumentNumber;
        }
        Object[] resultArray = new Object[maximumArgumentNumber + 1];
        int patternOffset = 0;
        int sourceOffset = pos.getIndex();
        ParsePosition tempStatus = new ParsePosition(0);
        for (int i = 0; i <= this.maxOffset; ++i) {
            FormatInfo finfo = this.formats[i];
            int len = finfo.getOffset() - patternOffset;
            if (len == 0 || Strings.regionMatches(this.pattern, patternOffset, source, sourceOffset, len)) {
                sourceOffset += len;
                patternOffset += len;
            } else {
                pos.setErrorIndex(sourceOffset);
                return null;
            }
            if (finfo.getFormat() == null) {
                int tempLength = i != this.maxOffset ? this.formats[i + 1].getOffset() : this.pattern.length();
                int next = patternOffset >= tempLength ? source.length() : source.indexOf(this.pattern.subSequence(patternOffset, tempLength).toString(), sourceOffset);
                if (next < 0) {
                    pos.setErrorIndex(sourceOffset);
                    return null;
                }
                String strValue = source.substring(sourceOffset, next);
                int argNr = finfo.getArgumentNumber();
                if (!strValue.equals("{" + argNr + "}")) {
                    resultArray[argNr] = source.substring(sourceOffset, next);
                }
                sourceOffset = next;
                continue;
            }
            tempStatus.setIndex(sourceOffset);
            resultArray[finfo.getArgumentNumber()] = finfo.getFormat().parseObject(source, tempStatus);
            if (tempStatus.getIndex() == sourceOffset) {
                pos.setErrorIndex(sourceOffset);
                return null;
            }
            sourceOffset = tempStatus.getIndex();
        }
        int len = this.pattern.length() - patternOffset;
        if (len != 0 && !Strings.regionMatches(this.pattern, patternOffset, source, sourceOffset, len)) {
            pos.setErrorIndex(sourceOffset);
            return null;
        }
        pos.setIndex(sourceOffset + len);
        return resultArray;
    }

    @Nonnull
    public Object[] parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object[] result = this.parse(source, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat source = " + source + " parse error!", pos.getErrorIndex());
        }
        return result;
    }

    @Override
    @Nonnull
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    @Override
    public MessageFormat clone() {
        MessageFormat other = (MessageFormat)super.clone();
        other.formats = (FormatInfo[])this.formats.clone();
        for (int i = 0; i < this.formats.length; ++i) {
            FormatInfo finfo = this.formats[i];
            if (finfo == null) continue;
            other.formats[i] = finfo.clone();
        }
        return other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFormat other = (MessageFormat)obj;
        return this.maxOffset == other.maxOffset && Strings.equals(this.pattern, other.pattern) && (this.locale != null && this.locale.equals(other.locale) || this.locale == null && other.locale == null) && Arrays.equals(this.formats, other.formats);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.hashcode(this.pattern);
        }
        return h;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            return (StringBuffer)this.format(obj, (Appendable)toAppendTo, pos);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @SuppressFBWarnings(value={"PDP_POORLY_DEFINED_PARAMETER", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private Appendable subformat(@Nullable Object[] arguments, @Nonnull Appendable result, @Nullable FieldPosition fp, @Nullable List<AttributedCharacterIterator> characterIterators) throws IOException {
        CharSequence cs = (CharSequence)((Object)result);
        int lastOffset = 0;
        int last = cs.length();
        for (int i = 0; i <= this.maxOffset; ++i) {
            FormatInfo finfo = this.formats[i];
            int offset = finfo.getOffset();
            result.append(this.pattern, lastOffset, offset);
            lastOffset = offset;
            int argumentNumber = finfo.getArgumentNumber();
            if (arguments == null || argumentNumber >= arguments.length) {
                result.append('{').append(Integer.toString(argumentNumber)).append('}');
                continue;
            }
            Object[] obj = arguments[argumentNumber];
            String arg = null;
            Format subFormatter = null;
            Format fmt = finfo.getFormat();
            if (obj == null) {
                arg = "null";
            } else if (fmt != null) {
                subFormatter = fmt;
                if (subFormatter instanceof ChoiceFormat && (arg = subFormatter.format(obj)).indexOf(123) >= 0) {
                    subFormatter = new MessageFormat(arg, this.locale);
                    obj = arguments;
                    arg = null;
                }
            } else if (obj instanceof Number) {
                subFormatter = NumberFormat.getInstance(this.locale);
            } else if (obj instanceof Date) {
                subFormatter = DateFormat.getDateTimeInstance(3, 3, this.locale);
            } else {
                arg = obj instanceof String ? (String)obj : obj.toString();
            }
            if (characterIterators != null) {
                int cl = cs.length();
                if (last != cl) {
                    characterIterators.add(MessageFormat.createAttributedCharacterIterator(cs.subSequence(last, cl).toString()));
                    last = cl;
                }
                if (subFormatter != null) {
                    AttributedCharacterIterator subIterator = subFormatter.formatToCharacterIterator(obj);
                    MessageFormat.append(result, subIterator);
                    int cl2 = cs.length();
                    if (last != cl2) {
                        characterIterators.add(this.createAttributedCharacterIterator(subIterator, Field.ARGUMENT, argumentNumber));
                        last = cl2;
                    }
                    arg = null;
                }
                if (arg == null || arg.length() <= 0) continue;
                result.append(arg);
                characterIterators.add(MessageFormat.createAttributedCharacterIterator(arg, Field.ARGUMENT, argumentNumber));
                last = cs.length();
                continue;
            }
            if (subFormatter != null) {
                arg = subFormatter.format(obj);
            }
            last = cs.length();
            result.append(arg);
            if (i == 0 && fp != null && Field.ARGUMENT.equals(fp.getFieldAttribute())) {
                fp.setBeginIndex(last);
                fp.setEndIndex(cs.length());
            }
            last = cs.length();
        }
        result.append(this.pattern, lastOffset, this.pattern.length());
        if (characterIterators != null && last != cs.length()) {
            characterIterators.add(MessageFormat.createAttributedCharacterIterator(cs.subSequence(last, cs.length()).toString()));
        }
        return result;
    }

    private static void append(Appendable result, CharacterIterator iterator) throws IOException {
        char first = iterator.first();
        if (first != '\uffff') {
            char aChar;
            result.append(first);
            while ((aChar = iterator.next()) != '\uffff') {
                result.append(aChar);
            }
        }
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    private void makeFormat(int offsetNumber, StringBuilder[] textSegments) {
        int argumentNumber;
        String[] segments = new String[textSegments.length];
        for (int i = 0; i < textSegments.length; ++i) {
            StringBuilder oneseg = textSegments[i];
            segments[i] = oneseg != null ? oneseg.toString() : "";
        }
        try {
            argumentNumber = Integer.parseInt(segments[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("can't parse argument number: " + segments[1], e);
        }
        if (argumentNumber < 0) {
            throw new IllegalArgumentException("negative argument number: " + argumentNumber);
        }
        if (offsetNumber >= this.formats.length) {
            int newLength = Math.max(4, this.formats.length << 2);
            FormatInfo[] newFormats = new FormatInfo[newLength];
            System.arraycopy(this.formats, 0, newFormats, 0, this.maxOffset + 1);
            this.formats = newFormats;
        }
        int oldMaxOffset = this.maxOffset;
        this.maxOffset = offsetNumber;
        Format newFormat = null;
        if (segments[2].length() != 0) {
            int type = MessageFormat.findKeyword(segments[2], TYPE_KEYWORDS);
            block4 : switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    switch (MessageFormat.findKeyword(segments[3], NUMBER_MODIFIER_KEYWORDS)) {
                        case 0: {
                            newFormat = NumberFormat.getInstance(this.locale);
                            break block4;
                        }
                        case 1: {
                            newFormat = NumberFormat.getCurrencyInstance(this.locale);
                            break block4;
                        }
                        case 2: {
                            newFormat = NumberFormat.getPercentInstance(this.locale);
                            break block4;
                        }
                        case 3: {
                            newFormat = NumberFormat.getIntegerInstance(this.locale);
                            break block4;
                        }
                    }
                    try {
                        newFormat = new DecimalFormat(segments[3], DecimalFormatSymbols.getInstance(this.locale));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        this.maxOffset = oldMaxOffset;
                        throw e;
                    }
                }
                case 2: 
                case 3: {
                    int mod = MessageFormat.findKeyword(segments[3], DATE_TIME_MODIFIER_KEYWORDS);
                    if (mod >= 0 && mod < DATE_TIME_MODIFIER_KEYWORDS.length) {
                        if (type == 2) {
                            newFormat = DateFormat.getDateInstance(DATE_TIME_MODIFIERS[mod], this.locale);
                            break;
                        }
                        newFormat = DateFormat.getTimeInstance(DATE_TIME_MODIFIERS[mod], this.locale);
                        break;
                    }
                    try {
                        newFormat = new SimpleDateFormat(segments[3], this.locale);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        this.maxOffset = oldMaxOffset;
                        throw e;
                    }
                }
                case 4: {
                    try {
                        newFormat = new ChoiceFormat(segments[3]);
                        break;
                    }
                    catch (Exception e) {
                        this.maxOffset = oldMaxOffset;
                        throw new IllegalArgumentException("Choice Pattern incorrect: " + segments[3], e);
                    }
                }
                default: {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("unknown format type: " + segments[2]);
                }
            }
        }
        this.formats[offsetNumber] = new FormatInfo(newFormat, segments[0].length(), argumentNumber);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="optimization")
    private static final int findKeyword(String s, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return i;
        }
        String ls = s.trim().toLowerCase(Locale.ROOT);
        if (ls != s) {
            for (int i = 0; i < list.length; ++i) {
                if (!ls.equals(list[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static final void copyAndFixQuotes(CharSequence source, int start, int end, StringBuilder target) {
        boolean quoted = false;
        for (int i = start; i < end; ++i) {
            char ch = source.charAt(i);
            if (ch == '{') {
                if (!quoted) {
                    target.append('\'');
                    quoted = true;
                }
                target.append(ch);
                continue;
            }
            if (ch == '\'') {
                target.append("''");
                continue;
            }
            if (quoted) {
                target.append('\'');
                quoted = false;
            }
            target.append(ch);
        }
        if (quoted) {
            target.append('\'');
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isValid;
        in.defaultReadObject();
        boolean bl = isValid = this.maxOffset >= -1 && this.formats.length > this.maxOffset;
        if (isValid) {
            int lastOffset = this.pattern.length() + 1;
            for (int i = this.maxOffset; i >= 0; --i) {
                FormatInfo finfo = this.formats[i];
                int offset = finfo.getOffset();
                if (offset < 0 || offset > lastOffset) {
                    isValid = false;
                    break;
                }
                lastOffset = offset;
            }
        }
        if (!isValid) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream: " + in);
        }
    }

    static AttributedCharacterIterator createAttributedCharacterIterator(String s) {
        AttributedString as = new AttributedString(s);
        return as.getIterator();
    }

    static AttributedCharacterIterator createAttributedCharacterIterator(AttributedCharacterIterator[] iterators) {
        AttributedString as;
        try {
            as = ASC.newInstance(iterators);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return as.getIterator();
    }

    static AttributedCharacterIterator createAttributedCharacterIterator(String string, AttributedCharacterIterator.Attribute key, Object value) {
        AttributedString as = new AttributedString(string);
        as.addAttribute(key, value);
        return as.getIterator();
    }

    AttributedCharacterIterator createAttributedCharacterIterator(AttributedCharacterIterator iterator, AttributedCharacterIterator.Attribute key, Object value) {
        AttributedString as = new AttributedString(iterator);
        as.addAttribute(key, value);
        return as.getIterator();
    }

    public String toString() {
        return "MessageFormat{locale=" + this.locale + ", pattern=" + this.pattern + '}';
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String name) {
            super(name);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            Class<?> aClass = this.getClass();
            if (aClass != Field.class) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve: " + aClass);
            }
            return ARGUMENT;
        }
    }
}

