/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Method;
import org.spf4j.ds.Graph;
import org.spf4j.ds.HashMapGraph;
import org.spf4j.stackmonitor.InvokedMethod;

@ParametersAreNonnullByDefault
public final class SampleNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int sampleCount;
    private TMap<Method, SampleNode> subNodes;

    public SampleNode(StackTraceElement[] stackTrace, int from) {
        this.sampleCount = 1;
        if (from >= 0) {
            this.subNodes = new THashMap();
            this.subNodes.put((Object)Method.getMethod(stackTrace[from]), (Object)new SampleNode(stackTrace, from - 1));
        }
    }

    public static SampleNode createSampleNode(StackTraceElement ... stackTrace) {
        SampleNode result;
        SampleNode prevResult = result = new SampleNode(1, null);
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement elem = stackTrace[i];
            if (prevResult.subNodes == null) {
                prevResult.subNodes = new THashMap();
            }
            SampleNode node = new SampleNode(1, null);
            prevResult.subNodes.put((Object)Method.getMethod(elem), (Object)node);
            prevResult = node;
        }
        return result;
    }

    public static void addToSampleNode(SampleNode node, StackTraceElement ... stackTrace) {
        SampleNode prevResult = node;
        ++prevResult.sampleCount;
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            SampleNode nNode;
            StackTraceElement elem = stackTrace[i];
            Method method = Method.getMethod(elem);
            if (prevResult.subNodes == null) {
                prevResult.subNodes = new THashMap();
                nNode = new SampleNode(1, null);
                prevResult.subNodes.put((Object)method, (Object)nNode);
            } else {
                nNode = (SampleNode)prevResult.subNodes.get((Object)method);
                if (nNode != null) {
                    ++nNode.sampleCount;
                } else {
                    nNode = new SampleNode(1, null);
                    prevResult.subNodes.put((Object)method, (Object)nNode);
                }
            }
            prevResult = nNode;
        }
    }

    public static SampleNode clone(SampleNode node) {
        if (node.subNodes == null) {
            return new SampleNode(node.sampleCount, null);
        }
        THashMap newSubNodes = new THashMap(node.subNodes.size());
        node.subNodes.forEachEntry((a, b) -> {
            newSubNodes.put(a, (Object)SampleNode.clone(b));
            return true;
        });
        return new SampleNode(node.sampleCount, (TMap<Method, SampleNode>)newSubNodes);
    }

    public static SampleNode aggregate(SampleNode node1, SampleNode node2) {
        THashMap newSubNodes;
        int newSampleCount = node1.sampleCount + node2.sampleCount;
        if (node1.subNodes == null && node2.subNodes == null) {
            newSubNodes = null;
        } else if (node1.subNodes == null) {
            newSubNodes = SampleNode.cloneSubNodes(node2);
        } else if (node2.subNodes == null) {
            newSubNodes = SampleNode.cloneSubNodes(node1);
        } else {
            THashMap ns = new THashMap(node1.subNodes.size() + node2.subNodes.size());
            node1.subNodes.forEachEntry((m, b) -> {
                SampleNode other = (SampleNode)node2.subNodes.get(m);
                if (other == null) {
                    ns.put(m, (Object)SampleNode.clone(b));
                } else {
                    ns.put(m, (Object)SampleNode.aggregate(b, other));
                }
                return true;
            });
            node2.subNodes.forEachEntry((m, b) -> {
                if (!node1.subNodes.containsKey(m)) {
                    ns.put(m, (Object)SampleNode.clone(b));
                }
                return true;
            });
            newSubNodes = ns;
        }
        return new SampleNode(newSampleCount, (TMap<Method, SampleNode>)newSubNodes);
    }

    public static TMap<Method, SampleNode> cloneSubNodes(SampleNode node) {
        THashMap ns = new THashMap(node.subNodes.size());
        SampleNode.putAllClones(node.subNodes, (TMap<Method, SampleNode>)ns);
        return ns;
    }

    public static void putAllClones(TMap<Method, SampleNode> source, TMap<Method, SampleNode> destination) {
        source.forEachEntry((a, b) -> {
            destination.put(a, (Object)SampleNode.clone(b));
            return true;
        });
    }

    public SampleNode(int count, @Nullable TMap<Method, SampleNode> subNodes) {
        this.sampleCount = count;
        this.subNodes = subNodes;
    }

    public void addSample(StackTraceElement[] stackTrace, int from) {
        ++this.sampleCount;
        if (from >= 0) {
            Method method = Method.getMethod(stackTrace[from]);
            SampleNode subNode = null;
            if (this.subNodes == null) {
                this.subNodes = new THashMap();
            } else {
                subNode = (SampleNode)this.subNodes.get((Object)method);
            }
            if (subNode == null) {
                this.subNodes.put((Object)method, (Object)new SampleNode(stackTrace, from - 1));
            } else {
                subNode.addSample(stackTrace, from - 1);
            }
        }
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    @Nullable
    public TMap<Method, SampleNode> getSubNodes() {
        return this.subNodes;
    }

    public String toString() {
        return "SampleNode{count=" + this.sampleCount + (this.subNodes == null || this.subNodes.isEmpty() ? "" : ", subNodes=" + this.subNodes) + '}';
    }

    public int height() {
        if (this.subNodes == null) {
            return 1;
        }
        int subHeight = 0;
        for (SampleNode node : this.subNodes.values()) {
            int nHeight = node.height();
            if (nHeight <= subHeight) continue;
            subHeight = nHeight;
        }
        return subHeight + 1;
    }

    public int getNrNodes() {
        if (this.subNodes == null) {
            return 1;
        }
        int nrNodes = 0;
        for (SampleNode node : this.subNodes.values()) {
            nrNodes += node.getNrNodes();
        }
        return nrNodes + 1;
    }

    @Nullable
    public SampleNode filteredBy(Predicate<Method> predicate) {
        int newCount = this.sampleCount;
        THashMap sns = null;
        if (this.subNodes != null) {
            for (Map.Entry entry : this.subNodes.entrySet()) {
                SampleNode sn2;
                Method method = (Method)entry.getKey();
                SampleNode sn = (SampleNode)entry.getValue();
                if (predicate.test(method)) {
                    newCount -= sn.getSampleCount();
                    continue;
                }
                if (sns == null) {
                    sns = new THashMap();
                }
                if ((sn2 = sn.filteredBy(predicate)) == null) {
                    newCount -= sn.getSampleCount();
                    continue;
                }
                newCount -= sn.getSampleCount() - sn2.getSampleCount();
                sns.put((Object)method, (Object)sn2);
            }
        }
        if (newCount == 0) {
            return null;
        }
        if (newCount < 0) {
            throw new IllegalStateException("child sample counts must be <= parent sample count, detail: " + this);
        }
        return new SampleNode(newCount, (TMap<Method, SampleNode>)sns);
    }

    public void forEach(InvocationHandler handler, Method from, Method to, Map<Method, Integer> ancestors) {
        handler.handle(from, to, this.sampleCount, ancestors);
        if (this.subNodes != null) {
            Integer val = ancestors.get(to);
            val = val != null ? Integer.valueOf(val + 1) : Integer.valueOf(1);
            ancestors.put(to, val);
            for (Map.Entry subs : this.subNodes.entrySet()) {
                Method toKey = (Method)subs.getKey();
                ((SampleNode)subs.getValue()).forEach(handler, to, toKey, ancestors);
            }
            val = ancestors.get(to);
            if (val == 1) {
                ancestors.remove(to);
            } else {
                val = val - 1;
                ancestors.put(to, val);
            }
        }
    }

    @Nonnull
    public static Graph<InvokedMethod, InvocationCount> toGraph(SampleNode rootNode) {
        HashMapGraph<InvokedMethod, InvocationCount> result = new HashMapGraph<InvokedMethod, InvocationCount>();
        rootNode.forEach((pfrom, pto, count, ancestors) -> {
            InvokedMethod to;
            Integer val = (Integer)ancestors.get(pfrom);
            InvokedMethod from = val != null ? new InvokedMethod(pfrom, val - 1) : new InvokedMethod(pfrom, 0);
            InvocationCount ic = (InvocationCount)result.getEdge(from, to = (val = (Integer)ancestors.get(pto)) != null ? new InvokedMethod(pto, val) : new InvokedMethod(pto, 0));
            if (ic == null) {
                result.add(new InvocationCount(count), from, to);
            } else {
                ic.setValue(count + ic.getValue());
            }
        }, Method.ROOT, Method.ROOT, new HashMap<Method, Integer>());
        return result;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.sampleCount;
        return 89 * hash + Objects.hashCode(this.subNodes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleNode other = (SampleNode)obj;
        if (this.sampleCount != other.sampleCount) {
            return false;
        }
        if (this.subNodes == other.subNodes) {
            return true;
        }
        if (this.subNodes != null && other.subNodes == null && this.subNodes.isEmpty()) {
            return true;
        }
        if (this.subNodes == null && other.subNodes != null && other.subNodes.isEmpty()) {
            return true;
        }
        return Objects.equals(this.subNodes, other.subNodes);
    }

    public static final class InvocationCount {
        private int value;

        public InvocationCount(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "InvocationCount{value=" + this.value + '}';
        }
    }

    public static interface InvocationHandler {
        public void handle(Method var1, Method var2, int var3, Map<Method, Integer> var4);
    }
}

