/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import org.spf4j.base.Throwables;
import org.spf4j.stackmonitor.AbstractStackCollector;

public final class FastStackCollector
extends AbstractStackCollector {
    private static final MethodHandle GET_THREADS;
    private static final MethodHandle DUMP_THREADS;
    private static final String[] IGNORED_THREADS;
    private final Predicate<Thread> threadFilter;
    private Thread[] requestFor = new Thread[0];

    public FastStackCollector(boolean collectForMain, String ... xtraIgnoredThreads) {
        this(FastStackCollector.createNameBasedFilter(collectForMain, xtraIgnoredThreads));
    }

    public static Predicate<Thread> createNameBasedFilter(boolean collectForMain, String[] xtraIgnoredThreads) {
        THashSet ignoredThreads = new THashSet(Arrays.asList(IGNORED_THREADS));
        if (!collectForMain) {
            ignoredThreads.add("main");
        }
        ignoredThreads.addAll(Arrays.asList(xtraIgnoredThreads));
        return new ThreadNamesPredicate((Set<String>)ignoredThreads);
    }

    public FastStackCollector(Predicate<Thread> threadFilter) {
        this.threadFilter = threadFilter;
    }

    public static Thread[] getThreads() {
        try {
            return GET_THREADS.invokeExact();
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static StackTraceElement[][] getStackTraces(Thread ... threads) {
        StackTraceElement[][] stackDump;
        try {
            stackDump = DUMP_THREADS.invokeExact(threads);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return stackDump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
    public static void dumpToPrintStream(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            Thread[] threads = FastStackCollector.getThreads();
            StackTraceElement[][] stackTraces = FastStackCollector.getStackTraces(threads);
            for (int i = 0; i < threads.length; ++i) {
                StackTraceElement[] stackTrace = stackTraces[i];
                if (stackTrace == null || stackTrace.length <= 0) continue;
                Thread thread = threads[i];
                stream.println("Thread " + thread.getName());
                try {
                    Throwables.writeTo(stackTrace, (Appendable)stream, Throwables.Detail.SHORT_PACKAGE);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void sample(Thread ignore) {
        Thread[] threads = FastStackCollector.getThreads();
        int nrThreads = threads.length;
        if (this.requestFor.length < nrThreads) {
            this.requestFor = new Thread[nrThreads - 1];
        }
        int j = 0;
        for (int i = 0; i < nrThreads; ++i) {
            Thread th = threads[i];
            if (ignore == th || this.threadFilter.apply((Object)th)) continue;
            this.requestFor[j++] = th;
        }
        Arrays.fill(this.requestFor, j, this.requestFor.length, null);
        StackTraceElement[][] stackDump = FastStackCollector.getStackTraces(this.requestFor);
        for (int i = 0; i < j; ++i) {
            StackTraceElement[] stackTrace = stackDump[i];
            if (stackTrace != null && stackTrace.length > 0) {
                this.addSample(stackTrace);
                continue;
            }
            this.addSample(new StackTraceElement[]{new StackTraceElement("Thread", this.requestFor[i].getName(), "", 0)});
        }
    }

    static {
        Method dumpThreads;
        Method getThreads;
        IGNORED_THREADS = new String[]{"Finalizer", "Signal Dispatcher", "Reference Handler", "Attach Listener", "VM JFR Buffer Thread"};
        try {
            getThreads = Thread.class.getDeclaredMethod("getThreads", new Class[0]);
            dumpThreads = Thread.class.getDeclaredMethod("dumpThreads", Thread[].class);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        AccessController.doPrivileged(() -> {
            getThreads.setAccessible(true);
            dumpThreads.setAccessible(true);
            return null;
        });
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            GET_THREADS = lookup.unreflect(getThreads);
            DUMP_THREADS = lookup.unreflect(dumpThreads);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final class ThreadNamesPredicate
    implements Predicate<Thread> {
        private final Set<String> ignoredThreadNames;

        public ThreadNamesPredicate(Set<String> ignoredThreadNames) {
            this.ignoredThreadNames = ignoredThreadNames;
        }

        public boolean apply(@Nonnull Thread input) {
            return this.ignoredThreadNames.contains(input.getName());
        }
    }
}

