/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.base.Function;
import javax.annotation.concurrent.GuardedBy;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.StackCollector;

public abstract class AbstractStackCollector
implements StackCollector {
    private final Object sampleSync = new Object();
    @GuardedBy(value="sampleSync")
    private SampleNode samples;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SampleNode applyOnSamples(Function<SampleNode, SampleNode> predicate) {
        Object object = this.sampleSync;
        synchronized (object) {
            SampleNode result = this.samples;
            this.samples = (SampleNode)predicate.apply((Object)this.samples);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SampleNode clear() {
        Object object = this.sampleSync;
        synchronized (object) {
            SampleNode result = this.samples;
            this.samples = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addSample(StackTraceElement[] stackTrace) {
        Object object = this.sampleSync;
        synchronized (object) {
            if (this.samples == null) {
                this.samples = SampleNode.createSampleNode(stackTrace);
            } else {
                SampleNode.addToSampleNode(this.samples, stackTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        Object object = this.sampleSync;
        synchronized (object) {
            return "AbstractStackCollector{samples=" + this.samples + '}';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNrNodes() {
        Object object = this.sampleSync;
        synchronized (object) {
            if (this.samples == null) {
                return 0;
            }
            return this.samples.getNrNodes();
        }
    }
}

